/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.transform;

import ai.tripl.arc.api.API;
import ai.tripl.arc.transform.DiffTransform;
import ai.tripl.arc.transform.DiffTransformStage;
import ai.tripl.arc.util.log.logger.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple10;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DiffTransformStage$
implements Serializable {
    public static final DiffTransformStage$ MODULE$;

    static {
        new DiffTransformStage$();
    }

    public Option<Dataset<Row>> execute(DiffTransformStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset inputLeftDF = spark.table(stage.inputLeftView());
        Dataset inputRightDF = spark.table(stage.inputRightView());
        Dataset leftHashDF = inputLeftDF.withColumn("_hash", functions$.MODULE$.sha2(functions$.MODULE$.to_json(functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])inputLeftDF.columns()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))))), 512));
        Dataset rightHashDF = inputRightDF.withColumn("_hash", functions$.MODULE$.sha2(functions$.MODULE$.to_json(functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])inputRightDF.columns()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))))), 512));
        Dataset transformedDF = leftHashDF.joinWith(rightHashDF, leftHashDF.apply("_hash").$eq$eq$eq((Object)rightHashDF.apply("_hash")), "full");
        Object object = stage.persist() && !transformedDF.isStreaming() ? transformedDF.persist(arcContext.storageLevel()) : BoxedUnit.UNIT;
        Dataset outputIntersectionDF = transformedDF.filter(functions$.MODULE$.col("_1").isNotNull()).filter(functions$.MODULE$.col("_2").isNotNull()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("_1.*")})).drop("_hash");
        Dataset outputLeftDF = transformedDF.filter(functions$.MODULE$.col("_2").isNull()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("_1.*")})).drop("_hash");
        Dataset outputRightDF = transformedDF.filter(functions$.MODULE$.col("_1").isNull()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("_2.*")})).drop("_hash");
        stage.outputIntersectionView().foreach((Function1)new Serializable(arcContext, outputIntersectionDF){
            public static final long serialVersionUID = 0L;
            private final API.ARCContext arcContext$1;
            private final Dataset outputIntersectionDF$1;

            public final void apply(String outputIntersectionView) {
                if (this.arcContext$1.immutableViews()) {
                    this.outputIntersectionDF$1.createTempView(outputIntersectionView);
                } else {
                    this.outputIntersectionDF$1.createOrReplaceTempView(outputIntersectionView);
                }
            }
            {
                this.arcContext$1 = arcContext$1;
                this.outputIntersectionDF$1 = outputIntersectionDF$1;
            }
        });
        stage.outputLeftView().foreach((Function1)new Serializable(arcContext, outputLeftDF){
            public static final long serialVersionUID = 0L;
            private final API.ARCContext arcContext$1;
            private final Dataset outputLeftDF$1;

            public final void apply(String outputLeftView) {
                if (this.arcContext$1.immutableViews()) {
                    this.outputLeftDF$1.createTempView(outputLeftView);
                } else {
                    this.outputLeftDF$1.createOrReplaceTempView(outputLeftView);
                }
            }
            {
                this.arcContext$1 = arcContext$1;
                this.outputLeftDF$1 = outputLeftDF$1;
            }
        });
        stage.outputRightView().foreach((Function1)new Serializable(arcContext, outputRightDF){
            public static final long serialVersionUID = 0L;
            private final API.ARCContext arcContext$1;
            private final Dataset outputRightDF$1;

            public final void apply(String outputRightView) {
                if (this.arcContext$1.immutableViews()) {
                    this.outputRightDF$1.createTempView(outputRightView);
                } else {
                    this.outputRightDF$1.createOrReplaceTempView(outputRightView);
                }
            }
            {
                this.arcContext$1 = arcContext$1;
                this.outputRightDF$1 = outputRightDF$1;
            }
        });
        return Option$.MODULE$.apply((Object)outputIntersectionDF);
    }

    public DiffTransformStage apply(DiffTransform plugin, String name, Option<String> description, String inputLeftView, String inputRightView, Option<String> outputIntersectionView, Option<String> outputLeftView, Option<String> outputRightView, Map<String, String> params, boolean persist) {
        return new DiffTransformStage(plugin, name, description, inputLeftView, inputRightView, outputIntersectionView, outputLeftView, outputRightView, params, persist);
    }

    public Option<Tuple10<DiffTransform, String, Option<String>, String, String, Option<String>, Option<String>, Option<String>, Map<String, String>, Object>> unapply(DiffTransformStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputLeftView(), (Object)x$0.inputRightView(), x$0.outputIntersectionView(), x$0.outputLeftView(), x$0.outputRightView(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DiffTransformStage$() {
        MODULE$ = this;
    }
}

