/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.config;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.API$AmazonS3EncryptionType$;
import ai.tripl.arc.api.API$AmazonS3EncryptionType$SSE_C$;
import ai.tripl.arc.api.API$AmazonS3EncryptionType$SSE_KMS$;
import ai.tripl.arc.api.API$AmazonS3EncryptionType$SSE_S3$;
import ai.tripl.arc.api.API$Authentication$AmazonAnonymous$;
import ai.tripl.arc.api.API$EncodingTypeBase64$;
import ai.tripl.arc.api.API$EncodingTypeHexadecimal$;
import ai.tripl.arc.api.API$FailModeTypeFailFast$;
import ai.tripl.arc.api.API$FailModeTypePermissive$;
import ai.tripl.arc.api.API$OutputModeTypeAppend$;
import ai.tripl.arc.api.API$OutputModeTypeComplete$;
import ai.tripl.arc.api.API$OutputModeTypeUpdate$;
import ai.tripl.arc.api.Delimiter;
import ai.tripl.arc.api.Delimiter$Comma$;
import ai.tripl.arc.api.Delimiter$Custom$;
import ai.tripl.arc.api.Delimiter$DefaultHive$;
import ai.tripl.arc.api.Delimiter$Pipe$;
import ai.tripl.arc.api.QuoteCharacter;
import ai.tripl.arc.api.QuoteCharacter$Disabled$;
import ai.tripl.arc.api.QuoteCharacter$DoubleQuote$;
import ai.tripl.arc.api.QuoteCharacter$SingleQuote$;
import ai.tripl.arc.config.ConfigUtils$;
import ai.tripl.arc.config.Error;
import ai.tripl.arc.config.Error$;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.ControlUtils$;
import ai.tripl.arc.util.EitherUtils$;
import ai.tripl.arc.util.MetadataSchema$;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.spark.SparkFiles$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public final class ConfigUtils$ {
    public static final ConfigUtils$ MODULE$;

    static {
        new ConfigUtils$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Either<List<Error.Error>, String> getConfigString(URI uri, API.ARCContext arcContext, SparkSession spark, Logger logger) {
        String value;
        String string10;
        String string = uri.getScheme();
        if ("local".equals(string)) {
            URI filePath = new URI(SparkFiles$.MODULE$.get(uri.getPath()));
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(filePath, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if ("file".equals(string)) {
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if ("classpath".equals(string)) {
            String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.getHost(), uri.getPath()}));
            String etlConfString = (String)ControlUtils$.MODULE$.using(this.getClass().getResourceAsStream(path), new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(InputStream is) {
                    return Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                }
            });
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if ("dbfs".equals(string)) {
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if ("s3a".equals(string)) {
            None$ none$;
            String value2;
            String string3;
            String value3;
            String string2;
            Option s3aAccessKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.access.key").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_S3A_ACCESS_KEY");
                }
            });
            Option s3aSecretKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.secret.key").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_S3A_SECRET_KEY");
                }
            });
            Option s3aEndpoint = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.endpoint").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_S3A_ENDPOINT");
                }
            });
            Option s3aConnectionSSLEnabled = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.connection.ssl.enabled").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_S3A_CONNECTION_SSL_ENABLED");
                }
            });
            Option option = s3aAccessKey;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AWS Access Key not provided for: ", ". Set etl.config.fs.s3a.access.key property or ETL_CONF_S3A_ACCESS_KEY environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some = (Some)option;
            String accessKey = string2 = (value3 = (String)some.x());
            Option option2 = s3aSecretKey;
            if (!(option2 instanceof Some)) {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AWS Secret Key not provided for: ", ". Set etl.config.fs.s3a.secret.key property or ETL_CONF_S3A_SECRET_KEY environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some2 = (Some)option2;
            String secretKey = string3 = (value2 = (String)some2.x());
            Option option3 = s3aConnectionSSLEnabled;
            if (option3 instanceof Some) {
                Some some3 = (Some)option3;
                String value32 = (String)some3.x();
                try {
                    none$ = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(value32)).toBoolean()));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AWS SSL configuration incorrect for: ", ". Ensure etl.config.fs.s3a.connection.ssl.enabled or ETL_CONF_S3A_CONNECTION_SSL_ENABLED environment variables are boolean."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
                }
            } else {
                if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                none$ = None$.MODULE$;
            }
            None$ connectionSSLEnabled = none$;
            CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AmazonAccessKey(accessKey, secretKey, (Option<String>)s3aEndpoint, (Option<Object>)connectionSSLEnabled)), spark, logger);
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        boolean bl = "wasb".equals(string) ? true : "wasbs".equals(string);
        if (bl) {
            String value4;
            String string4;
            Option azureAccountName = arcContext.commandLineArguments().get((Object)"etl.config.fs.azure.account.name").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_AZURE_ACCOUNT_NAME");
                }
            });
            Option azureAccountKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.azure.account.key").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_AZURE_ACCOUNT_KEY");
                }
            });
            Option option = azureAccountName;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure Account Name not provided for: ", ". Set etl.config.fs.azure.account.name property or ETL_CONF_AZURE_ACCOUNT_NAME environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some = (Some)option;
            String accountName = string4 = (value4 = (String)some.x());
            Option option4 = azureAccountKey;
            if (option4 instanceof Some) {
                String value42;
                String string5;
                Some some4 = (Some)option4;
                String accountKey = string5 = (value42 = (String)some4.x());
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureSharedKey(accountName, accountKey)), spark, logger);
                String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                return package$.MODULE$.Right().apply((Object)etlConfString);
            }
            if (!None$.MODULE$.equals(option4)) throw new MatchError((Object)option4);
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure Account Key not provided for: ", ". Set etl.config.fs.azure.account.key property or ETL_CONF_AZURE_ACCOUNT_KEY environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        if ("adl".equals(string)) {
            String value5;
            String string6;
            Option adlClientID = arcContext.commandLineArguments().get((Object)"etl.config.fs.adl.oauth2.client.id").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_ADL_OAUTH2_CLIENT_ID");
                }
            });
            Option adlRefreshToken = arcContext.commandLineArguments().get((Object)"etl.config.fs.adl.oauth2.refresh.token").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_ADL_OAUTH2_REFRESH_TOKEN");
                }
            });
            Option option = adlClientID;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure Data Lake Storage Client ID not provided for: ", ". Set etl.config.fs.adl.oauth2.client.id or ETL_CONF_ADL_OAUTH2_CLIENT_ID environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some = (Some)option;
            String clientID = string6 = (value5 = (String)some.x());
            Option option5 = adlRefreshToken;
            if (option5 instanceof Some) {
                String value52;
                String string7;
                Some some5 = (Some)option5;
                String refreshToken = string7 = (value52 = (String)some5.x());
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureDataLakeStorageToken(clientID, refreshToken)), spark, logger);
                String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                return package$.MODULE$.Right().apply((Object)etlConfString);
            }
            if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)option5);
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure Data Lake Storage Refresh Token not provided for: ", ". Set etl.config.fs.adl.oauth2.refresh.token property or ETL_CONF_ADL_OAUTH2_REFRESH_TOKEN environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        boolean bl2 = "abfs".equals(string) ? true : "abfss".equals(string);
        if (bl2) {
            String value6;
            String string8;
            Option dfAccountName = arcContext.commandLineArguments().get((Object)"etl.config.fs.dfs.account.name").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_DFS_ACCOUNT_NAME");
                }
            });
            Option dfAccessKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.dfs.access.key").orElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply() {
                    return Properties$.MODULE$.envOrNone("ETL_CONF_DFS_ACCESS_KEY");
                }
            });
            Option option = dfAccountName;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure DLS Account Name not provided for: ", ". Set etl.config.fs.dfs.account.name property or ETL_CONF_DFS_ACCOUNT_NAME environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            }
            Some some = (Some)option;
            String accountName = string8 = (value6 = (String)some.x());
            Option option6 = dfAccessKey;
            if (option6 instanceof Some) {
                String value62;
                String string9;
                Some some6 = (Some)option6;
                String accountKey = string9 = (value62 = (String)some6.x());
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2AccountKey(accountName, accountKey)), spark, logger);
                String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                return package$.MODULE$.Right().apply((Object)etlConfString);
            }
            if (!None$.MODULE$.equals(option6)) throw new MatchError((Object)option6);
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Azure DLS Access Key not provided for: ", ". Set etl.config.fs.dfs.access.key property or ETL_CONF_DFS_ACCESS_KEY environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        if (!"gs".equals(string)) {
            Error.ConfigError configError = new Error.ConfigError("file", (Option<Object>)None$.MODULE$, "make sure url scheme is defined e.g. file://${pwd}");
            return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        Option gsProjectID = arcContext.commandLineArguments().get((Object)"etl.config.fs.gs.project.id").orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return Properties$.MODULE$.envOrNone("ETL_CONF_GOOGLE_CLOUD_PROJECT_ID");
            }
        });
        Option gsKeyfilePath = arcContext.commandLineArguments().get((Object)"etl.config.fs.google.cloud.auth.service.account.json.keyfile").orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return Properties$.MODULE$.envOrNone("ETL_CONF_GOOGLE_CLOUD_AUTH_SERVICE_ACCOUNT_JSON_KEYFILE");
            }
        });
        Option option = gsProjectID;
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Google Cloud Project ID not provided for: ", ". Set etl.config.fs.gs.project.id or ETL_CONF_GOOGLE_CLOUD_PROJECT_ID environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        }
        Some some = (Some)option;
        String projectID = string10 = (value = (String)some.x());
        Option option7 = gsKeyfilePath;
        if (option7 instanceof Some) {
            String value7;
            String string11;
            Some some7 = (Some)option7;
            String keyFilePath = string11 = (value7 = (String)some7.x());
            CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.GoogleCloudStorageKeyFile(projectID, keyFilePath)), spark, logger);
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            return package$.MODULE$.Right().apply((Object)etlConfString);
        }
        if (!None$.MODULE$.equals(option7)) throw new MatchError((Object)option7);
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Google Cloud KeyFile Path not provided for: ", ". Set etl.config.fs.google.cloud.auth.service.account.json.keyfile property or ETL_CONF_GOOGLE_CLOUD_AUTH_SERVICE_ACCOUNT_JSON_KEYFILE environment variable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
    }

    public String readIPYNB(String uri, String notebook) {
        String kernelspecName;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonTree = objectMapper.readTree(notebook);
        String string = kernelspecName = jsonTree.get("metadata").get("kernelspec").get("name").asText();
        String string2 = "arc";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            List sources = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(jsonTree.get("cells").iterator()).asScala()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(JsonNode cell) {
                    String string = cell.get("cell_type").asText();
                    String string2 = "code";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(JsonNode cell) {
                    return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(cell.get("source").iterator()).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(JsonNode x$2) {
                            return x$2.asText();
                        }
                    }).mkString("").trim();
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String cell) {
                    return cell.replaceAll(",$", "");
                }
            }).toList();
            List configs = (List)((List)sources.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String cell) {
                    return cell.startsWith("%configplugin");
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String cell) {
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cell.split("\n")).drop(1)).mkString("\n");
                }
            }, List$.MODULE$.canBuildFrom());
            List lifecycles = (List)((List)sources.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String cell) {
                    return cell.startsWith("%lifecycleplugin");
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String cell) {
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cell.split("\n")).drop(1)).mkString("\n");
                }
            }, List$.MODULE$.canBuildFrom());
            List stages = (List)((List)sources.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String cell) {
                    return !cell.startsWith("%") && cell.length() > 0 || cell.startsWith("%arc");
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String cell) {
                    return cell.startsWith("%arc") ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cell.split("\n")).drop(1)).mkString("\n") : cell;
                }
            }, List$.MODULE$.canBuildFrom());
            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |{\n      |\"plugins\": {\n      |\"config\": [", "],\n      |\"lifecycle\": [", "]\n      |},\n      |\"stages\": [", "]\n      |}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configs.mkString("\n", ",\n", "\n"), lifecycles.mkString("\n", ",\n", "\n"), stages.mkString("\n", ",\n", "\n")})))).stripMargin();
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file ", " does not appear to be a valid arc notebook. Has kernelspec: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri, kernelspecName})));
    }

    public Map<String, String> readMap(String path, Config c) {
        Map map;
        if (c.hasPath(path)) {
            Set params = c.getConfig(path).entrySet();
            map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(params).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Map.Entry<String, ConfigValue> e) {
                    String k = e.getKey().replaceAll("^\"|\"$", "");
                    String v = e.getValue().unwrapped().toString();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Either<List<Error.ConfigError>, String> checkValidKeys(Config c, Function0<Seq<String>> expectedKeys) {
        List diffKeys = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.root().keySet()).asScala()).toSeq().diff((GenSeq)expectedKeys.apply())).toList();
        return diffKeys.isEmpty() ? package$.MODULE$.Right().apply((Object)"") : package$.MODULE$.Left().apply(diffKeys.map((Function1)new Serializable(c, expectedKeys){
            public static final long serialVersionUID = 0L;
            private final Config c$1;
            private final Function0 expectedKeys$1;

            public final Error.ConfigError apply(String key) {
                Seq<String> possibleKeys = ConfigUtils$.MODULE$.levenshteinDistance((Seq<String>)((Seq)this.expectedKeys$1.apply()), key, 4);
                return possibleKeys.isEmpty() ? new Error.ConfigError(key, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.c$1.getValue(key).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid attribute '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))) : (this.c$1.getValue(key).origin().description().contains("merge of") ? new Error.ConfigError(key, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid attribute '", "'. Perhaps you meant one of: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, ((TraversableOnce)possibleKeys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String field) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")}))) : new Error.ConfigError(key, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.c$1.getValue(key).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid attribute '", "'. Perhaps you meant one of: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, ((TraversableOnce)possibleKeys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String field) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field}));
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")}))));
            }
            {
                this.c$1 = c$1;
                this.expectedKeys$1 = expectedKeys$1;
            }
        }, List$.MODULE$.canBuildFrom()));
    }

    public Seq<String> levenshteinDistance(Seq<String> keys, String input, int limit) {
        UTF8String inputUTF8 = UTF8String.fromString((String)input);
        return (Seq)((TraversableLike)keys.map((Function1)new Serializable(inputUTF8){
            public static final long serialVersionUID = 0L;
            private final UTF8String inputUTF8$1;

            public final Tuple2<String, Object> apply(String k) {
                int v = this.inputUTF8$1.levenshteinDistance(UTF8String.fromString((String)k));
                return new Tuple2((Object)k, (Object)BoxesRunTime.boxToInteger((int)v));
            }
            {
                this.inputUTF8$1 = inputUTF8$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(limit){
            public static final long serialVersionUID = 0L;
            private final int limit$1;

            public final boolean apply(Tuple2<String, Object> x$3) {
                Tuple2<String, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    int v = tuple2._2$mcI$sp();
                    boolean bl = v < this.limit$1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.limit$1 = limit$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x$4) {
                Tuple2<String, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    String k;
                    String string = k = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Either<List<Error.ConfigError>, String> parseGlob(String path, String glob, Config c) {
        Either either;
        try {
            GlobPattern.compile((String)glob);
            if (glob.trim().startsWith("s3://") | glob.trim().startsWith("s3n://")) {
                throw new Exception("s3:// and s3n:// are no longer supported. Please use s3a:// instead.");
            }
            either = package$.MODULE$.Right().apply((Object)glob);
        }
        catch (Exception exception) {
            either = this.err$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return either;
    }

    /*
     * Unable to fully structure code
     */
    public Either<List<Error.ConfigError>, Option<API.Authentication>> readAuthentication(String path, Config c) {
        block27: {
            try {
                block59: {
                    block53: {
                        block58: {
                            block55: {
                                block57: {
                                    block56: {
                                        block54: {
                                            block46: {
                                                block47: {
                                                    block48: {
                                                        block51: {
                                                            block52: {
                                                                block28: {
                                                                    block50: {
                                                                        block49: {
                                                                            block42: {
                                                                                block43: {
                                                                                    block44: {
                                                                                        block45: {
                                                                                            block39: {
                                                                                                block40: {
                                                                                                    block41: {
                                                                                                        block36: {
                                                                                                            block37: {
                                                                                                                block38: {
                                                                                                                    block32: {
                                                                                                                        block33: {
                                                                                                                            block34: {
                                                                                                                                block35: {
                                                                                                                                    block29: {
                                                                                                                                        block30: {
                                                                                                                                            block31: {
                                                                                                                                                if (!c.hasPath(path)) ** GOTO lbl251
                                                                                                                                                authentication = this.readMap("authentication", c);
                                                                                                                                                if (authentication.isEmpty()) {
                                                                                                                                                    v0 = package$.MODULE$.Right().apply((Object)None$.MODULE$);
                                                                                                                                                    break block27;
                                                                                                                                                }
                                                                                                                                                var5_4 = false;
                                                                                                                                                var6_5 = null;
                                                                                                                                                var7_6 = authentication.get((Object)"method");
                                                                                                                                                if (!(var7_6 instanceof Some)) break block29;
                                                                                                                                                var5_4 = true;
                                                                                                                                                var6_5 = (Some)var7_6;
                                                                                                                                                var8_7 = (String)var6_5.x();
                                                                                                                                                if (!"AzureSharedKey".equals(var8_7)) break block29;
                                                                                                                                                var11_8 = authentication.get((Object)"accountName");
                                                                                                                                                if (!(var11_8 instanceof Some)) break block30;
                                                                                                                                                var12_9 = (Some)var11_8;
                                                                                                                                                v = (String)var12_9.x();
                                                                                                                                                var14_11 = v;
                                                                                                                                                accountName = var14_11;
                                                                                                                                                if (accountName.contains("fs.azure")) {
                                                                                                                                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedKey' 'accountName' should be just the account name not 'fs.azure.account.key...''."})).s((Seq)Nil$.MODULE$));
                                                                                                                                                }
                                                                                                                                                var16_13 = authentication.get((Object)"signature");
                                                                                                                                                if (!(var16_13 instanceof Some)) break block31;
                                                                                                                                                var17_14 = (Some)var16_13;
                                                                                                                                                signature = var19_16 = (v = (String)var17_14.x());
                                                                                                                                                var9_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureSharedKey(accountName, signature)));
                                                                                                                                                ** GOTO lbl242
                                                                                                                                            }
                                                                                                                                            if (None$.MODULE$.equals(var16_13)) {
                                                                                                                                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedKey' requires 'signature' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                                                            }
                                                                                                                                            throw new MatchError((Object)var16_13);
                                                                                                                                        }
                                                                                                                                        if (None$.MODULE$.equals(var11_8)) {
                                                                                                                                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedKey' requires 'accountName' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                                                        }
                                                                                                                                        throw new MatchError((Object)var11_8);
                                                                                                                                    }
                                                                                                                                    if (!var5_4 || !"AzureSharedAccessSignature".equals(var20_19 = (String)var6_5.x())) break block32;
                                                                                                                                    var22_20 = authentication.get((Object)"accountName");
                                                                                                                                    if (!(var22_20 instanceof Some)) break block33;
                                                                                                                                    var23_21 = (Some)var22_20;
                                                                                                                                    v = (String)var23_21.x();
                                                                                                                                    var25_23 = v;
                                                                                                                                    accountName = var25_23;
                                                                                                                                    if (accountName.contains("fs.azure")) {
                                                                                                                                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' 'accountName' should be just the account name not 'fs.azure.account.key...''."})).s((Seq)Nil$.MODULE$));
                                                                                                                                    }
                                                                                                                                    var27_25 = authentication.get((Object)"container");
                                                                                                                                    if (!(var27_25 instanceof Some)) break block34;
                                                                                                                                    var28_26 = (Some)var27_25;
                                                                                                                                    container = var30_28 = (v = (String)var28_26.x());
                                                                                                                                    if (accountName.contains("fs.azure")) {
                                                                                                                                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' 'container' should be just the container name not 'fs.azure.account.key...''."})).s((Seq)Nil$.MODULE$));
                                                                                                                                    }
                                                                                                                                    var32_30 = authentication.get((Object)"token");
                                                                                                                                    if (!(var32_30 instanceof Some)) break block35;
                                                                                                                                    var33_31 = (Some)var32_30;
                                                                                                                                    token = var35_33 = (v = (String)var33_31.x());
                                                                                                                                    var9_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureSharedAccessSignature(accountName, container, token)));
                                                                                                                                    ** GOTO lbl242
                                                                                                                                }
                                                                                                                                if (None$.MODULE$.equals(var32_30)) {
                                                                                                                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' requires 'container' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                                                }
                                                                                                                                throw new MatchError((Object)var32_30);
                                                                                                                            }
                                                                                                                            if (None$.MODULE$.equals(var27_25)) {
                                                                                                                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' requires 'container' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                                            }
                                                                                                                            throw new MatchError((Object)var27_25);
                                                                                                                        }
                                                                                                                        if (None$.MODULE$.equals(var22_20)) {
                                                                                                                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureSharedAccessSignature' requires 'accountName' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                                        }
                                                                                                                        throw new MatchError((Object)var22_20);
                                                                                                                    }
                                                                                                                    if (!var5_4 || !"AzureDataLakeStorageToken".equals(var36_35 = (String)var6_5.x())) break block36;
                                                                                                                    var38_36 = authentication.get((Object)"clientID");
                                                                                                                    if (!(var38_36 instanceof Some)) break block37;
                                                                                                                    var39_37 = (Some)var38_36;
                                                                                                                    clientID = var41_39 = (v = (String)var39_37.x());
                                                                                                                    var43_41 = authentication.get((Object)"refreshToken");
                                                                                                                    if (!(var43_41 instanceof Some)) break block38;
                                                                                                                    var44_42 = (Some)var43_41;
                                                                                                                    refreshToken = var46_44 = (v = (String)var44_42.x());
                                                                                                                    var9_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageToken(clientID, refreshToken)));
                                                                                                                    ** GOTO lbl242
                                                                                                                }
                                                                                                                if (None$.MODULE$.equals(var43_41)) {
                                                                                                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageToken' requires 'refreshToken' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                                }
                                                                                                                throw new MatchError((Object)var43_41);
                                                                                                            }
                                                                                                            if (None$.MODULE$.equals(var38_36)) {
                                                                                                                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageToken' requires 'clientID' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                            }
                                                                                                            throw new MatchError((Object)var38_36);
                                                                                                        }
                                                                                                        if (!var5_4 || !"AzureDataLakeStorageGen2AccountKey".equals(var47_46 = (String)var6_5.x())) break block39;
                                                                                                        var49_47 = authentication.get((Object)"accountName");
                                                                                                        if (!(var49_47 instanceof Some)) break block40;
                                                                                                        var50_48 = (Some)var49_47;
                                                                                                        accountName = var52_50 = (v = (String)var50_48.x());
                                                                                                        var54_52 = authentication.get((Object)"accessKey");
                                                                                                        if (!(var54_52 instanceof Some)) break block41;
                                                                                                        var55_53 = (Some)var54_52;
                                                                                                        accessKey = var57_55 = (v = (String)var55_53.x());
                                                                                                        var9_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2AccountKey(accountName, accessKey)));
                                                                                                        ** GOTO lbl242
                                                                                                    }
                                                                                                    if (None$.MODULE$.equals(var54_52)) {
                                                                                                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2AccountKey' requires 'accessKey' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                    }
                                                                                                    throw new MatchError((Object)var54_52);
                                                                                                }
                                                                                                if (None$.MODULE$.equals(var49_47)) {
                                                                                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2AccountKey' requires 'accountName' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                                }
                                                                                                throw new MatchError((Object)var49_47);
                                                                                            }
                                                                                            if (!var5_4 || !"AzureDataLakeStorageGen2OAuth".equals(var58_57 = (String)var6_5.x())) break block42;
                                                                                            var60_58 = authentication.get((Object)"clientID");
                                                                                            if (!(var60_58 instanceof Some)) break block43;
                                                                                            var61_59 = (Some)var60_58;
                                                                                            clientID = var63_61 = (v = (String)var61_59.x());
                                                                                            var65_63 = authentication.get((Object)"secret");
                                                                                            if (!(var65_63 instanceof Some)) break block44;
                                                                                            var66_64 = (Some)var65_63;
                                                                                            secret = var68_66 = (v = (String)var66_64.x());
                                                                                            var70_68 = authentication.get((Object)"directoryID");
                                                                                            if (!(var70_68 instanceof Some)) break block45;
                                                                                            var71_69 = (Some)var70_68;
                                                                                            directoryID = var73_71 = (v = (String)var71_69.x());
                                                                                            var9_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2OAuth(clientID, secret, directoryID)));
                                                                                            ** GOTO lbl242
                                                                                        }
                                                                                        if (None$.MODULE$.equals(var70_68)) {
                                                                                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'directoryID' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                        }
                                                                                        throw new MatchError((Object)var70_68);
                                                                                    }
                                                                                    if (None$.MODULE$.equals(var65_63)) {
                                                                                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'secret' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                    }
                                                                                    throw new MatchError((Object)var65_63);
                                                                                }
                                                                                if (None$.MODULE$.equals(var60_58)) {
                                                                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'clientID' parameter."})).s((Seq)Nil$.MODULE$));
                                                                                }
                                                                                throw new MatchError((Object)var60_58);
                                                                            }
                                                                            if (!var5_4 || !"AmazonAccessKey".equals(var74_73 = (String)var6_5.x())) break block46;
                                                                            var76_74 = authentication.get((Object)"accessKeyID");
                                                                            if (!(var76_74 instanceof Some)) break block47;
                                                                            var77_75 = (Some)var76_74;
                                                                            accessKeyID = var79_77 = (v = (String)var77_75.x());
                                                                            var81_79 = authentication.get((Object)"secretAccessKey");
                                                                            if (!(var81_79 instanceof Some)) break block48;
                                                                            var82_80 = (Some)var81_79;
                                                                            secretAccessKey = var84_82 = (v = (String)var82_80.x());
                                                                            var86_84 = authentication.get((Object)"endpoint");
                                                                            if (!(var86_84 instanceof Some)) break block49;
                                                                            var87_85 = (Some)var86_84;
                                                                            v = (String)var87_85.x();
                                                                            uri = new URI(v);
                                                                            inetAddress = InetAddress.getByName(uri.getHost());
                                                                            replacedURI = new URI(uri.getScheme(), uri.getUserInfo(), inetAddress.getHostAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                                                                            var89_90 = Option$.MODULE$.apply((Object)replacedURI.toString());
                                                                            break block50;
                                                                        }
                                                                        if (!None$.MODULE$.equals(var86_84)) break block51;
                                                                        var89_90 = None$.MODULE$;
                                                                    }
                                                                    endpoint = var89_90;
                                                                    var94_92 = authentication.get((Object)"sslEnabled");
                                                                    if (var94_92 instanceof Some) {
                                                                        var95_93 = (Some)var94_92;
                                                                        v = (String)var95_93.x();
                                                                        var97_95 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean()));
                                                                        break block28;
                                                                    }
                                                                    if (!None$.MODULE$.equals(var94_92)) break block52;
                                                                    var97_95 = None$.MODULE$;
                                                                }
                                                                sslEnabled = var97_95;
                                                                var9_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonAccessKey(accessKeyID, secretAccessKey, (Option<String>)endpoint, (Option<Object>)sslEnabled)));
                                                                ** GOTO lbl242
                                                            }
                                                            throw new MatchError((Object)var94_92);
                                                        }
                                                        throw new MatchError((Object)var86_84);
                                                    }
                                                    if (None$.MODULE$.equals(var81_79)) {
                                                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AmazonAccessKey' requires 'secretAccessKey' parameter."})).s((Seq)Nil$.MODULE$));
                                                    }
                                                    throw new MatchError((Object)var81_79);
                                                }
                                                if (None$.MODULE$.equals(var76_74)) {
                                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AmazonAccessKey' requires 'accessKeyID' parameter."})).s((Seq)Nil$.MODULE$));
                                                }
                                                throw new MatchError((Object)var76_74);
                                            }
                                            if (!var5_4 || !"AmazonIAM".equals(var99_97 = (String)var6_5.x())) break block53;
                                            encType = authentication.get((Object)"encryptionAlgorithm").flatMap((Function1)new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final Option<API.AmazonS3EncryptionType> apply(String x$7) {
                                                    return API$AmazonS3EncryptionType$.MODULE$.fromString(x$7);
                                                }
                                            });
                                            var103_101 = new Tuple3((Object)encType, (Object)(kmsId = authentication.get((Object)"kmsArn")), (Object)(customKey = authentication.get((Object)"customKey")));
                                            if (var103_101 == null) break block54;
                                            var104_102 = (Option)var103_101._1();
                                            var105_103 = (Option)var103_101._2();
                                            var106_104 = (Option)var103_101._3();
                                            if (!None$.MODULE$.equals(var104_102) || !None$.MODULE$.equals(var105_103) || !None$.MODULE$.equals(var106_104)) break block54;
                                            var107_105 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonIAM((Option<API.AmazonS3EncryptionType>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$)));
                                            break block55;
                                        }
                                        if (var103_101 == null) break block56;
                                        var108_106 = (Option)var103_101._1();
                                        var109_107 = (Option)var103_101._2();
                                        var110_108 = (Option)var103_101._3();
                                        if (!(var108_106 instanceof Some) || !API$AmazonS3EncryptionType$SSE_S3$.MODULE$.equals(var112_110 = (API.AmazonS3EncryptionType)(var111_109 = (Some)var108_106).x()) || !None$.MODULE$.equals(var109_107) || !None$.MODULE$.equals(var110_108)) break block56;
                                        var107_105 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonIAM((Option<API.AmazonS3EncryptionType>)encType, (Option<String>)kmsId, (Option<String>)None$.MODULE$)));
                                        break block55;
                                    }
                                    if (var103_101 == null) break block57;
                                    var113_111 = (Option)var103_101._1();
                                    var114_112 = (Option)var103_101._2();
                                    var115_113 = (Option)var103_101._3();
                                    if (!(var113_111 instanceof Some) || !API$AmazonS3EncryptionType$SSE_KMS$.MODULE$.equals(var117_115 = (API.AmazonS3EncryptionType)(var116_114 = (Some)var113_111).x()) || !(var114_112 instanceof Some) || !None$.MODULE$.equals(var115_113)) break block57;
                                    var107_105 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonIAM((Option<API.AmazonS3EncryptionType>)encType, (Option<String>)kmsId, (Option<String>)None$.MODULE$)));
                                    break block55;
                                }
                                if (var103_101 == null) break block58;
                                var118_116 = (Option)var103_101._1();
                                var119_117 = (Option)var103_101._2();
                                var120_118 = (Option)var103_101._3();
                                if (!(var118_116 instanceof Some) || !API$AmazonS3EncryptionType$SSE_C$.MODULE$.equals(var122_120 = (API.AmazonS3EncryptionType)(var121_119 = (Some)var118_116).x()) || !None$.MODULE$.equals(var119_117) || !(var120_118 instanceof Some)) break block58;
                                var107_105 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonIAM((Option<API.AmazonS3EncryptionType>)encType, (Option<String>)None$.MODULE$, (Option<String>)customKey)));
                            }
                            var9_18 = var107_105;
                            ** GOTO lbl242
                        }
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid authentication options for AmazonIAM method. See docs for allowed settings."})).s((Seq)Nil$.MODULE$));
                    }
                    if (!var5_4 || !"AmazonAnonymous".equals(var123_121 = (String)var6_5.x())) break block59;
                    var9_18 = package$.MODULE$.Right().apply((Object)new Some((Object)API$Authentication$AmazonAnonymous$.MODULE$));
                    ** GOTO lbl242
                }
                if (!var5_4 || !"GoogleCloudStorageKeyFile".equals(var124_122 = (String)var6_5.x())) ** GOTO lbl250
                var126_123 = authentication.get((Object)"projectID");
                if (!(var126_123 instanceof Some)) ** GOTO lbl247
                var127_124 = (Some)var126_123;
                projectID = var129_126 = (v = (String)var127_124.x());
                var131_128 = authentication.get((Object)"keyFilePath");
                if (var131_128 instanceof Some) {
                    var132_129 = (Some)var131_128;
                    keyFilePath = var134_131 = (v = (String)var132_129.x());
                    var9_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.GoogleCloudStorageKeyFile(projectID, keyFilePath)));
lbl242:
                    // 9 sources

                    v0 = var9_18;
                } else {
                    if (None$.MODULE$.equals(var131_128)) {
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'GoogleCloudStorageKeyFile' requires 'keyFilePath' parameter."})).s((Seq)Nil$.MODULE$));
                    }
                    throw new MatchError((Object)var131_128);
lbl247:
                    // 1 sources

                    if (None$.MODULE$.equals(var126_123)) {
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'GoogleCloudStorageKeyFile' requires 'projectID' parameter."})).s((Seq)Nil$.MODULE$));
                    }
                    throw new MatchError((Object)var126_123);
lbl250:
                    // 1 sources

                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse authentication method: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authentication.get((Object)"method").getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    })})));
lbl251:
                    // 1 sources

                    v0 = package$.MODULE$.Right().apply((Object)None$.MODULE$);
                }
                break block27;
                catch (Exception var98_133) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Authentication method 'AmazonAccessKey' expects 'sslEnabled' parameter to be boolean."})).s((Seq)Nil$.MODULE$));
                }
            }
            catch (Exception var3_134) {
                v0 = this.err$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to read config value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_134.getMessage()})), path);
            }
        }
        return v0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Either<List<Error.ConfigError>, Option<API.Watermark>> readWatermark(String path, Config c) {
        Right right;
        try {
            String v;
            String string;
            if (!c.hasPath(path)) {
                right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
                return right;
            }
            Map<String, String> watermark = this.readMap(path, c);
            Option option = watermark.get((Object)"eventTime");
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Watermark requires 'eventTime' parameter."})).s((Seq)Nil$.MODULE$));
            }
            Some some = (Some)option;
            String eventTime = string = (v = (String)some.x());
            Option option2 = watermark.get((Object)"delayThreshold");
            if (option2 instanceof Some) {
                String v2;
                String string2;
                Some some2 = (Some)option2;
                String delayThreshold = string2 = (v2 = (String)some2.x());
                right = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Watermark(eventTime, delayThreshold)));
                return right;
            }
            if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Watermark requires 'delayThreshold' parameter."})).s((Seq)Nil$.MODULE$));
        }
        catch (Exception exception) {
            right = this.err$3((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to read config value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, URI> parseURI(String path, String uri, Config c) {
        Either either;
        try {
            URI u = new URI(uri);
            if (uri.trim().startsWith("s3://") | uri.trim().startsWith("s3n://")) {
                throw new Exception("s3:// and s3n:// are no longer supported. Please use s3a:// instead.");
            }
            either = package$.MODULE$.Right().apply((Object)u);
        }
        catch (Exception exception) {
            either = this.err$4((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return either;
    }

    public Either<List<Error.ConfigError>, List<API.ExtractColumn>> getExtractColumns(String uriKey, Either<List<Error.ConfigError>, Option<API.Authentication>> authentication, URI uri, SparkSession spark, Logger logger, Config c) {
        Either schema = EitherUtils$.MODULE$.eitherToMappableEither(this.textContentForURI(uriKey, authentication, uri, spark, logger, c)).rightFlatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Right<Nothing$, Option<String>> apply(String text) {
                return package$.MODULE$.Right().apply((Object)Option$.MODULE$.apply((Object)text));
            }
        });
        return EitherUtils$.MODULE$.eitherToMappableEither(schema).rightFlatMap(new Serializable(logger){
            public static final long serialVersionUID = 0L;
            public final Logger logger$1;

            public final Either<List<Error.ConfigError>, List<API.ExtractColumn>> apply(Option<String> sch) {
                Either either;
                block4: {
                    Right right;
                    block3: {
                        block2: {
                            Either cols = (Either)sch.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.getExtractColumns.1 $outer;

                                public final Either<List<Error.StageError>, List<API.ExtractColumn>> apply(String s) {
                                    return MetadataSchema$.MODULE$.parseJsonMetadata(s, this.$outer.logger$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Right<Nothing$, Nil$> apply() {
                                    return package$.MODULE$.Right().apply((Object)Nil$.MODULE$);
                                }
                            });
                            either = cols;
                            if (!(either instanceof Left)) break block2;
                            Left left = (Left)either;
                            List errs = (List)left.a();
                            right = package$.MODULE$.Left().apply(errs.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Error.ConfigError apply(Error.StageError e) {
                                    return new Error.ConfigError("metadata error", (Option<Object>)None$.MODULE$, Error$.MODULE$.pipelineSimpleErrorMsg(e.errors()));
                                }
                            }, List$.MODULE$.canBuildFrom()));
                            break block3;
                        }
                        if (!(either instanceof Right)) break block4;
                        Right right2 = (Right)either;
                        List extractColumns = (List)right2.b();
                        right = package$.MODULE$.Right().apply((Object)extractColumns);
                    }
                    return right;
                }
                throw new MatchError((Object)either);
            }
            {
                this.logger$1 = logger$1;
            }
        });
    }

    public Either<List<Error.ConfigError>, String> textContentForURI(String uriKey, Either<List<Error.ConfigError>, Option<API.Authentication>> authentication, URI uri, SparkSession spark, Logger logger, Config c) {
        Either either;
        String string = uri.getScheme();
        if ("classpath".equals(string)) {
            String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.getHost(), uri.getPath()}));
            either = (Either)ControlUtils$.MODULE$.using(this.getClass().getResourceAsStream(path), new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Right<Nothing$, String> apply(InputStream is) {
                    String text = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                    return package$.MODULE$.Right().apply((Object)text);
                }
            });
        } else {
            authentication.right().map((Function1)new Serializable(spark, logger){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$1;
                private final Logger logger$2;

                public final void apply(Option<API.Authentication> auth) {
                    CloudUtils$.MODULE$.setHadoopConfiguration(auth, this.spark$1, this.logger$2);
                }
                {
                    this.spark$1 = spark$1;
                    this.logger$2 = logger$2;
                }
            });
            either = this.getBlob(uriKey, uri, spark, logger, c);
        }
        return either;
    }

    public Either<List<Error.ConfigError>, String> getBlob(String path, URI uri, SparkSession spark, Logger logger, Config c) {
        Object object;
        try {
            String textFile = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            object = textFile.length() == 0 ? this.err$5((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File at ", " is empty."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.toString()})), path) : package$.MODULE$.Right().apply((Object)textFile);
        }
        catch (Exception exception) {
            object = this.err$5((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return object;
    }

    public Either<List<Error.ConfigError>, API.EncodingType> parseEncoding(String path, String encoding, Config c) {
        Right right;
        String string = encoding.toLowerCase().trim();
        if ("base64".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$EncodingTypeBase64$.MODULE$);
        } else if ("hexadecimal".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$EncodingTypeHexadecimal$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, SaveMode> parseSaveMode(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("append".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Append);
        } else if ("errorifexists".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.ErrorIfExists);
        } else if ("ignore".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Ignore);
        } else if ("overwrite".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Overwrite);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, API.OutputModeType> parseOutputModeType(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("append".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeAppend$.MODULE$);
        } else if ("complete".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeComplete$.MODULE$);
        } else if ("update".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeUpdate$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, API.FailModeType> parseFailMode(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("permissive".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$FailModeTypePermissive$.MODULE$);
        } else if ("failfast".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$FailModeTypeFailFast$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, Delimiter> parseDelimiter(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("comma".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Comma$.MODULE$);
        } else if ("defaulthive".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$DefaultHive$.MODULE$);
        } else if ("pipe".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Pipe$.MODULE$);
        } else if ("custom".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Custom$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, QuoteCharacter> parseQuote(String path, String quote, Config c) {
        Right right;
        String string = quote.toLowerCase().trim();
        if ("doublequote".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$DoubleQuote$.MODULE$);
        } else if ("singlequote".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$SingleQuote$.MODULE$);
        } else if ("none".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$Disabled$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid state please raise issue."})).s((Seq)Nil$.MODULE$));
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, Driver> getJDBCDriver(String path, String uri, Config c) {
        Right right;
        List drivers = (List)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Driver driver) {
                return driver.getClass().getName();
            }
        }, List$.MODULE$.canBuildFrom());
        try {
            right = package$.MODULE$.Right().apply((Object)DriverManager.getDriver(uri));
        }
        catch (Exception exception) {
            right = this.err$6((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid driver for ('", "'). Available JDBC drivers: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri, drivers.mkString("[", ", ", "]")})), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, String> injectSQLParams(String path, Map<String, String> sqlParams, boolean allowMissing, String sql, SparkSession spark, Logger logger, Config c) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)SQLUtils$.MODULE$.injectParameters(sql, sqlParams, allowMissing, logger));
        }
        catch (Exception exception) {
            right = this.err$7((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, String> validateSQL(String path, String sql, SparkSession spark, Config c) {
        Right right;
        try {
            ParserInterface parser = spark.sessionState().sqlParser();
            parser.parsePlan(sql);
            right = package$.MODULE$.Right().apply((Object)sql);
        }
        catch (Exception exception) {
            right = this.err$8((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), exception.getMessage(), path);
        }
        return right;
    }

    private final Either err$1(Option lineNumber, String msg, String path$1) {
        Error.ConfigError configError = new Error.ConfigError(path$1, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$2(Option lineNumber, String msg, String path$2) {
        Error.ConfigError configError = new Error.ConfigError(path$2, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$3(Option lineNumber, String msg, String path$3) {
        Error.ConfigError configError = new Error.ConfigError(path$3, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$4(Option lineNumber, String msg, String path$4) {
        Error.ConfigError configError = new Error.ConfigError(path$4, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$5(Option lineNumber, String msg, String path$5) {
        Error.ConfigError configError = new Error.ConfigError(path$5, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$6(Option lineNumber, String msg, String path$6) {
        Error.ConfigError configError = new Error.ConfigError(path$6, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$7(Option lineNumber, String msg, String path$7) {
        Error.ConfigError configError = new Error.ConfigError(path$7, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private final Either err$8(Option lineNumber, String msg, String path$8) {
        Error.ConfigError configError = new Error.ConfigError(path$8, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private ConfigUtils$() {
        MODULE$ = this;
    }
}

