/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.config;

import ai.tripl.arc.api.API;
import ai.tripl.arc.config.ConfigReader$;
import ai.tripl.arc.config.ConfigReader$StringConfigReader$;
import ai.tripl.arc.config.Error;
import ai.tripl.arc.util.log.logger.Logger;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Plugins$ {
    public static final Plugins$ MODULE$;

    static {
        new Plugins$();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> Either<List<Error.Error>, List<T>> resolveConfigPlugins(Config c, String path, List<API.ConfigPlugin<T>> plugins, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        void var22_18;
        Tuple2 tuple2;
        java.util.List objectList;
        Right right;
        if (!c.hasPath(path)) {
            right = package$.MODULE$.Right().apply((Object)Nil$.MODULE$);
            return right;
        }
        try {
            objectList = c.getObjectList(path);
        }
        catch (Exception exception) {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)c.origin().lineNumber())), exception.getMessage());
            Error.StageError stageError = new Error.StageError(0, path, c.origin().lineNumber(), (List<Error.ConfigError>)Nil$.MODULE$.$colon$colon((Object)configError));
            return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)stageError));
        }
        catch (ConfigException.WrongType wrongType) {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)c.origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " to be a List of Objects."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
            Error.StageError stageError = new Error.StageError(0, path, c.origin().lineNumber(), (List<Error.ConfigError>)Nil$.MODULE$.$colon$colon((Object)configError));
            return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)stageError));
        }
        Tuple2 tuple22 = (Tuple2)((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(objectList).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$), (Function2)new Serializable(path, plugins, spark, logger, arcContext){
            public static final long serialVersionUID = 0L;
            private final String path$1;
            private final List plugins$1;
            private final SparkSession spark$1;
            private final Logger logger$1;
            private final API.ARCContext arcContext$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<List<Error.StageError>, List<T>> apply(Tuple2<List<Error.StageError>, List<T>> x0$1, Tuple2<ConfigObject, Object> x1$1) {
                Tuple2 tuple2;
                Nil$ environments;
                Config config;
                Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                Tuple2 tuple24 = (Tuple2)tuple22._2();
                if (tuple23 == null) throw new MatchError((Object)tuple22);
                List errors = (List)tuple23._1();
                List instances = (List)tuple23._2();
                if (tuple24 == null) throw new MatchError((Object)tuple22);
                ConfigObject plugin = (ConfigObject)tuple24._1();
                int index = tuple24._2$mcI$sp();
                Config c = config = plugin.toConfig();
                Either<List<Error.ConfigError>, String> pluginType = ConfigReader$.MODULE$.getValue("type", ConfigReader$.MODULE$.getValue$default$2(), ConfigReader$.MODULE$.getValue$default$3(), c, ConfigReader$StringConfigReader$.MODULE$);
                Object object = environments = config.hasPath("environments") ? ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(config.getStringList("environments")).asScala()).toList() : Nil$.MODULE$;
                if (this.arcContext$1.ignoreEnvironments() || environments.contains(this.arcContext$1.environment().get())) {
                    Tuple2 tuple25;
                    Either<List<Error.StageError>, T> instanceOrError;
                    Either<List<Error.StageError>, T> either;
                    Either<List<Error.ConfigError>, String> either2 = pluginType;
                    if (either2 instanceof Left) {
                        Left left = (Left)either2;
                        List errors2 = (List)left.a();
                        Error.StageError stageError = new Error.StageError(index, this.path$1, plugin.origin().lineNumber(), (List<Error.ConfigError>)errors2);
                        either = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)stageError));
                    } else {
                        if (!(either2 instanceof Right)) throw new MatchError(either2);
                        Right right = (Right)either2;
                        String pluginType2 = (String)right.b();
                        either = Plugins$.MODULE$.resolvePlugin(this.path$1.contains("plugins."), index, pluginType2, config, this.plugins$1, this.spark$1, this.logger$1, this.arcContext$1);
                    }
                    Either<List<Error.StageError>, T> either3 = instanceOrError = either;
                    if (either3 instanceof Left) {
                        List error;
                        Left left = (Left)either3;
                        List list = error = (List)left.a();
                        tuple25 = new Tuple2((Object)errors.$colon$colon$colon(list), (Object)instances);
                    } else {
                        Object instance;
                        if (!(either3 instanceof Right)) throw new MatchError(either3);
                        Right right = (Right)either3;
                        Object object2 = instance = right.b();
                        tuple25 = new Tuple2((Object)errors, (Object)instances.$colon$colon(object2));
                    }
                    tuple2 = tuple25;
                    return tuple2;
                } else {
                    this.logger$1.info().field("event", "validateConfig").field("type", pluginType.right().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "unknown";
                        }
                    })).field("pluginIndex", BoxesRunTime.boxToInteger((int)index)).field("environment", this.arcContext$1.environment().get()).list("environments", (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)environments).asJava()).field("message", "skipping plugin due to environment configuration").field("skipPlugin", BoxesRunTime.boxToBoolean((boolean)true)).log();
                    tuple2 = new Tuple2((Object)errors, (Object)instances);
                }
                return tuple2;
            }
            {
                this.path$1 = path$1;
                this.plugins$1 = plugins$1;
                this.spark$1 = spark$1;
                this.logger$1 = logger$1;
                this.arcContext$1 = arcContext$1;
            }
        });
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        List errors = (List)tuple22._1();
        List instances = (List)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)errors, (Object)instances);
        List errors2 = (List)tuple23._1();
        List instances2 = (List)tuple23._2();
        List list = errors2;
        if (Nil$.MODULE$.equals(list)) {
            Right right2 = package$.MODULE$.Right().apply((Object)instances2.reverse());
        } else {
            Left left = package$.MODULE$.Left().apply((Object)errors2.reverse());
        }
        right = var22_18;
        return right;
    }

    public <T> Either<List<Error.StageError>, T> resolvePlugin(boolean log, int index, String name, Config config, List<API.ConfigPlugin<T>> plugins, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Left left;
        String versionMessage;
        String[] splitPlugin = name.split(":", 2);
        boolean hasPackage = splitPlugin[0].contains(".");
        boolean hasVersion = splitPlugin.length > 1;
        List nameFilteredPlugins = hasPackage ? (List)plugins.filter((Function1)new Serializable(splitPlugin){
            public static final long serialVersionUID = 0L;
            private final String[] splitPlugin$1;

            public final boolean apply(API.ConfigPlugin<T> plugin) {
                String string = plugin.getClass().getName();
                String string2 = this.splitPlugin$1[0];
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.splitPlugin$1 = splitPlugin$1;
            }
        }) : (List)plugins.filter((Function1)new Serializable(splitPlugin){
            public static final long serialVersionUID = 0L;
            private final String[] splitPlugin$1;

            public final boolean apply(API.ConfigPlugin<T> plugin) {
                String string = plugin.getClass().getSimpleName();
                String string2 = this.splitPlugin$1[0];
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.splitPlugin$1 = splitPlugin$1;
            }
        });
        List filteredPlugins = hasVersion ? (List)nameFilteredPlugins.filter((Function1)new Serializable(splitPlugin){
            public static final long serialVersionUID = 0L;
            private final String[] splitPlugin$1;

            public final boolean apply(API.ConfigPlugin<T> plugin) {
                String string = plugin.version();
                String string2 = this.splitPlugin$1[1];
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.splitPlugin$1 = splitPlugin$1;
            }
        }) : nameFilteredPlugins;
        String availablePluginsMessage = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Available plugins: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)plugins.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(API.ConfigPlugin<T> c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getClass().getName(), c.version()}));
            }
        }, List$.MODULE$.canBuildFrom())).mkString("[", ",", "]")}));
        String string = versionMessage = hasVersion ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name:version"})).s((Seq)Nil$.MODULE$) : "name";
        if (filteredPlugins.length() == 0) {
            Error.ConfigError configError = new Error.ConfigError("stages", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)config.origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No plugins found with ", " ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versionMessage, name, availablePluginsMessage})));
            Error.StageError stageError = new Error.StageError(index, name, config.origin().lineNumber(), (List<Error.ConfigError>)Nil$.MODULE$.$colon$colon((Object)configError));
            left = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)stageError));
        } else if (filteredPlugins.length() > 1) {
            Error.ConfigError configError = new Error.ConfigError("stages", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)config.origin().lineNumber())), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple plugins found with name ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{splitPlugin[0], availablePluginsMessage})));
            Error.StageError stageError = new Error.StageError(index, name, config.origin().lineNumber(), (List<Error.ConfigError>)Nil$.MODULE$.$colon$colon((Object)configError));
            left = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)stageError));
        } else {
            if (log) {
                logger.info().field("event", "instantiatePlugin").field("plugin", name).log();
            }
            left = ((API.ConfigPlugin)filteredPlugins.head()).instantiate(index, config, spark, logger, arcContext);
        }
        return left;
    }

    private Plugins$() {
        MODULE$ = this;
    }
}

