/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.ORCExtract;
import ai.tripl.arc.extract.ORCExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple14;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ORCExtractStage$
implements scala.Serializable {
    public static ORCExtractStage$ MODULE$;

    static {
        new ORCExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(ORCExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Left left;
        Option<StructType> option;
        try {
            option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Option<StructType> optionSchema = option;
        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
        try {
            if (arcContext.isStreaming()) {
                Right right;
                Option<StructType> option2 = optionSchema;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    StructType schema = (StructType)some.value();
                    Option<API.Watermark> option3 = stage.watermark();
                    if (option3 instanceof Some) {
                        Some some2 = (Some)option3;
                        API.Watermark watermark = (API.Watermark)some2.value();
                        right = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).orc(stage.input()).withWatermark(watermark.eventTime(), watermark.delayThreshold()));
                    } else {
                        if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                        right = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).orc(stage.input()));
                    }
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    throw new Exception("ORCExtract requires 'schemaURI' or 'schemaView' to be set if Arc is running in streaming mode.");
                }
                Right right2 = right;
                left = right2;
            } else {
                Right right;
                Option<String> option4 = stage.basePath();
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    String basePath = (String)some.value();
                    right = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "true").option("basePath", basePath).orc(stage.input()));
                } else {
                    if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                    right = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "true").orc(stage.input()));
                }
                left = right;
            }
        }
        catch (AnalysisException analysisException) {
            String string = analysisException.getMessage();
            String string2 = "Unable to infer schema for ORC. It must be specified manually.;";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                left = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)Option$.MODULE$.apply((Object)stage.input())));
            }
            if (analysisException.getMessage().contains("Path does not exist")) {
                left = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)Option$.MODULE$.apply((Object)stage.input())));
            }
            Predef$.MODULE$.println((Object)analysisException.getMessage());
            throw new Exception(analysisException);
        }
        catch (Exception exception) {
            throw new DetailException(exception, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        Left df = left;
        try {
            Dataset dataset4;
            Left left2 = df;
            if (left2 instanceof Right) {
                Dataset dataset5;
                Right right = (Right)left2;
                Dataset df2 = (Dataset)right.value();
                if (df2.schema().length() == 0) {
                    Option<StructType> option5 = optionSchema;
                    if (!(option5 instanceof Some)) {
                        if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                        throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)stage.input())).getMessage());
                    }
                    Some some = (Some)option5;
                    StructType structType = (StructType)some.value();
                    Dataset dataset6 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                    dataset5 = dataset6;
                } else {
                    dataset5 = df2;
                }
                dataset4 = dataset5;
            } else {
                if (!(left2 instanceof Left)) throw new MatchError((Object)left2);
                Left left3 = left2;
                Product error = (Product)left3.value();
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option6 = optionSchema;
                if (!(option6 instanceof Some)) {
                    if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                    throw new Exception(((API.ExtractError)error).getMessage());
                }
                Some some = (Some)option6;
                StructType s = (StructType)some.value();
                Dataset dataset7 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset4 = dataset7;
            }
            dataset3 = dataset4;
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), arcContext);
        Option<StructType> option7 = optionSchema;
        if (option7 instanceof Some) {
            Some some = (Some)option7;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema, spark, logger);
        } else {
            if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset8;
            Option<Object> option8 = stage.numPartitions();
            if (option8 instanceof Some) {
                Some some = (Some)option8;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset8 = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option8)) throw new MatchError(option8);
                dataset8 = enrichedDF;
            }
            dataset = dataset8;
        } else {
            Dataset dataset9;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> enrichedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option9 = stage.numPartitions();
            if (option9 instanceof Some) {
                Some some = (Some)option9;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset9 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option9)) throw new MatchError(option9);
                dataset9 = enrichedDF.repartition((Seq)partitionCols);
            }
            dataset = dataset9;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public ORCExtractStage apply(ORCExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, String input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> basePath, Option<API.Watermark> watermark) {
        return new ORCExtractStage(plugin, name, description, schema, outputView, input, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, basePath, watermark);
    }

    public Option<Tuple14<ORCExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, String, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<API.Watermark>>> unapply(ORCExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), (Object)x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ORCExtractStage$() {
        MODULE$ = this;
    }
}

