/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.XMLExtract;
import ai.tripl.arc.extract.XMLExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.databricks.spark.xml.XmlReader;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple14;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class XMLExtractStage$
implements scala.Serializable {
    public static XMLExtractStage$ MODULE$;

    static {
        new XMLExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(XMLExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Left left;
        Option<StructType> option;
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
        try {
            option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Option<StructType> optionSchema = option;
        try {
            Right right;
            Either<String, String> either = stage.input();
            if (either instanceof Right) {
                Right right2;
                Right right3 = (Right)either;
                String glob = (String)right3.value();
                CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                Dataset textDS = spark.read().option("wholetext", true).text(glob).as(spark.implicits().newStringEncoder());
                stage.xsd().foreach((Function1 & Serializable & scala.Serializable)xsd -> {
                    textDS.foreach((Function1 & Serializable & scala.Serializable)xml -> {
                        XMLExtractStage$.$anonfun$execute$2(xsd, xml);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                XmlReader xmlReader = new XmlReader();
                Option<StructType> option2 = optionSchema;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    StructType schema = (StructType)some.value();
                    right2 = package$.MODULE$.Right().apply((Object)xmlReader.withSchema(schema).xmlRdd(spark, textDS.rdd()));
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    right2 = package$.MODULE$.Right().apply((Object)xmlReader.xmlRdd(spark, textDS.rdd()));
                }
                right = right2;
            } else {
                Right right4;
                RDD rDD;
                if (!(either instanceof Left)) throw new MatchError(either);
                Left left2 = (Left)either;
                String view = (String)left2.value();
                XmlReader xmlReader = new XmlReader();
                Option<String> option3 = stage.inputField();
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    String inputField = (String)some.value();
                    rDD = spark.table(view).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputField)})).as(spark.implicits().newStringEncoder()).rdd();
                } else {
                    if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                    rDD = spark.table(view).as(spark.implicits().newStringEncoder()).rdd();
                }
                RDD textRdd = rDD;
                stage.xsd().foreach((Function1 & Serializable & scala.Serializable)xsd -> {
                    textRdd.foreach((Function1 & Serializable & scala.Serializable)xml -> {
                        XMLExtractStage$.$anonfun$execute$4(xsd, xml);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                Option<StructType> option4 = optionSchema;
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    StructType schema = (StructType)some.value();
                    right4 = package$.MODULE$.Right().apply((Object)xmlReader.withSchema(schema).xmlRdd(spark, textRdd));
                } else {
                    if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                    right4 = package$.MODULE$.Right().apply((Object)xmlReader.xmlRdd(spark, textRdd));
                }
                right = right4;
            }
            left = right;
        }
        catch (Throwable throwable) {
            Left left3;
            AnalysisException analysisException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AnalysisException && (analysisException = (AnalysisException)throwable2).getMessage().contains("Path does not exist")) {
                Either<String, String> either = stage.input();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    String glob = (String)right.value();
                    left3 = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)Option$.MODULE$.apply((Object)glob)));
                } else {
                    if (!(either instanceof Left)) throw new MatchError(either);
                    left3 = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)None$.MODULE$));
                }
            } else {
                if (!(throwable2 instanceof Exception)) throw throwable;
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            Left left4 = left3;
            left = left4;
        }
        Left df = left;
        try {
            Dataset dataset4;
            Left left5 = df;
            if (left5 instanceof Right) {
                Dataset dataset5;
                Right right = (Right)left5;
                Dataset df2 = (Dataset)right.value();
                if (df2.schema().length() == 0) {
                    Option<StructType> option5 = optionSchema;
                    if (!(option5 instanceof Some)) {
                        if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                        Either<String, String> either = stage.input();
                        if (either instanceof Right) {
                            Right right5 = (Right)either;
                            String glob = (String)right5.value();
                            throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)glob)).getMessage());
                        }
                        if (!(either instanceof Left)) throw new MatchError(either);
                        throw new Exception(new API.EmptySchemaExtractError((Option<String>)None$.MODULE$).getMessage());
                    }
                    Some some = (Some)option5;
                    StructType structType = (StructType)some.value();
                    Dataset dataset6 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                    dataset5 = dataset6;
                } else {
                    dataset5 = df2;
                }
                dataset4 = dataset5;
            } else {
                if (!(left5 instanceof Left)) throw new MatchError((Object)left5);
                Left left6 = left5;
                Product error = (Product)left6.value();
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option6 = optionSchema;
                if (!(option6 instanceof Some)) {
                    if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                    throw new Exception(((API.ExtractError)error).getMessage());
                }
                Some some = (Some)option6;
                StructType s = (StructType)some.value();
                Dataset dataset7 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset4 = dataset7;
            }
            dataset3 = dataset4;
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), arcContext);
        Option<StructType> option7 = optionSchema;
        if (option7 instanceof Some) {
            Some some = (Some)option7;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema, spark, logger);
        } else {
            if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset8;
            Option<Object> option8 = stage.numPartitions();
            if (option8 instanceof Some) {
                Some some = (Some)option8;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset8 = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option8)) throw new MatchError(option8);
                dataset8 = enrichedDF;
            }
            dataset = dataset8;
        } else {
            Dataset dataset9;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> enrichedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option9 = stage.numPartitions();
            if (option9 instanceof Some) {
                Some some = (Some)option9;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset9 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option9)) throw new MatchError(option9);
                dataset9 = enrichedDF.repartition((Seq)partitionCols);
            }
            dataset = dataset9;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public XMLExtractStage apply(XMLExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, Option<String> inputField, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> xsd) {
        return new XMLExtractStage(plugin, name, description, schema, outputView, input, inputField, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, xsd);
    }

    public Option<Tuple14<XMLExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, Option<String>, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>>> unapply(XMLExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), x$0.inputField(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.xsd()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$execute$2(String xsd$1, String xml) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Validator validator = schemaFactory.newSchema(new StreamSource(new StringReader(xsd$1))).newValidator();
        validator.validate(new StreamSource(new StringReader(xml)));
    }

    public static final /* synthetic */ void $anonfun$execute$4(String xsd$2, String xml) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Validator validator = schemaFactory.newSchema(new StreamSource(new StringReader(xsd$2))).newValidator();
        validator.validate(new StreamSource(new StringReader(xml)));
    }

    private XMLExtractStage$() {
        MODULE$ = this;
    }
}

