/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.transform;

import ai.tripl.arc.api.API;
import ai.tripl.arc.transform.DiffTransform;
import ai.tripl.arc.transform.DiffTransformStage;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple10;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DiffTransformStage$
implements scala.Serializable {
    public static DiffTransformStage$ MODULE$;

    static {
        new DiffTransformStage$();
    }

    public Option<Dataset<Row>> execute(DiffTransformStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset inputLeftDF = spark.table(stage.inputLeftView());
        Dataset inputRightDF = spark.table(stage.inputRightView());
        Dataset leftHashDF = inputLeftDF.withColumn("_hash", functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputLeftDF.columns())).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))));
        Dataset rightHashDF = inputRightDF.withColumn("_hash", functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputRightDF.columns())).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))));
        Dataset transformedDF = leftHashDF.joinWith(rightHashDF, leftHashDF.apply("_hash").$eq$eq$eq((Object)rightHashDF.apply("_hash")), "full");
        Object object = stage.persist() && !transformedDF.isStreaming() ? transformedDF.persist(arcContext.storageLevel()) : BoxedUnit.UNIT;
        Dataset outputIntersectionDF = transformedDF.filter(functions$.MODULE$.col("_1").isNotNull()).filter(functions$.MODULE$.col("_2").isNotNull()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("_1.*")})).drop("_hash");
        Dataset outputLeftDF = transformedDF.filter(functions$.MODULE$.col("_2").isNull()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("_1.*")})).drop("_hash");
        Dataset outputRightDF = transformedDF.filter(functions$.MODULE$.col("_1").isNull()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("_2.*")})).drop("_hash");
        stage.outputIntersectionView().foreach((Function1 & Serializable & scala.Serializable)outputIntersectionView -> {
            DiffTransformStage$.$anonfun$execute$3(arcContext, outputIntersectionDF, outputIntersectionView);
            return BoxedUnit.UNIT;
        });
        stage.outputLeftView().foreach((Function1 & Serializable & scala.Serializable)outputLeftView -> {
            DiffTransformStage$.$anonfun$execute$4(arcContext, outputLeftDF, outputLeftView);
            return BoxedUnit.UNIT;
        });
        stage.outputRightView().foreach((Function1 & Serializable & scala.Serializable)outputRightView -> {
            DiffTransformStage$.$anonfun$execute$5(arcContext, outputRightDF, outputRightView);
            return BoxedUnit.UNIT;
        });
        return Option$.MODULE$.apply((Object)outputIntersectionDF);
    }

    public DiffTransformStage apply(DiffTransform plugin, String name, Option<String> description, String inputLeftView, String inputRightView, Option<String> outputIntersectionView, Option<String> outputLeftView, Option<String> outputRightView, Map<String, String> params, boolean persist) {
        return new DiffTransformStage(plugin, name, description, inputLeftView, inputRightView, outputIntersectionView, outputLeftView, outputRightView, params, persist);
    }

    public Option<Tuple10<DiffTransform, String, Option<String>, String, String, Option<String>, Option<String>, Option<String>, Map<String, String>, Object>> unapply(DiffTransformStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputLeftView(), (Object)x$0.inputRightView(), x$0.outputIntersectionView(), x$0.outputLeftView(), x$0.outputRightView(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$execute$3(API.ARCContext arcContext$1, Dataset outputIntersectionDF$1, String outputIntersectionView) {
        if (arcContext$1.immutableViews()) {
            outputIntersectionDF$1.createTempView(outputIntersectionView);
        } else {
            outputIntersectionDF$1.createOrReplaceTempView(outputIntersectionView);
        }
    }

    public static final /* synthetic */ void $anonfun$execute$4(API.ARCContext arcContext$1, Dataset outputLeftDF$1, String outputLeftView) {
        if (arcContext$1.immutableViews()) {
            outputLeftDF$1.createTempView(outputLeftView);
        } else {
            outputLeftDF$1.createOrReplaceTempView(outputLeftView);
        }
    }

    public static final /* synthetic */ void $anonfun$execute$5(API.ARCContext arcContext$1, Dataset outputRightDF$1, String outputRightView) {
        if (arcContext$1.immutableViews()) {
            outputRightDF$1.createTempView(outputRightView);
        } else {
            outputRightDF$1.createOrReplaceTempView(outputRightView);
        }
    }

    private DiffTransformStage$() {
        MODULE$ = this;
    }
}

