/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.transform;

import ai.tripl.arc.api.API;
import ai.tripl.arc.transform.JSONTransform;
import ai.tripl.arc.transform.JSONTransformStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple9;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JSONTransformStage$
implements scala.Serializable {
    public static JSONTransformStage$ MODULE$;

    static {
        new JSONTransformStage$();
    }

    public Option<Dataset<Row>> execute(JSONTransformStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset df = spark.table(stage.inputView());
        HashMap<String, Object> dropMap = new HashMap<String, Object>();
        Seq nulls = (Seq)((TraversableLike)df.schema().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)JSONTransformStage$.$anonfun$execute$1(x$12)))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.name(), Seq$.MODULE$.canBuildFrom());
        Object object = !nulls.isEmpty() ? dropMap.put("NullType", JavaConverters$.MODULE$.seqAsJavaListConverter(nulls).asJava()) : BoxedUnit.UNIT;
        stage.stageDetail().put((Object)"drop", dropMap);
        try {
            dataset2 = df.toJSON().toDF();
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset transformedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset3;
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset3 = transformedDF.repartition(numPartitions);
            } else if (None$.MODULE$.equals(option)) {
                dataset3 = transformedDF;
            } else {
                throw new MatchError(option);
            }
            dataset = dataset3;
        } else {
            Dataset dataset4;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> transformedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset4 = transformedDF.repartition(numPartitions, (Seq)partitionCols);
            } else if (None$.MODULE$.equals(option)) {
                dataset4 = transformedDF.repartition((Seq)partitionCols);
            } else {
                throw new MatchError(option);
            }
            dataset = dataset4;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public JSONTransformStage apply(JSONTransform plugin, String name, Option<String> description, String inputView, String outputView, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy) {
        return new JSONTransformStage(plugin, name, description, inputView, outputView, params, persist, numPartitions, partitionBy);
    }

    public Option<Tuple9<JSONTransform, String, Option<String>, String, String, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>>> unapply(JSONTransformStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.outputView(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(StructField x$12) {
        DataType dataType = x$12.dataType();
        NullType$ nullType$ = NullType$.MODULE$;
        return !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null);
    }

    private JSONTransformStage$() {
        MODULE$ = this;
    }
}

