/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.validate;

import ai.tripl.arc.api.API;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import ai.tripl.arc.validate.SQLValidate;
import ai.tripl.arc.validate.SQLValidateStage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple7;
import scala.collection.mutable.Map;

public final class SQLValidateStage$
implements Serializable {
    public static SQLValidateStage$ MODULE$;

    static {
        new SQLValidateStage$();
    }

    public Option<Dataset<Row>> execute(SQLValidateStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset dataset;
        String signature = "SQLValidate requires query to return 1 row with [outcome: boolean, message: string] signature.";
        String stmt = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)stmt);
        try {
            dataset = spark.sql(stmt);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset df = dataset;
        long count = df.persist(arcContext.storageLevel()).count();
        if (df.count() != 1L || df.schema().length() != 2) {
            throw new DetailException(signature, count, df, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        HashMap messageMap = new HashMap();
        try {
            Option option;
            Row row = (Row)df.first();
            boolean resultIsNull = row.isNullAt(0);
            boolean messageIsNull = row.isNullAt(1);
            if (resultIsNull) {
                throw new DetailException(signature, messageIsNull, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            String message = row.getString(1);
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                messageMap = (HashMap)objectMapper.readValue(message, HashMap.class);
                option = stage.stageDetail().put((Object)"message", (Object)messageMap);
            }
            catch (Exception e) {
                option = stage.stageDetail().put((Object)"message", (Object)message);
            }
            boolean result = row.getBoolean(0);
            if (!result) {
                throw new DetailException(message, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassCastException) {
                throw new DetailException(signature, count, df, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            if (throwable2 instanceof Exception && throwable2 instanceof DetailException) {
                Exception exception = (Exception)throwable2;
                throw exception;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            throw throwable;
        }
        df.unpersist();
        return Option$.MODULE$.apply((Object)df);
    }

    public SQLValidateStage apply(SQLValidate plugin, String name, Option<String> description, URI inputURI, String sql, scala.collection.immutable.Map<String, String> sqlParams, scala.collection.immutable.Map<String, String> params) {
        return new SQLValidateStage(plugin, name, description, inputURI, sql, sqlParams, params);
    }

    public Option<Tuple7<SQLValidate, String, Option<String>, URI, String, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> unapply(SQLValidateStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputURI(), (Object)x$0.sql(), x$0.sqlParams(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SQLValidateStage$() {
        MODULE$ = this;
    }
}

