/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.transform;

import ai.tripl.arc.api.API;
import ai.tripl.arc.transform.SQLTransform;
import ai.tripl.arc.transform.SQLTransformStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.QueryExecutionUtils$;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple11;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SQLTransformStage$
implements scala.Serializable {
    public static SQLTransformStage$ MODULE$;

    static {
        new SQLTransformStage$();
    }

    public Option<Dataset<Row>> execute(SQLTransformStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        String stmt = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)stmt);
        try {
            dataset2 = spark.sql(stmt);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Dataset transformedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset3;
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset3 = transformedDF.repartition(numPartitions);
            } else if (None$.MODULE$.equals(option)) {
                dataset3 = transformedDF;
            } else {
                throw new MatchError(option);
            }
            dataset = dataset3;
        } else {
            Dataset dataset4;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> transformedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset4 = transformedDF.repartition(numPartitions, (Seq)partitionCols);
            } else if (None$.MODULE$.equals(option)) {
                dataset4 = transformedDF.repartition((Seq)partitionCols);
            } else {
                throw new MatchError(option);
            }
            dataset = dataset4;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"partitionFilters", QueryExecutionUtils$.MODULE$.getPartitionFilters(repartitionedDF.queryExecution().executedPlan()).toArray(ClassTag$.MODULE$.apply(String.class)));
            stage.stageDetail().put((Object)"dataFilters", QueryExecutionUtils$.MODULE$.getDataFilters(repartitionedDF.queryExecution().executedPlan()).toArray(ClassTag$.MODULE$.apply(String.class)));
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public SQLTransformStage apply(SQLTransform plugin, String name, Option<String> description, URI inputURI, String sql, String outputView, scala.collection.immutable.Map<String, String> params, scala.collection.immutable.Map<String, String> sqlParams, boolean persist, Option<Object> numPartitions, List<String> partitionBy) {
        return new SQLTransformStage(plugin, name, description, inputURI, sql, outputView, params, sqlParams, persist, numPartitions, partitionBy);
    }

    public Option<Tuple11<SQLTransform, String, Option<String>, URI, String, String, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>>> unapply(SQLTransformStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputURI(), (Object)x$0.sql(), (Object)x$0.outputView(), x$0.params(), x$0.sqlParams(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SQLTransformStage$() {
        MODULE$ = this;
    }
}

