/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.config;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.API$AmazonS3EncryptionType$;
import ai.tripl.arc.api.API$AmazonS3EncryptionType$SSE_C$;
import ai.tripl.arc.api.API$AmazonS3EncryptionType$SSE_KMS$;
import ai.tripl.arc.api.API$AmazonS3EncryptionType$SSE_S3$;
import ai.tripl.arc.api.API$Authentication$AmazonAnonymous$;
import ai.tripl.arc.api.API$EncodingTypeBase64$;
import ai.tripl.arc.api.API$EncodingTypeHexadecimal$;
import ai.tripl.arc.api.API$FailModeTypeFailFast$;
import ai.tripl.arc.api.API$FailModeTypePermissive$;
import ai.tripl.arc.api.API$OutputModeTypeAppend$;
import ai.tripl.arc.api.API$OutputModeTypeComplete$;
import ai.tripl.arc.api.API$OutputModeTypeUpdate$;
import ai.tripl.arc.api.Delimiter;
import ai.tripl.arc.api.Delimiter$Comma$;
import ai.tripl.arc.api.Delimiter$Custom$;
import ai.tripl.arc.api.Delimiter$DefaultHive$;
import ai.tripl.arc.api.Delimiter$Pipe$;
import ai.tripl.arc.api.QuoteCharacter;
import ai.tripl.arc.api.QuoteCharacter$Disabled$;
import ai.tripl.arc.api.QuoteCharacter$DoubleQuote$;
import ai.tripl.arc.api.QuoteCharacter$SingleQuote$;
import ai.tripl.arc.config.Error;
import ai.tripl.arc.config.Error$;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.ControlUtils$;
import ai.tripl.arc.util.EitherUtils$;
import ai.tripl.arc.util.MetadataSchema$;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.net.URI;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Set;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.spark.SparkFiles$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;

public final class ConfigUtils$ {
    public static ConfigUtils$ MODULE$;

    static {
        new ConfigUtils$();
    }

    public Either<List<Error.Error>, String> getConfigString(URI uri, API.ARCContext arcContext, SparkSession spark, Logger logger) {
        Right right;
        String string = uri.getScheme();
        if ("local".equals(string)) {
            URI filePath = new URI(SparkFiles$.MODULE$.get(uri.getPath()));
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(filePath, spark, logger);
            right = package$.MODULE$.Right().apply((Object)etlConfString);
        } else if ("file".equals(string)) {
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            right = package$.MODULE$.Right().apply((Object)etlConfString);
        } else if ("classpath".equals(string)) {
            String path = new StringBuilder(1).append("/").append(uri.getHost()).append(uri.getPath()).toString();
            String etlConfString = (String)ControlUtils$.MODULE$.using(this.getClass().getResourceAsStream(path), (Function1 & Serializable & scala.Serializable)is -> Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString());
            right = package$.MODULE$.Right().apply((Object)etlConfString);
        } else if ("dbfs".equals(string)) {
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            right = package$.MODULE$.Right().apply((Object)etlConfString);
        } else if ("s3a".equals(string)) {
            None$ none$;
            String value;
            String value2;
            Option s3aAccessKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.access.key").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_S3A_ACCESS_KEY"));
            Option s3aSecretKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.secret.key").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_S3A_SECRET_KEY"));
            Option s3aEndpoint = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.endpoint").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_S3A_ENDPOINT"));
            Option s3aConnectionSSLEnabled = arcContext.commandLineArguments().get((Object)"etl.config.fs.s3a.connection.ssl.enabled").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_S3A_CONNECTION_SSL_ENABLED"));
            Option option = s3aAccessKey;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new StringBuilder(125).append("AWS Access Key not provided for: ").append(uri).append(". Set etl.config.fs.s3a.access.key property or ETL_CONF_S3A_ACCESS_KEY environment variable.").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            String string2 = value2 = (String)some.value();
            String accessKey = string2;
            Option option2 = s3aSecretKey;
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new IllegalArgumentException(new StringBuilder(125).append("AWS Secret Key not provided for: ").append(uri).append(". Set etl.config.fs.s3a.secret.key property or ETL_CONF_S3A_SECRET_KEY environment variable.").toString());
                }
                throw new MatchError((Object)option2);
            }
            Some some2 = (Some)option2;
            String string3 = value = (String)some2.value();
            String secretKey = string3;
            Option option3 = s3aConnectionSSLEnabled;
            if (option3 instanceof Some) {
                Option option4;
                Some some3 = (Some)option3;
                String value3 = (String)some3.value();
                try {
                    option4 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(value3)).toBoolean()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(new StringBuilder(160).append("AWS SSL configuration incorrect for: ").append(uri).append(". Ensure etl.config.fs.s3a.connection.ssl.enabled or ETL_CONF_S3A_CONNECTION_SSL_ENABLED environment variables are boolean.").toString());
                }
                none$ = option4;
            } else if (None$.MODULE$.equals(option3)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)option3);
            }
            None$ connectionSSLEnabled = none$;
            CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AmazonAccessKey(accessKey, secretKey, (Option<String>)s3aEndpoint, (Option<Object>)connectionSSLEnabled)), spark, logger);
            String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
            right = package$.MODULE$.Right().apply((Object)etlConfString);
        } else {
            boolean bl = "wasb".equals(string) ? true : "wasbs".equals(string);
            if (bl) {
                String value;
                String value4;
                Option azureAccountName = arcContext.commandLineArguments().get((Object)"etl.config.fs.azure.account.name").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_AZURE_ACCOUNT_NAME"));
                Option azureAccountKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.azure.account.key").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_AZURE_ACCOUNT_KEY"));
                Option option = azureAccountName;
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException(new StringBuilder(137).append("Azure Account Name not provided for: ").append(uri).append(". Set etl.config.fs.azure.account.name property or ETL_CONF_AZURE_ACCOUNT_NAME environment variable.").toString());
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String string4 = value4 = (String)some.value();
                String accountName = string4;
                Option option5 = azureAccountKey;
                if (!(option5 instanceof Some)) {
                    if (None$.MODULE$.equals(option5)) {
                        throw new IllegalArgumentException(new StringBuilder(134).append("Azure Account Key not provided for: ").append(uri).append(". Set etl.config.fs.azure.account.key property or ETL_CONF_AZURE_ACCOUNT_KEY environment variable.").toString());
                    }
                    throw new MatchError((Object)option5);
                }
                Some some4 = (Some)option5;
                String string5 = value = (String)some4.value();
                String accountKey = string5;
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureSharedKey(accountName, accountKey)), spark, logger);
                String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                right = package$.MODULE$.Right().apply((Object)etlConfString);
            } else if ("adl".equals(string)) {
                String value;
                String value5;
                Option adlClientID = arcContext.commandLineArguments().get((Object)"etl.config.fs.adl.oauth2.client.id").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_ADL_OAUTH2_CLIENT_ID"));
                Option adlRefreshToken = arcContext.commandLineArguments().get((Object)"etl.config.fs.adl.oauth2.refresh.token").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_ADL_OAUTH2_REFRESH_TOKEN"));
                Option option = adlClientID;
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException(new StringBuilder(147).append("Azure Data Lake Storage Client ID not provided for: ").append(uri).append(". Set etl.config.fs.adl.oauth2.client.id or ETL_CONF_ADL_OAUTH2_CLIENT_ID environment variable.").toString());
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String string6 = value5 = (String)some.value();
                String clientID = string6;
                Option option6 = adlRefreshToken;
                if (!(option6 instanceof Some)) {
                    if (None$.MODULE$.equals(option6)) {
                        throw new IllegalArgumentException(new StringBuilder(168).append("Azure Data Lake Storage Refresh Token not provided for: ").append(uri).append(". Set etl.config.fs.adl.oauth2.refresh.token property or ETL_CONF_ADL_OAUTH2_REFRESH_TOKEN environment variable.").toString());
                    }
                    throw new MatchError((Object)option6);
                }
                Some some5 = (Some)option6;
                String string7 = value = (String)some5.value();
                String refreshToken = string7;
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureDataLakeStorageToken(clientID, refreshToken)), spark, logger);
                String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                right = package$.MODULE$.Right().apply((Object)etlConfString);
            } else {
                boolean bl2 = "abfs".equals(string) ? true : "abfss".equals(string);
                if (bl2) {
                    String value;
                    String value6;
                    Option dfAccountName = arcContext.commandLineArguments().get((Object)"etl.config.fs.dfs.account.name").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_DFS_ACCOUNT_NAME"));
                    Option dfAccessKey = arcContext.commandLineArguments().get((Object)"etl.config.fs.dfs.access.key").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_DFS_ACCESS_KEY"));
                    Option option = dfAccountName;
                    if (!(option instanceof Some)) {
                        if (None$.MODULE$.equals(option)) {
                            throw new IllegalArgumentException(new StringBuilder(137).append("Azure DLS Account Name not provided for: ").append(uri).append(". Set etl.config.fs.dfs.account.name property or ETL_CONF_DFS_ACCOUNT_NAME environment variable.").toString());
                        }
                        throw new MatchError((Object)option);
                    }
                    Some some = (Some)option;
                    String string8 = value6 = (String)some.value();
                    String accountName = string8;
                    Option option7 = dfAccessKey;
                    if (!(option7 instanceof Some)) {
                        if (None$.MODULE$.equals(option7)) {
                            throw new IllegalArgumentException(new StringBuilder(131).append("Azure DLS Access Key not provided for: ").append(uri).append(". Set etl.config.fs.dfs.access.key property or ETL_CONF_DFS_ACCESS_KEY environment variable.").toString());
                        }
                        throw new MatchError((Object)option7);
                    }
                    Some some6 = (Some)option7;
                    String string9 = value = (String)some6.value();
                    String accountKey = string9;
                    CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2AccountKey(accountName, accountKey)), spark, logger);
                    String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                    right = package$.MODULE$.Right().apply((Object)etlConfString);
                } else if ("gs".equals(string)) {
                    String value;
                    String value7;
                    Option gsProjectID = arcContext.commandLineArguments().get((Object)"etl.config.fs.gs.project.id").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_GOOGLE_CLOUD_PROJECT_ID"));
                    Option gsKeyfilePath = arcContext.commandLineArguments().get((Object)"etl.config.fs.google.cloud.auth.service.account.json.keyfile").orElse((Function0 & Serializable & scala.Serializable)() -> Properties$.MODULE$.envOrNone("ETL_CONF_GOOGLE_CLOUD_AUTH_SERVICE_ACCOUNT_JSON_KEYFILE"));
                    Option option = gsProjectID;
                    if (!(option instanceof Some)) {
                        if (None$.MODULE$.equals(option)) {
                            throw new IllegalArgumentException(new StringBuilder(133).append("Google Cloud Project ID not provided for: ").append(uri).append(". Set etl.config.fs.gs.project.id or ETL_CONF_GOOGLE_CLOUD_PROJECT_ID environment variable.").toString());
                        }
                        throw new MatchError((Object)option);
                    }
                    Some some = (Some)option;
                    String string10 = value7 = (String)some.value();
                    String projectID = string10;
                    Option option8 = gsKeyfilePath;
                    if (!(option8 instanceof Some)) {
                        if (None$.MODULE$.equals(option8)) {
                            throw new IllegalArgumentException(new StringBuilder(200).append("Google Cloud KeyFile Path not provided for: ").append(uri).append(". Set etl.config.fs.google.cloud.auth.service.account.json.keyfile property or ETL_CONF_GOOGLE_CLOUD_AUTH_SERVICE_ACCOUNT_JSON_KEYFILE environment variable.").toString());
                        }
                        throw new MatchError((Object)option8);
                    }
                    Some some7 = (Some)option8;
                    String string11 = value = (String)some7.value();
                    String keyFilePath = string11;
                    CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)new Some((Object)new API.Authentication.GoogleCloudStorageKeyFile(projectID, keyFilePath)), spark, logger);
                    String etlConfString = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                    right = package$.MODULE$.Right().apply((Object)etlConfString);
                } else {
                    Error.ConfigError configError = new Error.ConfigError("file", (Option<Object>)None$.MODULE$, "make sure url scheme is defined e.g. file://${pwd}");
                    right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
                }
            }
        }
        return right;
    }

    public String readIPYNB(String uri, String notebook) {
        String kernelspecName;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonTree = objectMapper.readTree(notebook);
        String string = kernelspecName = jsonTree.get("metadata").get("kernelspec").get("name").asText();
        String string2 = "arc";
        if (string != null ? !string.equals(string2) : string2 != null) {
            throw new Exception(new StringBuilder(69).append("file ").append(uri).append(" does not appear to be a valid arc notebook. Has kernelspec: '").append(kernelspecName).append("'.").toString());
        }
        List sources = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(jsonTree.get("cells").iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)cell -> BoxesRunTime.boxToBoolean((boolean)ConfigUtils$.$anonfun$readIPYNB$1(cell))).map((Function1 & Serializable & scala.Serializable)cell -> ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(cell.get("source").iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asText()).mkString("").trim()).map((Function1 & Serializable & scala.Serializable)cell -> cell.replaceAll(",$", "")).toList();
        List configs = (List)((List)sources.filter((Function1 & Serializable & scala.Serializable)cell -> BoxesRunTime.boxToBoolean((boolean)cell.startsWith("%configplugin")))).map((Function1 & Serializable & scala.Serializable)cell -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cell.split("\n"))).drop(1))).mkString("\n"), List$.MODULE$.canBuildFrom());
        List lifecycles = (List)((List)sources.filter((Function1 & Serializable & scala.Serializable)cell -> BoxesRunTime.boxToBoolean((boolean)cell.startsWith("%lifecycleplugin")))).map((Function1 & Serializable & scala.Serializable)cell -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cell.split("\n"))).drop(1))).mkString("\n"), List$.MODULE$.canBuildFrom());
        List stages = (List)((List)sources.filter((Function1 & Serializable & scala.Serializable)cell -> BoxesRunTime.boxToBoolean((boolean)ConfigUtils$.$anonfun$readIPYNB$9(cell)))).map((Function1 & Serializable & scala.Serializable)cell -> cell.startsWith("%arc") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cell.split("\n"))).drop(1))).mkString("\n") : cell, List$.MODULE$.canBuildFrom());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(112).append("\n      |{\n      |\"plugins\": {\n      |\"config\": [").append(configs.mkString("\n", ",\n", "\n")).append("],\n      |\"lifecycle\": [").append(lifecycles.mkString("\n", ",\n", "\n")).append("]\n      |},\n      |\"stages\": [").append(stages.mkString("\n", ",\n", "\n")).append("]\n      |}").toString())).stripMargin();
    }

    public Map<String, String> readMap(String path, Config c) {
        Map map;
        if (c.hasPath(path)) {
            Set params = c.getConfig(path).entrySet();
            map = ((TraversableOnce)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(params).asScala()).map((Function1 & Serializable & scala.Serializable)e -> {
                String k = ((String)e.getKey()).replaceAll("^\"|\"$", "");
                String v = ((ConfigValue)e.getValue()).unwrapped().toString();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public Either<List<Error.ConfigError>, String> checkValidKeys(Config c, Function0<Seq<String>> expectedKeys) {
        List diffKeys = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.root().keySet()).asScala()).toSeq().diff((GenSeq)expectedKeys.apply())).toList();
        return diffKeys.isEmpty() ? package$.MODULE$.Right().apply((Object)"") : package$.MODULE$.Left().apply(diffKeys.map((Function1 & Serializable & scala.Serializable)key -> {
            Seq<String> possibleKeys = MODULE$.levenshteinDistance((Seq<String>)((Seq)expectedKeys.apply()), (String)key, 4);
            return !possibleKeys.isEmpty() ? (c.getValue(key).origin().description().contains("merge of") ? new Error.ConfigError((String)key, (Option<Object>)None$.MODULE$, new StringBuilder(49).append("Invalid attribute '").append((String)key).append("'. Perhaps you meant one of: ").append(((TraversableOnce)possibleKeys.map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(2).append("'").append((String)field).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).append(".").toString()) : new Error.ConfigError((String)key, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(key).origin().lineNumber())), new StringBuilder(49).append("Invalid attribute '").append((String)key).append("'. Perhaps you meant one of: ").append(((TraversableOnce)possibleKeys.map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(2).append("'").append((String)field).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).append(".").toString())) : new Error.ConfigError((String)key, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(key).origin().lineNumber())), new StringBuilder(21).append("Invalid attribute '").append((String)key).append("'.").toString());
        }, List$.MODULE$.canBuildFrom()));
    }

    public Seq<String> levenshteinDistance(Seq<String> keys, String input, int limit) {
        UTF8String inputUTF8 = UTF8String.fromString((String)input);
        return (Seq)((TraversableLike)keys.map((Function1 & Serializable & scala.Serializable)k -> {
            int v = inputUTF8.levenshteinDistance(UTF8String.fromString((String)k));
            return new Tuple2(k, (Object)BoxesRunTime.boxToInteger((int)v));
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ConfigUtils$.$anonfun$levenshteinDistance$2(limit, x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            String k;
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = k = (String)tuple2._1();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Either<List<Error.ConfigError>, String> parseGlob(String path, String glob, Config c) {
        Either either;
        try {
            GlobPattern.compile((String)glob);
            if (glob.trim().startsWith("s3://") | glob.trim().startsWith("s3n://")) {
                throw new Exception("s3:// and s3n:// are no longer supported. Please use s3a:// instead.");
            }
            either = package$.MODULE$.Right().apply((Object)glob);
        }
        catch (Exception e) {
            either = ConfigUtils$.err$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), e.getMessage(), path);
        }
        return either;
    }

    /*
     * Unable to fully structure code
     */
    public Either<List<Error.ConfigError>, Option<API.Authentication>> readAuthentication(String path, Config c) {
        block54: {
            try {
                block55: {
                    block57: {
                        block63: {
                            block65: {
                                block67: {
                                    block66: {
                                        block64: {
                                            block62: {
                                                block61: {
                                                    block60: {
                                                        block59: {
                                                            block58: {
                                                                block56: {
                                                                    if (!c.hasPath(path)) break block55;
                                                                    authentication = this.readMap("authentication", c);
                                                                    if (authentication.isEmpty()) {
                                                                        v0 = package$.MODULE$.Right().apply((Object)None$.MODULE$);
                                                                        break block54;
                                                                    }
                                                                    var24_4 = false;
                                                                    var25_5 = null;
                                                                    var26_6 = authentication.get((Object)"method");
                                                                    if (!(var26_6 instanceof Some)) break block56;
                                                                    var24_4 = true;
                                                                    var25_5 = (Some)var26_6;
                                                                    var27_7 = (String)var25_5.value();
                                                                    if (!"AzureSharedKey".equals(var27_7)) break block56;
                                                                    var29_8 = authentication.get((Object)"accountName");
                                                                    if (!(var29_8 instanceof Some)) {
                                                                        if (None$.MODULE$.equals(var29_8)) {
                                                                            throw new Exception("Authentication method 'AzureSharedKey' requires 'accountName' parameter.");
                                                                        }
                                                                        throw new MatchError((Object)var29_8);
                                                                    }
                                                                    var30_9 = (Some)var29_8;
                                                                    var22_11 = v = (String)var30_9.value();
                                                                    accountName = var22_11;
                                                                    if (accountName.contains("fs.azure")) {
                                                                        throw new Exception("Authentication method 'AzureSharedKey' 'accountName' should be just the account name not 'fs.azure.account.key...''.");
                                                                    }
                                                                    var33_13 = authentication.get((Object)"signature");
                                                                    if (!(var33_13 instanceof Some)) {
                                                                        if (None$.MODULE$.equals(var33_13)) {
                                                                            throw new Exception("Authentication method 'AzureSharedKey' requires 'signature' parameter.");
                                                                        }
                                                                        throw new MatchError((Object)var33_13);
                                                                    }
                                                                    var34_14 = (Some)var33_13;
                                                                    var21_16 = v = (String)var34_14.value();
                                                                    signature = var21_16;
                                                                    var3_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureSharedKey(accountName, signature)));
                                                                    break block57;
                                                                }
                                                                if (!var24_4 || !"AzureSharedAccessSignature".equals(var36_19 = (String)var25_5.value())) break block58;
                                                                var38_20 = authentication.get((Object)"accountName");
                                                                if (!(var38_20 instanceof Some)) {
                                                                    if (None$.MODULE$.equals(var38_20)) {
                                                                        throw new Exception("Authentication method 'AzureSharedAccessSignature' requires 'accountName' parameter.");
                                                                    }
                                                                    throw new MatchError((Object)var38_20);
                                                                }
                                                                var39_21 = (Some)var38_20;
                                                                var20_23 = v = (String)var39_21.value();
                                                                accountName = var20_23;
                                                                if (accountName.contains("fs.azure")) {
                                                                    throw new Exception("Authentication method 'AzureSharedAccessSignature' 'accountName' should be just the account name not 'fs.azure.account.key...''.");
                                                                }
                                                                var42_25 = authentication.get((Object)"container");
                                                                if (!(var42_25 instanceof Some)) {
                                                                    if (None$.MODULE$.equals(var42_25)) {
                                                                        throw new Exception("Authentication method 'AzureSharedAccessSignature' requires 'container' parameter.");
                                                                    }
                                                                    throw new MatchError((Object)var42_25);
                                                                }
                                                                var43_26 = (Some)var42_25;
                                                                var19_28 = v = (String)var43_26.value();
                                                                container = var19_28;
                                                                if (accountName.contains("fs.azure")) {
                                                                    throw new Exception("Authentication method 'AzureSharedAccessSignature' 'container' should be just the container name not 'fs.azure.account.key...''.");
                                                                }
                                                                var46_30 = authentication.get((Object)"token");
                                                                if (!(var46_30 instanceof Some)) {
                                                                    if (None$.MODULE$.equals(var46_30)) {
                                                                        throw new Exception("Authentication method 'AzureSharedAccessSignature' requires 'container' parameter.");
                                                                    }
                                                                    throw new MatchError((Object)var46_30);
                                                                }
                                                                var47_31 = (Some)var46_30;
                                                                var18_33 = v = (String)var47_31.value();
                                                                token = var18_33;
                                                                var3_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureSharedAccessSignature(accountName, container, token)));
                                                                break block57;
                                                            }
                                                            if (!var24_4 || !"AzureDataLakeStorageToken".equals(var49_35 = (String)var25_5.value())) break block59;
                                                            var51_36 = authentication.get((Object)"clientID");
                                                            if (!(var51_36 instanceof Some)) {
                                                                if (None$.MODULE$.equals(var51_36)) {
                                                                    throw new Exception("Authentication method 'AzureDataLakeStorageToken' requires 'clientID' parameter.");
                                                                }
                                                                throw new MatchError((Object)var51_36);
                                                            }
                                                            var52_37 = (Some)var51_36;
                                                            var17_39 = v = (String)var52_37.value();
                                                            clientID = var17_39;
                                                            var55_41 = authentication.get((Object)"refreshToken");
                                                            if (!(var55_41 instanceof Some)) {
                                                                if (None$.MODULE$.equals(var55_41)) {
                                                                    throw new Exception("Authentication method 'AzureDataLakeStorageToken' requires 'refreshToken' parameter.");
                                                                }
                                                                throw new MatchError((Object)var55_41);
                                                            }
                                                            var56_42 = (Some)var55_41;
                                                            var16_44 = v = (String)var56_42.value();
                                                            refreshToken = var16_44;
                                                            var3_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageToken(clientID, refreshToken)));
                                                            break block57;
                                                        }
                                                        if (!var24_4 || !"AzureDataLakeStorageGen2AccountKey".equals(var58_46 = (String)var25_5.value())) break block60;
                                                        var60_47 = authentication.get((Object)"accountName");
                                                        if (!(var60_47 instanceof Some)) {
                                                            if (None$.MODULE$.equals(var60_47)) {
                                                                throw new Exception("Authentication method 'AzureDataLakeStorageGen2AccountKey' requires 'accountName' parameter.");
                                                            }
                                                            throw new MatchError((Object)var60_47);
                                                        }
                                                        var61_48 = (Some)var60_47;
                                                        var15_50 = v = (String)var61_48.value();
                                                        accountName = var15_50;
                                                        var64_52 = authentication.get((Object)"accessKey");
                                                        if (!(var64_52 instanceof Some)) {
                                                            if (None$.MODULE$.equals(var64_52)) {
                                                                throw new Exception("Authentication method 'AzureDataLakeStorageGen2AccountKey' requires 'accessKey' parameter.");
                                                            }
                                                            throw new MatchError((Object)var64_52);
                                                        }
                                                        var65_53 = (Some)var64_52;
                                                        var14_55 = v = (String)var65_53.value();
                                                        accessKey = var14_55;
                                                        var3_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2AccountKey(accountName, accessKey)));
                                                        break block57;
                                                    }
                                                    if (!var24_4 || !"AzureDataLakeStorageGen2OAuth".equals(var67_57 = (String)var25_5.value())) break block61;
                                                    var69_58 = authentication.get((Object)"clientID");
                                                    if (!(var69_58 instanceof Some)) {
                                                        if (None$.MODULE$.equals(var69_58)) {
                                                            throw new Exception("Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'clientID' parameter.");
                                                        }
                                                        throw new MatchError((Object)var69_58);
                                                    }
                                                    var70_59 = (Some)var69_58;
                                                    var13_61 = v = (String)var70_59.value();
                                                    clientID = var13_61;
                                                    var73_63 = authentication.get((Object)"secret");
                                                    if (!(var73_63 instanceof Some)) {
                                                        if (None$.MODULE$.equals(var73_63)) {
                                                            throw new Exception("Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'secret' parameter.");
                                                        }
                                                        throw new MatchError((Object)var73_63);
                                                    }
                                                    var74_64 = (Some)var73_63;
                                                    var12_66 = v = (String)var74_64.value();
                                                    secret = var12_66;
                                                    var77_68 = authentication.get((Object)"directoryID");
                                                    if (!(var77_68 instanceof Some)) {
                                                        if (None$.MODULE$.equals(var77_68)) {
                                                            throw new Exception("Authentication method 'AzureDataLakeStorageGen2OAuth' requires 'directoryID' parameter.");
                                                        }
                                                        throw new MatchError((Object)var77_68);
                                                    }
                                                    var78_69 = (Some)var77_68;
                                                    var11_71 = v = (String)var78_69.value();
                                                    directoryID = var11_71;
                                                    var3_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AzureDataLakeStorageGen2OAuth(clientID, secret, directoryID)));
                                                    break block57;
                                                }
                                                if (!var24_4 || !"AmazonAccessKey".equals(var80_73 = (String)var25_5.value())) break block62;
                                                var82_74 = authentication.get((Object)"accessKeyID");
                                                if (!(var82_74 instanceof Some)) {
                                                    if (None$.MODULE$.equals(var82_74)) {
                                                        throw new Exception("Authentication method 'AmazonAccessKey' requires 'accessKeyID' parameter.");
                                                    }
                                                    throw new MatchError((Object)var82_74);
                                                }
                                                var83_75 = (Some)var82_74;
                                                var10_77 = v = (String)var83_75.value();
                                                accessKeyID = var10_77;
                                                var86_79 = authentication.get((Object)"secretAccessKey");
                                                if (!(var86_79 instanceof Some)) {
                                                    if (None$.MODULE$.equals(var86_79)) {
                                                        throw new Exception("Authentication method 'AmazonAccessKey' requires 'secretAccessKey' parameter.");
                                                    }
                                                    throw new MatchError((Object)var86_79);
                                                }
                                                var87_80 = (Some)var86_79;
                                                var9_82 = v = (String)var87_80.value();
                                                secretAccessKey = var9_82;
                                                var90_84 = authentication.get((Object)"endpoint");
                                                if (var90_84 instanceof Some) {
                                                    var91_85 = (Some)var90_84;
                                                    v = (String)var91_85.value();
                                                    uri = new URI(v);
                                                    inetAddress = InetAddress.getByName(uri.getHost());
                                                    replacedURI = new URI(uri.getScheme(), uri.getUserInfo(), inetAddress.getHostAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                                                    var8_90 = Option$.MODULE$.apply((Object)replacedURI.toString());
                                                } else if (None$.MODULE$.equals(var90_84)) {
                                                    var8_90 = None$.MODULE$;
                                                } else {
                                                    throw new MatchError((Object)var90_84);
                                                }
                                                endpoint = var8_90;
                                                var97_92 = authentication.get((Object)"sslEnabled");
                                                if (var97_92 instanceof Some) {
                                                    var98_93 = (Some)var97_92;
                                                    v = (String)var98_93.value();
                                                    try {
                                                        v1 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(v)).toBoolean()));
                                                    }
                                                    catch (Exception e) {
                                                        throw new IllegalArgumentException("Authentication method 'AmazonAccessKey' expects 'sslEnabled' parameter to be boolean.");
                                                    }
                                                    var7_96 = v1;
                                                } else if (None$.MODULE$.equals(var97_92)) {
                                                    var7_96 = None$.MODULE$;
                                                } else {
                                                    throw new MatchError((Object)var97_92);
                                                }
                                                sslEnabled = var7_96;
                                                var3_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonAccessKey(accessKeyID, secretAccessKey, (Option<String>)endpoint, (Option<Object>)sslEnabled)));
                                                break block57;
                                            }
                                            if (!var24_4 || !"AmazonIAM".equals(var101_98 = (String)var25_5.value())) break block63;
                                            encType = authentication.get((Object)"encryptionAlgorithm").flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readAuthentication$1(java.lang.String ), (Ljava/lang/String;)Lscala/Option;)());
                                            var105_102 = new Tuple3((Object)encType, (Object)(kmsId = authentication.get((Object)"kmsArn")), (Object)(customKey = authentication.get((Object)"customKey")));
                                            if (var105_102 == null) break block64;
                                            var106_103 = (Option)var105_102._1();
                                            var107_104 = (Option)var105_102._2();
                                            var108_105 = (Option)var105_102._3();
                                            if (!None$.MODULE$.equals(var106_103) || !None$.MODULE$.equals(var107_104) || !None$.MODULE$.equals(var108_105)) break block64;
                                            var6_106 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonIAM((Option<API.AmazonS3EncryptionType>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$)));
                                            break block65;
                                        }
                                        if (var105_102 == null) break block66;
                                        var109_107 = (Option)var105_102._1();
                                        var110_108 = (Option)var105_102._2();
                                        var111_109 = (Option)var105_102._3();
                                        if (!(var109_107 instanceof Some) || !API$AmazonS3EncryptionType$SSE_S3$.MODULE$.equals(var113_111 = (API.AmazonS3EncryptionType)(var112_110 = (Some)var109_107).value()) || !None$.MODULE$.equals(var110_108) || !None$.MODULE$.equals(var111_109)) break block66;
                                        var6_106 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonIAM((Option<API.AmazonS3EncryptionType>)encType, (Option<String>)kmsId, (Option<String>)None$.MODULE$)));
                                        break block65;
                                    }
                                    if (var105_102 == null) break block67;
                                    var114_112 = (Option)var105_102._1();
                                    var115_113 = (Option)var105_102._2();
                                    var116_114 = (Option)var105_102._3();
                                    if (!(var114_112 instanceof Some) || !API$AmazonS3EncryptionType$SSE_KMS$.MODULE$.equals(var118_116 = (API.AmazonS3EncryptionType)(var117_115 = (Some)var114_112).value()) || !(var115_113 instanceof Some) || !None$.MODULE$.equals(var116_114)) break block67;
                                    var6_106 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonIAM((Option<API.AmazonS3EncryptionType>)encType, (Option<String>)kmsId, (Option<String>)None$.MODULE$)));
                                    break block65;
                                }
                                if (var105_102 == null) ** GOTO lbl-1000
                                var119_117 = (Option)var105_102._1();
                                var120_118 = (Option)var105_102._2();
                                var121_119 = (Option)var105_102._3();
                                if (var119_117 instanceof Some && API$AmazonS3EncryptionType$SSE_C$.MODULE$.equals(var123_121 = (API.AmazonS3EncryptionType)(var122_120 = (Some)var119_117).value()) && None$.MODULE$.equals(var120_118) && var121_119 instanceof Some) {
                                    var6_106 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.AmazonIAM((Option<API.AmazonS3EncryptionType>)encType, (Option<String>)None$.MODULE$, (Option<String>)customKey)));
                                } else lbl-1000:
                                // 2 sources

                                {
                                    throw new Exception("Invalid authentication options for AmazonIAM method. See docs for allowed settings.");
                                }
                            }
                            var3_18 = var6_106;
                            break block57;
                        }
                        if (var24_4 && "AmazonAnonymous".equals(var124_122 = (String)var25_5.value())) {
                            var3_18 = package$.MODULE$.Right().apply((Object)new Some((Object)API$Authentication$AmazonAnonymous$.MODULE$));
                        } else if (var24_4 && "GoogleCloudStorageKeyFile".equals(var125_123 = (String)var25_5.value())) {
                            var127_124 = authentication.get((Object)"projectID");
                            if (!(var127_124 instanceof Some)) {
                                if (None$.MODULE$.equals(var127_124)) {
                                    throw new Exception("Authentication method 'GoogleCloudStorageKeyFile' requires 'projectID' parameter.");
                                }
                                throw new MatchError((Object)var127_124);
                            }
                            var128_125 = (Some)var127_124;
                            var5_127 = v = (String)var128_125.value();
                            projectID = var5_127;
                            var131_129 = authentication.get((Object)"keyFilePath");
                            if (!(var131_129 instanceof Some)) {
                                if (None$.MODULE$.equals(var131_129)) {
                                    throw new Exception("Authentication method 'GoogleCloudStorageKeyFile' requires 'keyFilePath' parameter.");
                                }
                                throw new MatchError((Object)var131_129);
                            }
                            var132_130 = (Some)var131_129;
                            var4_132 = v = (String)var132_130.value();
                            keyFilePath = var4_132;
                            var3_18 = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Authentication.GoogleCloudStorageKeyFile(projectID, keyFilePath)));
                        } else {
                            throw new Exception(new StringBuilder(41).append("Unable to parse authentication method: '").append(authentication.get((Object)"method").getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$readAuthentication$2(), ()Ljava/lang/String;)())).append("'").toString());
                        }
                    }
                    v0 = var3_18;
                    break block54;
                }
                v0 = package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            catch (Exception e) {
                v0 = ConfigUtils$.err$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringBuilder(29).append("Unable to read config value: ").append(e.getMessage()).toString(), path);
            }
        }
        return v0;
    }

    public Either<List<Error.ConfigError>, Option<API.Watermark>> readWatermark(String path, Config c) {
        Right right;
        block7: {
            try {
                if (c.hasPath(path)) {
                    String v;
                    String v2;
                    Map<String, String> watermark = this.readMap(path, c);
                    Option option = watermark.get((Object)"eventTime");
                    if (!(option instanceof Some)) {
                        if (None$.MODULE$.equals(option)) {
                            throw new Exception("Watermark requires 'eventTime' parameter.");
                        }
                        throw new MatchError((Object)option);
                    }
                    Some some = (Some)option;
                    String string = v2 = (String)some.value();
                    String eventTime = string;
                    Option option2 = watermark.get((Object)"delayThreshold");
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new Exception("Watermark requires 'delayThreshold' parameter.");
                        }
                        throw new MatchError((Object)option2);
                    }
                    Some some2 = (Some)option2;
                    String string2 = v = (String)some2.value();
                    String delayThreshold = string2;
                    right = package$.MODULE$.Right().apply((Object)new Some((Object)new API.Watermark(eventTime, delayThreshold)));
                    break block7;
                }
                right = package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            catch (Exception e) {
                right = ConfigUtils$.err$3((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringBuilder(29).append("Unable to read config value: ").append(e.getMessage()).toString(), path);
            }
        }
        return right;
    }

    public Either<List<Error.ConfigError>, URI> parseURI(String path, String uri, Config c) {
        Either either;
        try {
            URI u = new URI(uri);
            if (uri.trim().startsWith("s3://") | uri.trim().startsWith("s3n://")) {
                throw new Exception("s3:// and s3n:// are no longer supported. Please use s3a:// instead.");
            }
            either = package$.MODULE$.Right().apply((Object)u);
        }
        catch (Exception e) {
            either = ConfigUtils$.err$4((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), e.getMessage(), path);
        }
        return either;
    }

    public Either<List<Error.ConfigError>, List<API.ExtractColumn>> getExtractColumns(String uriKey, Either<List<Error.ConfigError>, Option<API.Authentication>> authentication, URI uri, SparkSession spark, Logger logger, Config c) {
        Either schema = EitherUtils$.MODULE$.eitherToMappableEither(this.textContentForURI(uriKey, authentication, uri, spark, logger, c)).rightFlatMap((Function1 & Serializable & scala.Serializable)text -> package$.MODULE$.Right().apply((Object)Option$.MODULE$.apply(text)));
        return EitherUtils$.MODULE$.eitherToMappableEither(schema).rightFlatMap((Function1 & Serializable & scala.Serializable)sch -> {
            Left left;
            Either cols = (Either)sch.map((Function1 & Serializable & scala.Serializable)s -> MetadataSchema$.MODULE$.parseJsonMetadata((String)s, logger)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply((Object)Nil$.MODULE$));
            Either either = cols;
            if (either instanceof Left) {
                Left left2 = (Left)either;
                List errs = (List)left2.value();
                left = package$.MODULE$.Left().apply(errs.map((Function1 & Serializable & scala.Serializable)e -> new Error.ConfigError("metadata error", (Option<Object>)None$.MODULE$, Error$.MODULE$.pipelineSimpleErrorMsg(e.errors())), List$.MODULE$.canBuildFrom()));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                List extractColumns = (List)right.value();
                left = package$.MODULE$.Right().apply((Object)extractColumns);
            } else {
                throw new MatchError((Object)either);
            }
            return left;
        });
    }

    public Either<List<Error.ConfigError>, String> textContentForURI(String uriKey, Either<List<Error.ConfigError>, Option<API.Authentication>> authentication, URI uri, SparkSession spark, Logger logger, Config c) {
        Either either;
        String string = uri.getScheme();
        if ("classpath".equals(string)) {
            String path = new StringBuilder(1).append("/").append(uri.getHost()).append(uri.getPath()).toString();
            either = (Either)ControlUtils$.MODULE$.using(this.getClass().getResourceAsStream(path), (Function1 & Serializable & scala.Serializable)is -> {
                String text = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                return package$.MODULE$.Right().apply((Object)text);
            });
        } else {
            authentication.right().map((Function1 & Serializable & scala.Serializable)auth -> {
                CloudUtils$.MODULE$.setHadoopConfiguration((Option<API.Authentication>)auth, spark, logger);
                return BoxedUnit.UNIT;
            });
            either = this.getBlob(uriKey, uri, spark, logger, c);
        }
        return either;
    }

    public Either<List<Error.ConfigError>, String> getBlob(String path, URI uri, SparkSession spark, Logger logger, Config c) {
        Right right;
        block3: {
            try {
                String textFile = CloudUtils$.MODULE$.getTextBlob(uri, spark, logger);
                if (textFile.length() == 0) {
                    right = ConfigUtils$.err$5((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringBuilder(18).append("File at ").append(uri.toString()).append(" is empty.").toString(), path);
                    break block3;
                }
                right = package$.MODULE$.Right().apply((Object)textFile);
            }
            catch (Exception e) {
                right = ConfigUtils$.err$5((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), e.getMessage(), path);
            }
        }
        return right;
    }

    public Either<List<Error.ConfigError>, API.EncodingType> parseEncoding(String path, String encoding, Config c) {
        Right right;
        String string = encoding.toLowerCase().trim();
        if ("base64".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$EncodingTypeBase64$.MODULE$);
        } else if ("hexadecimal".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$EncodingTypeHexadecimal$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, "invalid state please raise issue.");
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, SaveMode> parseSaveMode(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("append".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Append);
        } else if ("errorifexists".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.ErrorIfExists);
        } else if ("ignore".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Ignore);
        } else if ("overwrite".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)SaveMode.Overwrite);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, "invalid state please raise issue.");
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, API.OutputModeType> parseOutputModeType(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("append".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeAppend$.MODULE$);
        } else if ("complete".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeComplete$.MODULE$);
        } else if ("update".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$OutputModeTypeUpdate$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, "invalid state please raise issue.");
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, API.FailModeType> parseFailMode(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("permissive".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$FailModeTypePermissive$.MODULE$);
        } else if ("failfast".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)API$FailModeTypeFailFast$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, "invalid state please raise issue.");
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, Delimiter> parseDelimiter(String path, String delim, Config c) {
        Right right;
        String string = delim.toLowerCase().trim();
        if ("comma".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Comma$.MODULE$);
        } else if ("defaulthive".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$DefaultHive$.MODULE$);
        } else if ("pipe".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Pipe$.MODULE$);
        } else if ("custom".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)Delimiter$Custom$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, "invalid state please raise issue.");
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, QuoteCharacter> parseQuote(String path, String quote, Config c) {
        Right right;
        String string = quote.toLowerCase().trim();
        if ("doublequote".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$DoubleQuote$.MODULE$);
        } else if ("singlequote".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$SingleQuote$.MODULE$);
        } else if ("none".equals(string)) {
            right = package$.MODULE$.Right().apply((Object)QuoteCharacter$Disabled$.MODULE$);
        } else {
            Error.ConfigError configError = new Error.ConfigError(path, (Option<Object>)None$.MODULE$, "invalid state please raise issue.");
            right = package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        return right;
    }

    public Either<List<Error.ConfigError>, Driver> getJDBCDriver(String path, String uri, Config c) {
        Right right;
        List drivers = (List)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)driver -> driver.getClass().getName(), List$.MODULE$.canBuildFrom());
        try {
            right = package$.MODULE$.Right().apply((Object)DriverManager.getDriver(uri));
        }
        catch (Exception e) {
            right = ConfigUtils$.err$6((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), new StringBuilder(50).append("Invalid driver for ('").append(uri).append("'). Available JDBC drivers: ").append(drivers.mkString("[", ", ", "]")).append(".").toString(), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, String> injectSQLParams(String path, Map<String, String> sqlParams, boolean allowMissing, String sql, SparkSession spark, Logger logger, Config c) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)SQLUtils$.MODULE$.injectParameters(sql, sqlParams, allowMissing, logger));
        }
        catch (Exception e) {
            right = ConfigUtils$.err$7((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), e.getMessage(), path);
        }
        return right;
    }

    public Either<List<Error.ConfigError>, String> validateSQL(String path, String sql, SparkSession spark, Config c) {
        Right right;
        try {
            ParserInterface parser = spark.sessionState().sqlParser();
            parser.parsePlan(sql);
            right = package$.MODULE$.Right().apply((Object)sql);
        }
        catch (Exception e) {
            right = ConfigUtils$.err$8((Option)new Some((Object)BoxesRunTime.boxToInteger((int)c.getValue(path).origin().lineNumber())), e.getMessage(), path);
        }
        return right;
    }

    public static final /* synthetic */ boolean $anonfun$readIPYNB$1(JsonNode cell) {
        String string = cell.get("cell_type").asText();
        String string2 = "code";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$readIPYNB$9(String cell) {
        return !cell.startsWith("%") && cell.length() > 0 || cell.startsWith("%arc");
    }

    public static final /* synthetic */ boolean $anonfun$levenshteinDistance$2(int limit$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int v = tuple2._2$mcI$sp();
        boolean bl = v < limit$1;
        return bl;
    }

    private static final Either err$1(Option lineNumber, String msg, String path$1) {
        Error.ConfigError configError = new Error.ConfigError(path$1, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private static final Either err$2(Option lineNumber, String msg, String path$2) {
        Error.ConfigError configError = new Error.ConfigError(path$2, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    public static final /* synthetic */ Option $anonfun$readAuthentication$1(String x$7) {
        return API$AmazonS3EncryptionType$.MODULE$.fromString(x$7);
    }

    public static final /* synthetic */ String $anonfun$readAuthentication$2() {
        return "";
    }

    private static final Either err$3(Option lineNumber, String msg, String path$3) {
        Error.ConfigError configError = new Error.ConfigError(path$3, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private static final Either err$4(Option lineNumber, String msg, String path$4) {
        Error.ConfigError configError = new Error.ConfigError(path$4, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private static final Either err$5(Option lineNumber, String msg, String path$5) {
        Error.ConfigError configError = new Error.ConfigError(path$5, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private static final Either err$6(Option lineNumber, String msg, String path$6) {
        Error.ConfigError configError = new Error.ConfigError(path$6, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private static final Either err$7(Option lineNumber, String msg, String path$7) {
        Error.ConfigError configError = new Error.ConfigError(path$7, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private static final Either err$8(Option lineNumber, String msg, String path$8) {
        Error.ConfigError configError = new Error.ConfigError(path$8, (Option<Object>)lineNumber, msg);
        return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
    }

    private ConfigUtils$() {
        MODULE$ = this;
    }
}

