/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.AvroExtract;
import ai.tripl.arc.extract.AvroExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.package$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple15;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class AvroExtractStage$
implements scala.Serializable {
    public static AvroExtractStage$ MODULE$;

    static {
        new AvroExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(AvroExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Dataset dataset4;
        Option<StructType> option;
        try {
            option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Option<StructType> optionSchema = option;
        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
        try {
            Dataset dataset5;
            Either<String, String> either = stage.input();
            if (either instanceof Right) {
                Dataset dataset6;
                Right right = (Right)either;
                String glob = (String)right.value();
                Option<String> option2 = stage.basePath();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    String basePath = (String)some.value();
                    dataset6 = spark.read().format("avro").option("basePath", basePath).load(glob);
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    dataset6 = spark.read().format("avro").load(glob);
                }
                dataset5 = dataset6;
            } else {
                Dataset dataset7;
                if (!(either instanceof Left)) throw new MatchError(either);
                Left left = (Left)either;
                String view = (String)left.value();
                Dataset inputView = spark.table(view);
                Option<Schema> option3 = stage.avroSchema();
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    Schema avroSchema = (Schema)some.value();
                    Option<String> option4 = stage.inputField();
                    if (option4 instanceof Some) {
                        Some some2 = (Some)option4;
                        String inputField = (String)some2.value();
                        dataset7 = inputView.withColumn(inputField, package$.MODULE$.from_avro(functions$.MODULE$.col(inputField), avroSchema.toString()));
                    } else {
                        if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                        dataset7 = inputView.withColumn("value", package$.MODULE$.from_avro(functions$.MODULE$.col("value"), avroSchema.toString()));
                    }
                } else {
                    if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                    throw new Exception("AvroExtract requires the 'avroSchema' to be provided when reading from an 'inputView'.");
                }
                Dataset dataset8 = dataset7;
                dataset5 = dataset8;
            }
            dataset4 = dataset5;
        }
        catch (Throwable throwable) {
            AnalysisException analysisException;
            Dataset dataset9;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException) {
                dataset9 = spark.emptyDataFrame();
            } else if (throwable2 instanceof AnalysisException && (analysisException = (AnalysisException)throwable2).getMessage().contains("Path does not exist")) {
                dataset9 = spark.emptyDataFrame();
            } else {
                if (!(throwable2 instanceof Exception)) throw throwable;
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            dataset4 = dataset9;
        }
        Dataset df = dataset4;
        try {
            if (df.schema().length() == 0) {
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option5 = optionSchema;
                if (!(option5 instanceof Some)) {
                    if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                    throw new Exception("AvroExtract has produced 0 columns and no schema has been provided to create an empty dataframe.");
                }
                Some some = (Some)option5;
                StructType s = (StructType)some.value();
                Dataset dataset10 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset3 = dataset10;
            } else {
                dataset3 = df;
            }
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), arcContext);
        Option<StructType> option6 = optionSchema;
        if (option6 instanceof Some) {
            Some some = (Some)option6;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema);
        } else {
            if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset11;
            Option<Object> option7 = stage.numPartitions();
            if (option7 instanceof Some) {
                Some some = (Some)option7;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset11 = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
                dataset11 = enrichedDF;
            }
            dataset = dataset11;
        } else {
            Dataset dataset12;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> df.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option8 = stage.numPartitions();
            if (option8 instanceof Some) {
                Some some = (Some)option8;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset12 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option8)) throw new MatchError(option8);
                dataset12 = enrichedDF.repartition((Seq)partitionCols);
            }
            dataset = dataset12;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public AvroExtractStage apply(AvroExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> basePath, Option<Schema> avroSchema, Option<String> inputField) {
        return new AvroExtractStage(plugin, name, description, schema, outputView, input, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, basePath, avroSchema, inputField);
    }

    public Option<Tuple15<AvroExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<Schema>, Option<String>>> unapply(AvroExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.basePath(), x$0.avroSchema(), x$0.inputField()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AvroExtractStage$() {
        MODULE$ = this;
    }
}

