/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.JSON;
import ai.tripl.arc.api.JSON$;
import ai.tripl.arc.extract.JSONExtract;
import ai.tripl.arc.extract.JSONExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple16;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JSONExtractStage$
implements scala.Serializable {
    public static JSONExtractStage$ MODULE$;

    static {
        new JSONExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(JSONExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Dataset dataset4;
        Option<StructType> optionSchema;
        block50: {
            scala.collection.immutable.Map map;
            Option<StructType> option;
            try {
                option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final scala.collection.mutable.Map<String, Object> detail;

                    public scala.collection.mutable.Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            optionSchema = option;
            Option<String> option2 = stage.basePath();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String basePath = (String)some.value();
                map = JSON$.MODULE$.toSparkOptions(stage.settings()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)basePath));
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                map = JSON$.MODULE$.toSparkOptions(stage.settings());
            }
            scala.collection.immutable.Map options = map;
            try {
                Dataset dataset5;
                if (arcContext.isStreaming()) {
                    Dataset dataset6;
                    Either<String, String> either = stage.input();
                    if (either instanceof Right) {
                        Dataset dataset7;
                        Right right = (Right)either;
                        String glob = (String)right.value();
                        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                        Option<StructType> option3 = optionSchema;
                        if (option3 instanceof Some) {
                            Some some = (Some)option3;
                            StructType schema = (StructType)some.value();
                            Option<API.Watermark> option4 = stage.watermark();
                            if (option4 instanceof Some) {
                                Some some2 = (Some)option4;
                                API.Watermark watermark = (API.Watermark)some2.value();
                                dataset7 = spark.readStream().options((Map)options).schema(schema).json(glob).withWatermark(watermark.eventTime(), watermark.delayThreshold());
                            } else {
                                if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                                dataset7 = spark.readStream().options((Map)options).schema(schema).json(glob);
                            }
                        } else {
                            if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                            throw new Exception("JSONExtract requires 'schemaURI' or 'schemaView' to be set if Arc is running in streaming mode.");
                        }
                        Dataset dataset8 = dataset7;
                        dataset6 = dataset8;
                    } else {
                        Dataset dataset9;
                        if (!(either instanceof Left)) throw new MatchError(either);
                        Left left = (Left)either;
                        String view = (String)left.value();
                        Dataset inputView = spark.table(view);
                        if (inputView.isStreaming()) {
                            throw new Exception("JSONExtract does not support the use of 'inputView' if Arc is running in streaming mode.");
                        }
                        Option<String> option5 = stage.inputField();
                        if (option5 instanceof Some) {
                            Some some = (Some)option5;
                            String inputField = (String)some.value();
                            dataset9 = spark.read().options((Map)options).json(inputView.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputField).as("value")})).as(spark.implicits().newStringEncoder()));
                        } else {
                            if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                            dataset9 = spark.read().options((Map)options).json(inputView.as(spark.implicits().newStringEncoder()));
                        }
                        dataset6 = dataset9;
                    }
                    dataset4 = dataset6;
                    break block50;
                }
                Either<String, String> either = stage.input();
                if (either instanceof Right) {
                    Dataset dataset10;
                    Right right = (Right)either;
                    String glob = (String)right.value();
                    CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                    try {
                        if (stage.settings().multiLine()) {
                            Dataset dataset11;
                            String oldDelimiter = spark.sparkContext().hadoopConfiguration().get("textinputformat.record.delimiter");
                            String newDelimiter = String.valueOf(BoxesRunTime.boxToCharacter((char)'\u0000'));
                            spark.sparkContext().hadoopConfiguration().set("textinputformat.record.delimiter", newDelimiter);
                            RDD textFile = spark.sparkContext().textFile(glob, spark.sparkContext().textFile$default$2());
                            Option<StructType> option6 = optionSchema;
                            if (option6 instanceof Some) {
                                Some some = (Some)option6;
                                StructType schema = (StructType)some.value();
                                dataset11 = spark.read().options((Map)options).schema(schema).json(spark.implicits().rddToDatasetHolder(textFile, spark.implicits().newStringEncoder()).toDS());
                            } else {
                                if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                                dataset11 = spark.read().options((Map)options).json(spark.implicits().rddToDatasetHolder(textFile, spark.implicits().newStringEncoder()).toDS());
                            }
                            Dataset json = dataset11;
                            if (oldDelimiter == null) {
                                spark.sparkContext().hadoopConfiguration().unset("textinputformat.record.delimiter");
                            } else {
                                spark.sparkContext().hadoopConfiguration().set("textinputformat.record.delimiter", oldDelimiter);
                            }
                            dataset10 = json;
                        } else {
                            Dataset json;
                            Dataset dataset12;
                            RDD textFile = spark.sparkContext().textFile(glob, spark.sparkContext().textFile$default$2());
                            Option<StructType> option7 = optionSchema;
                            if (option7 instanceof Some) {
                                Some some = (Some)option7;
                                StructType schema = (StructType)some.value();
                                dataset12 = spark.read().options((Map)options).schema(schema).json(spark.implicits().rddToDatasetHolder(textFile, spark.implicits().newStringEncoder()).toDS());
                            } else {
                                if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
                                dataset12 = spark.read().options((Map)options).json(spark.implicits().rddToDatasetHolder(textFile, spark.implicits().newStringEncoder()).toDS());
                            }
                            dataset10 = json = dataset12;
                        }
                    }
                    catch (InvalidInputException e) {
                        dataset10 = spark.emptyDataFrame();
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    dataset5 = dataset10;
                } else {
                    Dataset dataset13;
                    if (!(either instanceof Left)) throw new MatchError(either);
                    Left left = (Left)either;
                    String view = (String)left.value();
                    Option<String> option8 = stage.inputField();
                    if (option8 instanceof Some) {
                        Some some = (Some)option8;
                        String inputField = (String)some.value();
                        dataset13 = spark.read().options((Map)options).json(spark.table(view).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputField).as("value")})).as(spark.implicits().newStringEncoder()));
                    } else {
                        if (!None$.MODULE$.equals(option8)) throw new MatchError(option8);
                        dataset13 = spark.read().options((Map)options).json(spark.table(view).as(spark.implicits().newStringEncoder()));
                    }
                    dataset5 = dataset13;
                }
                dataset4 = dataset5;
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final scala.collection.mutable.Map<String, Object> detail;

                    public scala.collection.mutable.Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        Dataset df = dataset4;
        try {
            if (df.schema().length() == 0) {
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option = optionSchema;
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new Exception("JSONExtract has produced 0 columns and no schema has been provided to create an empty dataframe.");
                }
                Some some = (Some)option;
                StructType s = (StructType)some.value();
                Dataset dataset14 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset3 = dataset14;
            } else {
                dataset3 = df;
            }
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final scala.collection.mutable.Map<String, Object> detail;

                public scala.collection.mutable.Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), arcContext);
        Option<StructType> option = optionSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset15;
            Option<Object> option9 = stage.numPartitions();
            if (option9 instanceof Some) {
                Some some = (Some)option9;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset15 = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option9)) throw new MatchError(option9);
                dataset15 = enrichedDF;
            }
            dataset = dataset15;
        } else {
            Dataset dataset16;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> df.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option10 = stage.numPartitions();
            if (option10 instanceof Some) {
                Some some = (Some)option10;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset16 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option10)) throw new MatchError(option10);
                dataset16 = enrichedDF.repartition((Seq)partitionCols);
            }
            dataset = dataset16;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public JSONExtractStage apply(JSONExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, JSON settings, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> inputField, Option<String> basePath, Option<API.Watermark> watermark) {
        return new JSONExtractStage(plugin, name, description, schema, outputView, input, settings, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, inputField, basePath, watermark);
    }

    public Option<Tuple16<JSONExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, JSON, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<String>, Option<API.Watermark>>> unapply(JSONExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple16((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), (Object)x$0.settings(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.inputField(), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private JSONExtractStage$() {
        MODULE$ = this;
    }
}

