/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.XMLExtract;
import ai.tripl.arc.extract.XMLExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.databricks.spark.xml.XmlReader;
import java.io.Serializable;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class XMLExtractStage$
implements scala.Serializable {
    public static XMLExtractStage$ MODULE$;

    static {
        new XMLExtractStage$();
    }

    public Option<Dataset<Row>> execute(XMLExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Dataset dataset4;
        Dataset dataset5;
        Option<StructType> option;
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
        try {
            option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Option<StructType> optionSchema = option;
        try {
            Dataset dataset6;
            Either<String, String> either = stage.input();
            if (either instanceof Right) {
                Right right = (Right)either;
                String glob = (String)right.value();
                CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                String oldDelimiter = spark.sparkContext().hadoopConfiguration().get("textinputformat.record.delimiter");
                String newDelimiter = String.valueOf(BoxesRunTime.boxToCharacter((char)'\u0000'));
                spark.sparkContext().hadoopConfiguration().set("textinputformat.record.delimiter", newDelimiter);
                RDD textFile = spark.sparkContext().textFile(glob, spark.sparkContext().textFile$default$2());
                XmlReader xmlReader = new XmlReader();
                Dataset xml = xmlReader.xmlRdd(spark, textFile);
                if (oldDelimiter == null) {
                    spark.sparkContext().hadoopConfiguration().unset("textinputformat.record.delimiter");
                } else {
                    spark.sparkContext().hadoopConfiguration().set("textinputformat.record.delimiter", oldDelimiter);
                }
                dataset6 = xml;
            } else if (either instanceof Left) {
                Left left = (Left)either;
                String view = (String)left.value();
                XmlReader xmlReader = new XmlReader();
                dataset6 = xmlReader.xmlRdd(spark, spark.table(view).as(spark.implicits().newStringEncoder()).rdd());
            } else {
                throw new MatchError(either);
            }
            dataset5 = dataset6;
        }
        catch (Throwable throwable) {
            InvalidInputException invalidInputException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof InvalidInputException) || !(invalidInputException = (InvalidInputException)throwable2).getMessage().contains("matches 0 files")) {
                if (throwable2 instanceof Exception) {
                    Exception exception = (Exception)throwable2;
                    throw new DetailException(exception, stage){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$1.stageDetail();
                        }
                    };
                }
                throw throwable;
            }
            Dataset dataset7 = spark.emptyDataFrame();
            dataset5 = dataset7;
        }
        Dataset df = dataset5;
        try {
            if (df.schema().length() == 0) {
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option2 = optionSchema;
                if (!(option2 instanceof Some)) {
                    if (None$.MODULE$.equals(option2)) {
                        throw new Exception("XMLExtract has produced 0 columns and no schema has been provided to create an empty dataframe.");
                    }
                    throw new MatchError(option2);
                }
                Some some = (Some)option2;
                StructType s = (StructType)some.value();
                Dataset dataset8 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset4 = dataset8;
            } else {
                dataset4 = df;
            }
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset4;
        if (emptyDataframeHandlerDF.schema().length() == 1) {
            String string = emptyDataframeHandlerDF.schema().fields()[0].dataType().typeName();
            Dataset dataset9 = "array".equals(string) ? emptyDataframeHandlerDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col(emptyDataframeHandlerDF.schema().fieldNames()[0]))})).select("col.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])) : ("struct".equals(string) ? emptyDataframeHandlerDF.select(new StringBuilder(2).append(emptyDataframeHandlerDF.schema().fieldNames()[0]).append(".*").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])) : emptyDataframeHandlerDF);
            dataset3 = dataset9;
        } else {
            dataset3 = emptyDataframeHandlerDF;
        }
        Dataset flattenedDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)flattenedDF, stage.contiguousIndex(), arcContext);
        Option<StructType> option3 = optionSchema;
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema);
        } else if (None$.MODULE$.equals(option3)) {
            dataset2 = sourceEnrichedDF;
        } else {
            throw new MatchError(option3);
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset10;
            Option<Object> option4 = stage.numPartitions();
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset10 = enrichedDF.repartition(numPartitions);
            } else if (None$.MODULE$.equals(option4)) {
                dataset10 = enrichedDF;
            } else {
                throw new MatchError(option4);
            }
            dataset = dataset10;
        } else {
            Dataset dataset11;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> df.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option5 = stage.numPartitions();
            if (option5 instanceof Some) {
                Some some = (Some)option5;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset11 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else if (None$.MODULE$.equals(option5)) {
                dataset11 = enrichedDF.repartition((Seq)partitionCols);
            } else {
                throw new MatchError(option5);
            }
            dataset = dataset11;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public XMLExtractStage apply(XMLExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex) {
        return new XMLExtractStage(plugin, name, description, schema, outputView, input, authentication, params, persist, numPartitions, partitionBy, contiguousIndex);
    }

    public Option<Tuple12<XMLExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object>> unapply(XMLExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private XMLExtractStage$() {
        MODULE$ = this;
    }
}

