/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.load;

import ai.tripl.arc.api.API;
import ai.tripl.arc.load.TextLoad;
import ai.tripl.arc.load.TextLoadStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple13;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TextLoadStage$
implements scala.Serializable {
    public static TextLoadStage$ MODULE$;

    static {
        new TextLoadStage$();
    }

    public Option<Dataset<Row>> execute(TextLoadStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset df;
        block27: {
            block29: {
                block28: {
                    BoxedUnit boxedUnit;
                    df = spark.table(stage.inputView());
                    if (!df.isStreaming()) {
                        Option option;
                        Option<Object> option2 = stage.numPartitions();
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            int partitions = BoxesRunTime.unboxToInt((Object)some.value());
                            option = stage.stageDetail().put((Object)"numPartitions", (Object)partitions);
                        } else if (None$.MODULE$.equals(option2)) {
                            option = stage.stageDetail().put((Object)"numPartitions", (Object)df.rdd().getNumPartitions());
                        } else {
                            throw new MatchError(option2);
                        }
                        boxedUnit = option;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    if (df.schema().length() != 1) break block28;
                    DataType dataType = df.schema().fields()[0].dataType();
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType == null ? stringType$ != null : !dataType.equals(stringType$))) break block29;
                }
                throw new DetailException(df, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$1.stageDetail();
                    }
                };
            }
            CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
            try {
                if (stage.singleFile()) {
                    Option outputStream;
                    Option option;
                    Path path;
                    FileSystem fs = FileSystem.get((Configuration)spark.sparkContext().hadoopConfiguration());
                    if (fs.exists(path = new Path(stage.outputURI()))) {
                        None$ none$;
                        SaveMode saveMode = stage.saveMode();
                        if (SaveMode.ErrorIfExists.equals(saveMode)) {
                            throw new Exception(new StringBuilder(80).append("File '").append(path).append("' already exists and 'saveMode' equals 'ErrorIfExists' so cannot continue.").toString());
                        }
                        if (SaveMode.Ignore.equals(saveMode)) {
                            none$ = None$.MODULE$;
                        } else if (SaveMode.Overwrite.equals(saveMode)) {
                            none$ = Option$.MODULE$.apply((Object)fs.create(path, true));
                        } else {
                            if (SaveMode.Append.equals(saveMode)) {
                                throw new Exception(new StringBuilder(100).append("File '").append(path).append("' already exists and 'saveMode' equals 'Append' which is not supported with 'singleFile' mode.").toString());
                            }
                            throw new MatchError((Object)saveMode);
                        }
                        option = none$;
                    } else {
                        option = Option$.MODULE$.apply((Object)fs.create(path));
                    }
                    Option option3 = outputStream = option;
                    if (option3 instanceof Some) {
                        Some some = (Some)option3;
                        FSDataOutputStream os = (FSDataOutputStream)some.value();
                        os.writeBytes(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(stage.prefix(), stage.separator(), stage.suffix()));
                        os.close();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option3)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option3);
                    }
                    fs.close();
                    break block27;
                }
                Option<Object> option = stage.numPartitions();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n = BoxesRunTime.unboxToInt((Object)some.value());
                    df.repartition(n).write().mode(stage.saveMode()).text(stage.outputURI().toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block27;
                }
                if (None$.MODULE$.equals(option)) {
                    df.write().mode(stage.saveMode()).text(stage.outputURI().toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block27;
                }
                throw new MatchError(option);
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$1.stageDetail();
                    }
                };
            }
        }
        return Option$.MODULE$.apply((Object)df);
    }

    public TextLoadStage apply(TextLoad plugin, String name, Option<String> description, String inputView, URI outputURI, Option<Object> numPartitions, Option<API.Authentication> authentication, SaveMode saveMode, scala.collection.immutable.Map<String, String> params, boolean singleFile, String prefix, String separator, String suffix) {
        return new TextLoadStage(plugin, name, description, inputView, outputURI, numPartitions, authentication, saveMode, params, singleFile, prefix, separator, suffix);
    }

    public Option<Tuple13<TextLoad, String, Option<String>, String, URI, Option<Object>, Option<API.Authentication>, SaveMode, scala.collection.immutable.Map<String, String>, Object, String, String, String>> unapply(TextLoadStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple13((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.outputURI(), x$0.numPartitions(), x$0.authentication(), (Object)x$0.saveMode(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.singleFile()), (Object)x$0.prefix(), (Object)x$0.separator(), (Object)x$0.suffix()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TextLoadStage$() {
        MODULE$ = this;
    }
}

