/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.transform;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.API$FailModeTypeFailFast$;
import ai.tripl.arc.api.API$FailModeTypePermissive$;
import ai.tripl.arc.transform.MetadataTransform;
import ai.tripl.arc.transform.MetadataTransformStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class MetadataTransformStage$
implements scala.Serializable {
    public static MetadataTransformStage$ MODULE$;

    static {
        new MetadataTransformStage$();
    }

    public Option<Dataset<Row>> execute(MetadataTransformStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        StructType structType;
        Dataset df = spark.table(stage.inputView());
        try {
            structType = (StructType)ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger).get();
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        StructType schema = structType;
        try {
            API.FailModeType failModeType = stage.failMode();
            if (API$FailModeTypeFailFast$.MODULE$.equals(failModeType)) {
                Set inputFields;
                Set schemaFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
                if (schemaFields.diff((GenSet)(inputFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).toSet())).size() != 0 || inputFields.diff((GenSet)schemaFields).size() != 0) {
                    Either<String, List<API.ExtractColumn>> either = stage.schema();
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        String schemaView = (String)left.value();
                        throw new Exception(new StringBuilder(171).append("MetadataTransform with failMode = 'failfast' ensures that the schemaView '").append(schemaView).append("' has the same columns as inputView '").append(stage.inputView()).append("' but schemaView '").append(schemaView).append("' has columns: ").append(((TraversableOnce)schemaFields.map((Function1 & Serializable & scala.Serializable)fieldName -> new StringBuilder(2).append("'").append((String)fieldName).append("'").toString(), Set$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).append(" and '").append(stage.inputView()).append("' contains columns: ").append(((TraversableOnce)inputFields.map((Function1 & Serializable & scala.Serializable)fieldName -> new StringBuilder(2).append("'").append((String)fieldName).append("'").toString(), Set$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).append(".").toString());
                    }
                    if (either instanceof Right) {
                        Option<String> option = stage.schemaURI();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String schemaURI = (String)some.value();
                            throw new Exception(new StringBuilder(197).append("MetadataTransform with failMode = 'failfast' ensures that the schema supplied in schemaURI '").append(schemaURI).append("' has the same columns as inputView '").append(stage.inputView()).append("' but schema supplied in '").append(schemaURI).append("' has columns: ").append(((TraversableOnce)schemaFields.map((Function1 & Serializable & scala.Serializable)fieldName -> new StringBuilder(2).append("'").append((String)fieldName).append("'").toString(), Set$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).append(" and '").append(stage.inputView()).append("' contains columns: ").append(((TraversableOnce)inputFields.map((Function1 & Serializable & scala.Serializable)fieldName -> new StringBuilder(2).append("'").append((String)fieldName).append("'").toString(), Set$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).append(".").toString());
                        }
                        if (None$.MODULE$.equals(option)) {
                            throw new Exception("Invalid state. Please raise issue.");
                        }
                        throw new MatchError(option);
                    }
                    throw new MatchError(either);
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else if (API$FailModeTypePermissive$.MODULE$.equals(failModeType)) {
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)failModeType);
            }
            dataset2 = MetadataUtils$.MODULE$.setMetadata((Dataset<Row>)df, schema);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset3;
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset3 = enrichedDF.repartition(numPartitions);
            } else if (None$.MODULE$.equals(option)) {
                dataset3 = enrichedDF;
            } else {
                throw new MatchError(option);
            }
            dataset = dataset3;
        } else {
            Dataset dataset4;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> enrichedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset4 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else if (None$.MODULE$.equals(option)) {
                dataset4 = enrichedDF.repartition((Seq)partitionCols);
            } else {
                throw new MatchError(option);
            }
            dataset = dataset4;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public MetadataTransformStage apply(MetadataTransform plugin, String name, Option<String> description, String inputView, String outputView, Option<String> schemaURI, Either<String, List<API.ExtractColumn>> schema, API.FailModeType failMode, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy) {
        return new MetadataTransformStage(plugin, name, description, inputView, outputView, schemaURI, schema, failMode, params, persist, numPartitions, partitionBy);
    }

    public Option<Tuple12<MetadataTransform, String, Option<String>, String, String, Option<String>, Either<String, List<API.ExtractColumn>>, API.FailModeType, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>>> unapply(MetadataTransformStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.outputView(), x$0.schemaURI(), x$0.schema(), (Object)x$0.failMode(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MetadataTransformStage$() {
        MODULE$ = this;
    }
}

