/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.MetadataExtract;
import ai.tripl.arc.extract.MetadataExtractStage;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MetadataExtractStage$
implements scala.Serializable {
    public static MetadataExtractStage$ MODULE$;

    static {
        new MetadataExtractStage$();
    }

    public Option<Dataset<Row>> execute(MetadataExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset df = spark.table(stage.inputView());
        Dataset metadataSchemaDF = MetadataUtils$.MODULE$.createMetadataDataframe((Dataset<Row>)df, spark, logger);
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset2;
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset2 = metadataSchemaDF.repartition(numPartitions);
            } else if (None$.MODULE$.equals(option)) {
                dataset2 = metadataSchemaDF;
            } else {
                throw new MatchError(option);
            }
            dataset = dataset2;
        } else {
            Dataset dataset3;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> metadataSchemaDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset3 = metadataSchemaDF.repartition(numPartitions, (Seq)partitionCols);
            } else if (None$.MODULE$.equals(option)) {
                dataset3 = metadataSchemaDF.repartition((Seq)partitionCols);
            } else {
                throw new MatchError(option);
            }
            dataset = dataset3;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public MetadataExtractStage apply(MetadataExtract plugin, String name, Option<String> description, String inputView, String outputView, Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy) {
        return new MetadataExtractStage(plugin, name, description, inputView, outputView, params, persist, numPartitions, partitionBy);
    }

    public Option<Tuple9<MetadataExtract, String, Option<String>, String, String, Map<String, String>, Object, Option<Object>, List<String>>> unapply(MetadataExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.outputView(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MetadataExtractStage$() {
        MODULE$ = this;
    }
}

