/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.JSON;
import ai.tripl.arc.api.JSON$;
import ai.tripl.arc.extract.JSONExtract;
import ai.tripl.arc.extract.JSONExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple16;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JSONExtractStage$
implements scala.Serializable {
    public static JSONExtractStage$ MODULE$;

    static {
        new JSONExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(JSONExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Right right;
        Option<StructType> optionSchema;
        block54: {
            scala.collection.immutable.Map map;
            Option<StructType> option;
            try {
                option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final scala.collection.mutable.Map<String, Object> detail;

                    public scala.collection.mutable.Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            optionSchema = option;
            Option<String> option2 = stage.basePath();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String basePath = (String)some.value();
                map = JSON$.MODULE$.toSparkOptions(stage.settings()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)basePath));
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                map = JSON$.MODULE$.toSparkOptions(stage.settings());
            }
            scala.collection.immutable.Map options = map;
            try {
                Right right2;
                if (arcContext.isStreaming()) {
                    Right right3;
                    Either<String, String> either = stage.input();
                    if (either instanceof Right) {
                        Right right4;
                        Right right5 = (Right)either;
                        String glob = (String)right5.value();
                        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                        Option<StructType> option3 = optionSchema;
                        if (option3 instanceof Some) {
                            Some some = (Some)option3;
                            StructType schema = (StructType)some.value();
                            Option<API.Watermark> option4 = stage.watermark();
                            if (option4 instanceof Some) {
                                Some some2 = (Some)option4;
                                API.Watermark watermark = (API.Watermark)some2.value();
                                right4 = package$.MODULE$.Right().apply((Object)spark.readStream().options((Map)options).schema(schema).json(glob).withWatermark(watermark.eventTime(), watermark.delayThreshold()));
                            } else {
                                if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                                right4 = package$.MODULE$.Right().apply((Object)spark.readStream().options((Map)options).schema(schema).json(glob));
                            }
                        } else {
                            if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                            throw new Exception("JSONExtract requires 'schemaURI' or 'schemaView' to be set if Arc is running in streaming mode.");
                        }
                        Right right6 = right4;
                        right3 = right6;
                    } else {
                        Right right7;
                        if (!(either instanceof Left)) throw new MatchError(either);
                        Left left = (Left)either;
                        String view = (String)left.value();
                        Dataset inputView = spark.table(view);
                        if (inputView.isStreaming()) {
                            throw new Exception("JSONExtract does not support the use of 'inputView' if Arc is running in streaming mode.");
                        }
                        Option<String> option5 = stage.inputField();
                        if (option5 instanceof Some) {
                            Some some = (Some)option5;
                            String inputField = (String)some.value();
                            right7 = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).json(inputView.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputField).as("value")})).as(spark.implicits().newStringEncoder())));
                        } else {
                            if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                            right7 = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).json(inputView.as(spark.implicits().newStringEncoder())));
                        }
                        right3 = right7;
                    }
                    right = right3;
                    break block54;
                }
                Either<String, String> either = stage.input();
                if (either instanceof Right) {
                    Left left;
                    Right right8 = (Right)either;
                    String glob = (String)right8.value();
                    CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                    try {
                        if (stage.settings().multiLine()) {
                            Right right9;
                            String oldDelimiter = spark.sparkContext().hadoopConfiguration().get("textinputformat.record.delimiter");
                            String newDelimiter = String.valueOf(BoxesRunTime.boxToCharacter((char)'\u0000'));
                            spark.sparkContext().hadoopConfiguration().set("textinputformat.record.delimiter", newDelimiter);
                            RDD textFile = spark.sparkContext().textFile(glob, spark.sparkContext().textFile$default$2());
                            Option<StructType> option6 = optionSchema;
                            if (option6 instanceof Some) {
                                Some some = (Some)option6;
                                StructType schema = (StructType)some.value();
                                right9 = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).schema(schema).json(spark.implicits().rddToDatasetHolder(textFile, spark.implicits().newStringEncoder()).toDS()));
                            } else {
                                if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                                right9 = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).json(spark.implicits().rddToDatasetHolder(textFile, spark.implicits().newStringEncoder()).toDS()));
                            }
                            Right json = right9;
                            if (oldDelimiter == null) {
                                spark.sparkContext().hadoopConfiguration().unset("textinputformat.record.delimiter");
                            } else {
                                spark.sparkContext().hadoopConfiguration().set("textinputformat.record.delimiter", oldDelimiter);
                            }
                            left = json;
                        } else {
                            Right right10;
                            RDD textFile = spark.sparkContext().textFile(glob, spark.sparkContext().textFile$default$2());
                            Option<StructType> option7 = optionSchema;
                            if (option7 instanceof Some) {
                                Some some = (Some)option7;
                                StructType schema = (StructType)some.value();
                                right10 = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).schema(schema).json(spark.implicits().rddToDatasetHolder(textFile, spark.implicits().newStringEncoder()).toDS()));
                            } else {
                                if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
                                right10 = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).json(spark.implicits().rddToDatasetHolder(textFile, spark.implicits().newStringEncoder()).toDS()));
                            }
                            Right json = right10;
                            left = json;
                        }
                    }
                    catch (Throwable throwable) {
                        InvalidInputException invalidInputException;
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof InvalidInputException) || !(invalidInputException = (InvalidInputException)throwable2).getMessage().contains("matches 0 files")) {
                            if (!(throwable2 instanceof Exception)) throw throwable;
                            Exception exception = (Exception)throwable2;
                            throw exception;
                        }
                        Left left2 = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)Option$.MODULE$.apply((Object)glob)));
                        left = left2;
                    }
                    right2 = left;
                } else {
                    Right right11;
                    if (!(either instanceof Left)) throw new MatchError(either);
                    Left left = (Left)either;
                    String view = (String)left.value();
                    Option<String> option8 = stage.inputField();
                    if (option8 instanceof Some) {
                        Some some = (Some)option8;
                        String inputField = (String)some.value();
                        right11 = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).json(spark.table(view).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputField).as("value")})).as(spark.implicits().newStringEncoder())));
                    } else {
                        if (!None$.MODULE$.equals(option8)) throw new MatchError(option8);
                        right11 = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).json(spark.table(view).as(spark.implicits().newStringEncoder())));
                    }
                    right2 = right11;
                }
                right = right2;
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final scala.collection.mutable.Map<String, Object> detail;

                    public scala.collection.mutable.Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        Right df = right;
        try {
            Dataset dataset4;
            Right right12 = df;
            if (right12 instanceof Right) {
                Dataset dataset5;
                Right right13 = right12;
                Dataset df2 = (Dataset)right13.value();
                if (df2.schema().length() == 0) {
                    Option<StructType> option = optionSchema;
                    if (!(option instanceof Some)) {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        Either<String, String> either = stage.input();
                        if (either instanceof Right) {
                            Right right14 = (Right)either;
                            String glob = (String)right14.value();
                            throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)glob)).getMessage());
                        }
                        if (!(either instanceof Left)) throw new MatchError(either);
                        throw new Exception(new API.EmptySchemaExtractError((Option<String>)None$.MODULE$).getMessage());
                    }
                    Some some = (Some)option;
                    StructType structType = (StructType)some.value();
                    Dataset dataset6 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                    dataset5 = dataset6;
                } else {
                    dataset5 = df2;
                }
                dataset4 = dataset5;
            } else {
                if (!(right12 instanceof Left)) throw new MatchError((Object)right12);
                Left left = (Left)right12;
                API.FileNotFoundExtractError error = (API.FileNotFoundExtractError)left.value();
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option = optionSchema;
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new Exception(error.getMessage());
                }
                Some some = (Some)option;
                StructType s = (StructType)some.value();
                Dataset dataset7 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset4 = dataset7;
            }
            dataset3 = dataset4;
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final scala.collection.mutable.Map<String, Object> detail;

                public scala.collection.mutable.Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), arcContext);
        Option<StructType> option = optionSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset8;
            Option<Object> option9 = stage.numPartitions();
            if (option9 instanceof Some) {
                Some some = (Some)option9;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset8 = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option9)) throw new MatchError(option9);
                dataset8 = enrichedDF;
            }
            dataset = dataset8;
        } else {
            Dataset dataset9;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> enrichedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option10 = stage.numPartitions();
            if (option10 instanceof Some) {
                Some some = (Some)option10;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset9 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option10)) throw new MatchError(option10);
                dataset9 = enrichedDF.repartition((Seq)partitionCols);
            }
            dataset = dataset9;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public JSONExtractStage apply(JSONExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, JSON settings, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> inputField, Option<String> basePath, Option<API.Watermark> watermark) {
        return new JSONExtractStage(plugin, name, description, schema, outputView, input, settings, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, inputField, basePath, watermark);
    }

    public Option<Tuple16<JSONExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, JSON, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<String>, Option<API.Watermark>>> unapply(JSONExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple16((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), (Object)x$0.settings(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.inputField(), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private JSONExtractStage$() {
        MODULE$ = this;
    }
}

