/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.TextExtract;
import ai.tripl.arc.extract.TextExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple14;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TextExtractStage$
implements Serializable {
    public static TextExtractStage$ MODULE$;

    static {
        new TextExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(TextExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Right right;
        Option<StructType> optionSchema;
        block33: {
            Option<StructType> option;
            try {
                option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            optionSchema = option;
            try {
                if (arcContext.isStreaming()) {
                    Right right2;
                    CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                    Option<StructType> option2 = optionSchema;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        StructType schema = (StructType)some.value();
                        Option<API.Watermark> option3 = stage.watermark();
                        if (option3 instanceof Some) {
                            Some some2 = (Some)option3;
                            API.Watermark watermark = (API.Watermark)some2.value();
                            right2 = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).text(stage.input()).withWatermark(watermark.eventTime(), watermark.delayThreshold()));
                        } else {
                            if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                            right2 = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).text(stage.input()));
                        }
                    } else {
                        if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                        throw new Exception("TextExtract requires 'schemaURI' to be set if Arc is running in streaming mode.");
                    }
                    Right right3 = right2;
                    right = right3;
                    break block33;
                }
                CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                try {
                    if (stage.multiLine()) {
                        Right right4;
                        Option<String> option4 = stage.basePath();
                        if (option4 instanceof Some) {
                            Some some = (Some)option4;
                            String basePath = (String)some.value();
                            right4 = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "true").option("basePath", basePath).parquet(stage.input()));
                        } else {
                            if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                            right4 = package$.MODULE$.Right().apply((Object)spark.read().option("wholetext", "true").textFile(stage.input()).toDF());
                        }
                        right = right4;
                        break block33;
                    }
                    right = package$.MODULE$.Right().apply((Object)spark.read().option("wholetext", "false").textFile(stage.input()).toDF());
                }
                catch (Throwable throwable) {
                    AnalysisException analysisException;
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof AnalysisException) || !(analysisException = (AnalysisException)throwable2).getMessage().contains("Path does not exist")) {
                        if (!(throwable2 instanceof Exception)) throw throwable;
                        Exception exception = (Exception)throwable2;
                        throw exception;
                    }
                    Left left = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)Option$.MODULE$.apply((Object)stage.input())));
                    right = left;
                }
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        Right df = right;
        try {
            Dataset dataset4;
            Right right5 = df;
            if (right5 instanceof Right) {
                Dataset dataset5;
                Right right6 = right5;
                Dataset df2 = (Dataset)right6.value();
                if (df2.schema().length() == 0) {
                    Option<StructType> option = optionSchema;
                    if (!(option instanceof Some)) {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)stage.input())).getMessage());
                    }
                    Some some = (Some)option;
                    StructType structType = (StructType)some.value();
                    Dataset dataset6 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                    dataset5 = dataset6;
                } else {
                    dataset5 = df2;
                }
                dataset4 = dataset5;
            } else {
                if (!(right5 instanceof Left)) throw new MatchError((Object)right5);
                Left left = (Left)right5;
                API.PathNotExistsExtractError error = (API.PathNotExistsExtractError)left.value();
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option = optionSchema;
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new Exception(error.getMessage());
                }
                Some some = (Some)option;
                StructType s = (StructType)some.value();
                Dataset dataset7 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset4 = dataset7;
            }
            dataset3 = dataset4;
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), arcContext);
        Option<StructType> option = optionSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        Option<Object> option5 = stage.numPartitions();
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            dataset = enrichedDF.repartition(numPartitions);
        } else {
            if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
            dataset = enrichedDF;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public TextExtractStage apply(TextExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, String input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, boolean contiguousIndex, boolean multiLine, Option<String> basePath, Option<API.Watermark> watermark) {
        return new TextExtractStage(plugin, name, description, schema, outputView, input, authentication, params, persist, numPartitions, contiguousIndex, multiLine, basePath, watermark);
    }

    public Option<Tuple14<TextExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, String, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, Object, Object, Option<String>, Option<API.Watermark>>> unapply(TextExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), (Object)x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.multiLine()), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TextExtractStage$() {
        MODULE$ = this;
    }
}

