/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.XMLExtract;
import ai.tripl.arc.extract.XMLExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.databricks.spark.xml.XmlReader;
import java.io.Serializable;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class XMLExtractStage$
implements scala.Serializable {
    public static XMLExtractStage$ MODULE$;

    static {
        new XMLExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(XMLExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Dataset dataset4;
        Right right;
        Option<StructType> option;
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
        try {
            option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Option<StructType> optionSchema = option;
        try {
            Right right2;
            Either<String, String> either = stage.input();
            if (either instanceof Right) {
                Right right3 = (Right)either;
                String glob = (String)right3.value();
                CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
                String oldDelimiter = spark.sparkContext().hadoopConfiguration().get("textinputformat.record.delimiter");
                String newDelimiter = String.valueOf(BoxesRunTime.boxToCharacter((char)'\u0000'));
                spark.sparkContext().hadoopConfiguration().set("textinputformat.record.delimiter", newDelimiter);
                RDD textFile = spark.sparkContext().textFile(glob, spark.sparkContext().textFile$default$2());
                XmlReader xmlReader = new XmlReader();
                Dataset xml = xmlReader.xmlRdd(spark, textFile);
                if (oldDelimiter == null) {
                    spark.sparkContext().hadoopConfiguration().unset("textinputformat.record.delimiter");
                } else {
                    spark.sparkContext().hadoopConfiguration().set("textinputformat.record.delimiter", oldDelimiter);
                }
                right2 = package$.MODULE$.Right().apply((Object)xml);
            } else {
                if (!(either instanceof Left)) throw new MatchError(either);
                Left left = (Left)either;
                String view = (String)left.value();
                XmlReader xmlReader = new XmlReader();
                right2 = package$.MODULE$.Right().apply((Object)xmlReader.xmlRdd(spark, spark.table(view).as(spark.implicits().newStringEncoder()).rdd()));
            }
            right = right2;
        }
        catch (Throwable throwable) {
            Left left;
            InvalidInputException invalidInputException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidInputException && (invalidInputException = (InvalidInputException)throwable2).getMessage().contains("matches 0 files")) {
                Either<String, String> either = stage.input();
                if (either instanceof Right) {
                    Right right4 = (Right)either;
                    String glob = (String)right4.value();
                    left = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)Option$.MODULE$.apply((Object)glob)));
                } else {
                    if (!(either instanceof Left)) throw new MatchError(either);
                    left = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)None$.MODULE$));
                }
            } else {
                if (!(throwable2 instanceof Exception)) throw throwable;
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$1.stageDetail();
                    }
                };
            }
            Left left2 = left;
            right = left2;
        }
        Right df = right;
        try {
            Dataset dataset5;
            Right right5 = df;
            if (right5 instanceof Right) {
                Dataset dataset6;
                Right right6 = right5;
                Dataset df2 = (Dataset)right6.value();
                if (df2.schema().length() == 0) {
                    Option<StructType> option2 = optionSchema;
                    if (!(option2 instanceof Some)) {
                        if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                        Either<String, String> either = stage.input();
                        if (either instanceof Right) {
                            Right right7 = (Right)either;
                            String glob = (String)right7.value();
                            throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)glob)).getMessage());
                        }
                        if (!(either instanceof Left)) throw new MatchError(either);
                        throw new Exception(new API.EmptySchemaExtractError((Option<String>)None$.MODULE$).getMessage());
                    }
                    Some some = (Some)option2;
                    StructType structType = (StructType)some.value();
                    Dataset dataset7 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                    dataset6 = dataset7;
                } else {
                    dataset6 = df2;
                }
                dataset5 = dataset6;
            } else {
                if (!(right5 instanceof Left)) throw new MatchError((Object)right5);
                Left left = (Left)right5;
                API.FileNotFoundExtractError error = (API.FileNotFoundExtractError)left.value();
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option3 = optionSchema;
                if (!(option3 instanceof Some)) {
                    if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                    throw new Exception(error.getMessage());
                }
                Some some = (Some)option3;
                StructType s = (StructType)some.value();
                Dataset dataset8 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset5 = dataset8;
            }
            dataset4 = dataset5;
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset4;
        if (emptyDataframeHandlerDF.schema().length() == 1) {
            String string = emptyDataframeHandlerDF.schema().fields()[0].dataType().typeName();
            Dataset dataset9 = "array".equals(string) ? emptyDataframeHandlerDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col(emptyDataframeHandlerDF.schema().fieldNames()[0]))})).select("col.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])) : ("struct".equals(string) ? emptyDataframeHandlerDF.select(new StringBuilder(2).append(emptyDataframeHandlerDF.schema().fieldNames()[0]).append(".*").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])) : emptyDataframeHandlerDF);
            dataset3 = dataset9;
        } else {
            dataset3 = emptyDataframeHandlerDF;
        }
        Dataset flattenedDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)flattenedDF, stage.contiguousIndex(), arcContext);
        Option<StructType> option4 = optionSchema;
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema);
        } else {
            if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset10;
            Option<Object> option5 = stage.numPartitions();
            if (option5 instanceof Some) {
                Some some = (Some)option5;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset10 = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                dataset10 = enrichedDF;
            }
            dataset = dataset10;
        } else {
            Dataset dataset11;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> enrichedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option6 = stage.numPartitions();
            if (option6 instanceof Some) {
                Some some = (Some)option6;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset11 = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                dataset11 = enrichedDF.repartition((Seq)partitionCols);
            }
            dataset = dataset11;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public XMLExtractStage apply(XMLExtract plugin, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex) {
        return new XMLExtractStage(plugin, name, description, schema, outputView, input, authentication, params, persist, numPartitions, partitionBy, contiguousIndex);
    }

    public Option<Tuple12<XMLExtract, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object>> unapply(XMLExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private XMLExtractStage$() {
        MODULE$ = this;
    }
}

