/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.load;

import ai.tripl.arc.api.API;
import ai.tripl.arc.load.JDBCLoad;
import ai.tripl.arc.load.JDBCLoadStage;
import ai.tripl.arc.util.ControlUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.JDBCSink;
import ai.tripl.arc.util.ListenerUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple17;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JDBCLoadStage$
implements scala.Serializable {
    public static JDBCLoadStage$ MODULE$;
    private final int SaveModeIgnore;

    static {
        new JDBCLoadStage$();
    }

    public int SaveModeIgnore() {
        return this.SaveModeIgnore;
    }

    public Option<Dataset<Row>> execute(JDBCLoadStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Option option;
        int n;
        BoxedUnit boxedUnit;
        Dataset df = spark.table(stage.inputView());
        if (!df.isStreaming()) {
            Option option2;
            Option<Object> option3 = stage.numPartitions();
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                int partitions = BoxesRunTime.unboxToInt((Object)some.value());
                option2 = stage.stageDetail().put((Object)"numPartitions", (Object)partitions);
            } else if (None$.MODULE$.equals(option3)) {
                option2 = stage.stageDetail().put((Object)"numPartitions", (Object)df.rdd().getNumPartitions());
            } else {
                throw new MatchError(option3);
            }
            boxedUnit = option2;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = !df.isStreaming() && !spark.catalog().isCached(stage.inputView()) ? df.cache() : BoxedUnit.UNIT;
        Properties connectionProperties = new Properties();
        connectionProperties.put("dbtable", stage.tableName());
        stage.params().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCLoadStage$.$anonfun$execute$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
            Tuple2 tuple2 = x$28;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Object object = connectionProperties.put(key, value);
            return object;
        });
        JdbcOptionsInWrite jdbcOptions = new JdbcOptionsInWrite((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)stage.jdbcURL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)stage.tableName())})));
        try {
            n = BoxesRunTime.unboxToInt(ControlUtils$.MODULE$.using(DriverManager.getConnection(stage.jdbcURL(), connectionProperties), (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)JDBCLoadStage$.$anonfun$execute$3(jdbcOptions, stage, connection))));
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final scala.collection.mutable.Map<String, Object> detail;

                public scala.collection.mutable.Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        int targetPreCount = n;
        HashMap<String, Object> dropMap = new HashMap<String, Object>();
        Seq arrays = (Seq)((TraversableLike)df.schema().filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)JDBCLoadStage$.$anonfun$execute$6(x$29)))).map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.name(), Seq$.MODULE$.canBuildFrom());
        Object object2 = !arrays.isEmpty() ? dropMap.put("ArrayType", JavaConverters$.MODULE$.seqAsJavaListConverter(arrays).asJava()) : BoxedUnit.UNIT;
        Seq nulls = (Seq)((TraversableLike)df.schema().filter((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)JDBCLoadStage$.$anonfun$execute$8(x$31)))).map((Function1 & Serializable & scala.Serializable)x$32 -> x$32.name(), Seq$.MODULE$.canBuildFrom());
        Object object3 = !nulls.isEmpty() ? dropMap.put("NullType", JavaConverters$.MODULE$.seqAsJavaListConverter(nulls).asJava()) : BoxedUnit.UNIT;
        stage.stageDetail().put((Object)"drop", dropMap);
        Dataset nonNullDF = df.drop(arrays).drop(nulls);
        SparkListener listener = ListenerUtils$.MODULE$.addStageCompletedListener(stage.stageDetail(), spark, logger);
        if (nonNullDF.isStreaming()) {
            JDBCSink jdbcSink = new JDBCSink(stage.jdbcURL(), connectionProperties);
            List<String> list = stage.partitionBy();
            StreamingQuery streamingQuery = Nil$.MODULE$.equals(list) ? nonNullDF.writeStream().foreach((ForeachWriter)jdbcSink).start() : nonNullDF.writeStream().partitionBy(list).foreach((ForeachWriter)jdbcSink).start();
            option = None$.MODULE$;
        } else if (targetPreCount != this.SaveModeIgnore()) {
            long sourceCount = df.count();
            stage.stageDetail().put((Object)"count", (Object)sourceCount);
            Dataset writtenDF = JDBCLoadStage$.liftedTree1$1(connectionProperties, stage, nonNullDF, sourceCount, targetPreCount);
            option = Option$.MODULE$.apply((Object)writtenDF);
        } else {
            option = Option$.MODULE$.apply((Object)df);
        }
        Option outputDF = option;
        spark.sparkContext().removeSparkListener((SparkListenerInterface)listener);
        return outputDF;
    }

    public JDBCLoadStage apply(JDBCLoad plugin, String name, Option<String> description, String inputView, String jdbcURL, String tableName, List<String> partitionBy, Option<Object> numPartitions, API.IsolationLevelType isolationLevel, int batchsize, boolean truncate, Option<String> createTableOptions, Option<String> createTableColumnTypes, SaveMode saveMode, Driver driver, boolean tablock, Map<String, String> params) {
        return new JDBCLoadStage(plugin, name, description, inputView, jdbcURL, tableName, partitionBy, numPartitions, isolationLevel, batchsize, truncate, createTableOptions, createTableColumnTypes, saveMode, driver, tablock, params);
    }

    public Option<Tuple17<JDBCLoad, String, Option<String>, String, String, String, List<String>, Option<Object>, API.IsolationLevelType, Object, Object, Option<String>, Option<String>, SaveMode, Driver, Object, Map<String, String>>> unapply(JDBCLoadStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple17((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.jdbcURL(), (Object)x$0.tableName(), x$0.partitionBy(), x$0.numPartitions(), (Object)x$0.isolationLevel(), (Object)BoxesRunTime.boxToInteger((int)x$0.batchsize()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.truncate()), x$0.createTableOptions(), x$0.createTableColumnTypes(), (Object)x$0.saveMode(), (Object)x$0.driver(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.tablock()), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$execute$5(JDBCLoadStage stage$1, Statement statement) {
        ResultSet resultSet = statement.executeQuery(new StringBuilder(30).append("SELECT COUNT(*) AS count FROM ").append(stage$1.tableName()).toString());
        resultSet.next();
        return resultSet.getInt("count");
    }

    public static final /* synthetic */ int $anonfun$execute$3(JdbcOptionsInWrite jdbcOptions$1, JDBCLoadStage stage$1, Connection connection) {
        int n;
        if (JdbcUtils$.MODULE$.tableExists(connection, jdbcOptions$1)) {
            int n2;
            SaveMode saveMode = stage$1.saveMode();
            if (SaveMode.ErrorIfExists.equals(saveMode)) {
                throw new Exception(new StringBuilder(81).append("Table '").append(stage$1.tableName()).append("' already exists and 'saveMode' equals 'ErrorIfExists' so cannot continue.").toString());
            }
            if (SaveMode.Ignore.equals(saveMode)) {
                n2 = MODULE$.SaveModeIgnore();
            } else if (SaveMode.Overwrite.equals(saveMode)) {
                Object object;
                if (stage$1.truncate()) {
                    JdbcUtils$.MODULE$.truncateTable(connection, jdbcOptions$1);
                    object = BoxedUnit.UNIT;
                } else {
                    object = ControlUtils$.MODULE$.using(connection.createStatement(), (Function1 & Serializable & scala.Serializable)statement -> BoxesRunTime.boxToInteger((int)statement.executeUpdate(new StringBuilder(12).append("DELETE FROM ").append(stage$1.tableName()).toString())));
                }
                n2 = 0;
            } else if (SaveMode.Append.equals(saveMode)) {
                n2 = BoxesRunTime.unboxToInt(ControlUtils$.MODULE$.using(connection.createStatement(), (Function1 & Serializable & scala.Serializable)statement -> BoxesRunTime.boxToInteger((int)JDBCLoadStage$.$anonfun$execute$5(stage$1, statement))));
            } else {
                throw new MatchError((Object)saveMode);
            }
            n = n2;
        } else {
            n = 0;
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$execute$6(StructField x$29) {
        String string = x$29.dataType().typeName();
        String string2 = "array";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$execute$8(StructField x$31) {
        DataType dataType = x$31.dataType();
        NullType$ nullType$ = NullType$.MODULE$;
        return !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null);
    }

    public static final /* synthetic */ int $anonfun$execute$13(JDBCLoadStage stage$1, Connection connection) {
        ResultSet resultSet = connection.createStatement().executeQuery(new StringBuilder(30).append("SELECT COUNT(*) AS count FROM ").append(stage$1.tableName()).toString());
        resultSet.next();
        return resultSet.getInt("count");
    }

    private static final Dataset liftedTree1$1(Properties connectionProperties$1, JDBCLoadStage stage$1, Dataset nonNullDF$1, long sourceCount$1, int targetPreCount$1) {
        Dataset dataset;
        try {
            connectionProperties$1.put("truncate", ((Object)BoxesRunTime.boxToBoolean((boolean)stage$1.truncate())).toString());
            connectionProperties$1.put("isolationLevel", stage$1.isolationLevel().sparkString());
            connectionProperties$1.put("batchsize", ((Object)BoxesRunTime.boxToInteger((int)stage$1.batchsize())).toString());
            stage$1.numPartitions().foreach((Function1 & Serializable & scala.Serializable)numPartitions -> connectionProperties$1.put("numPartitions", ((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)numPartitions))).toString()));
            stage$1.createTableOptions().foreach((Function1 & Serializable & scala.Serializable)createTableOptions -> connectionProperties$1.put("createTableOptions", createTableOptions));
            stage$1.createTableColumnTypes().foreach((Function1 & Serializable & scala.Serializable)createTableColumnTypes -> connectionProperties$1.put("createTableColumnTypes", createTableColumnTypes));
            List<String> list = stage$1.partitionBy();
            if (Nil$.MODULE$.equals(list)) {
                nonNullDF$1.write().mode(stage$1.saveMode()).jdbc(stage$1.jdbcURL(), stage$1.tableName(), connectionProperties$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                nonNullDF$1.write().partitionBy(list).mode(stage$1.saveMode()).jdbc(stage$1.jdbcURL(), stage$1.tableName(), connectionProperties$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            int targetPostCount = BoxesRunTime.unboxToInt(ControlUtils$.MODULE$.using(DriverManager.getConnection(stage$1.jdbcURL(), connectionProperties$1), (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)JDBCLoadStage$.$anonfun$execute$13(stage$1, connection))));
            stage$1.stageDetail().put((Object)"sourceCount", (Object)sourceCount$1);
            stage$1.stageDetail().put((Object)"targetPreCount", (Object)targetPreCount$1);
            stage$1.stageDetail().put((Object)"targetPostCount", (Object)targetPostCount);
            if (sourceCount$1 != (long)(targetPostCount - targetPreCount$1)) {
                throw new Exception(new StringBuilder(141).append("JDBCLoad should create same number of records in the target ('").append(stage$1.tableName()).append("') as exist in source ('").append(stage$1.inputView()).append("') but source has ").append(sourceCount$1).append(" records and target created ").append(targetPostCount - targetPreCount$1).append(" records.").toString());
            }
            dataset = nonNullDF$1;
        }
        catch (Exception e) {
            throw new DetailException(e, stage$1){
                private final scala.collection.mutable.Map<String, Object> detail;

                public scala.collection.mutable.Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        return dataset;
    }

    private JDBCLoadStage$() {
        MODULE$ = this;
        this.SaveModeIgnore = -1;
    }
}

