/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.load;

import ai.tripl.arc.api.API;
import ai.tripl.arc.load.TextLoad;
import ai.tripl.arc.load.TextLoadStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple13;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TextLoadStage$
implements scala.Serializable {
    public static TextLoadStage$ MODULE$;

    static {
        new TextLoadStage$();
    }

    public Option<Dataset<Row>> execute(TextLoadStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset df;
        block18: {
            BoxedUnit boxedUnit;
            String signature = "TextLoad requires input [value: string] or [value: string, filename: string] signature when in singleFile mode.";
            df = spark.table(stage.inputView());
            if (!df.isStreaming()) {
                Option option;
                Option<Object> option2 = stage.numPartitions();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    int partitions = BoxesRunTime.unboxToInt((Object)some.value());
                    option = stage.stageDetail().put((Object)"numPartitions", (Object)partitions);
                } else if (None$.MODULE$.equals(option2)) {
                    option = stage.stageDetail().put((Object)"numPartitions", (Object)df.rdd().getNumPartitions());
                } else {
                    throw new MatchError(option2);
                }
                boxedUnit = option;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger);
            try {
                block24: {
                    block23: {
                        block19: {
                            block22: {
                                block20: {
                                    block21: {
                                        if (!stage.singleFile()) break block19;
                                        if (df.schema().length() == 0 || df.schema().length() > 2) break block20;
                                        if (df.schema().length() != 1) break block21;
                                        DataType dataType = df.schema().fields()[0].dataType();
                                        StringType$ stringType$ = StringType$.MODULE$;
                                        if (dataType != null ? !dataType.equals(stringType$) : stringType$ != null) break block20;
                                    }
                                    if (df.schema().length() != 2 || !df.schema().forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TextLoadStage$.$anonfun$execute$1(f)))) break block22;
                                }
                                throw new Exception(new StringBuilder(8).append(signature).append(" Got [").append(((TraversableOnce)df.schema().map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(2).append(f.name()).append(": ").append(f.dataType().simpleString()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("].").toString());
                            }
                            FileSystem fs = FileSystem.get((Configuration)spark.sparkContext().hadoopConfiguration());
                            Map groupedRows = df.schema().length() == 2 ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).groupBy((Function1 & Serializable & scala.Serializable)row -> new URI(new StringBuilder(1).append(stage.outputURI()).append("/").append(row.getString(row.fieldIndex("filename"))).toString())) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).groupBy((Function1 & Serializable & scala.Serializable)x$21 -> stage.outputURI());
                            groupedRows.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                TextLoadStage$.$anonfun$execute$5(fs, stage, x0$1);
                                return BoxedUnit.UNIT;
                            });
                            groupedRows.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                TextLoadStage$.$anonfun$execute$6(fs, stage, df, x0$2);
                                return BoxedUnit.UNIT;
                            });
                            fs.close();
                            break block18;
                        }
                        if (df.schema().length() != 1) break block23;
                        DataType dataType = df.schema().fields()[0].dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if (!(dataType == null ? stringType$ != null : !dataType.equals(stringType$))) break block24;
                    }
                    throw new DetailException(df, stage){
                        private final scala.collection.mutable.Map<String, Object> detail;

                        public scala.collection.mutable.Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$1.stageDetail();
                        }
                    };
                }
                Option<Object> option = stage.numPartitions();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n = BoxesRunTime.unboxToInt((Object)some.value());
                    df.repartition(n).write().mode(stage.saveMode()).text(stage.outputURI().toString());
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    break block18;
                }
                if (None$.MODULE$.equals(option)) {
                    df.write().mode(stage.saveMode()).text(stage.outputURI().toString());
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    break block18;
                }
                throw new MatchError(option);
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final scala.collection.mutable.Map<String, Object> detail;

                    public scala.collection.mutable.Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$1.stageDetail();
                    }
                };
            }
        }
        return Option$.MODULE$.apply((Object)df);
    }

    public TextLoadStage apply(TextLoad plugin, String name, Option<String> description, String inputView, URI outputURI, Option<Object> numPartitions, Option<API.Authentication> authentication, SaveMode saveMode, Map<String, String> params, boolean singleFile, String prefix, String separator, String suffix) {
        return new TextLoadStage(plugin, name, description, inputView, outputURI, numPartitions, authentication, saveMode, params, singleFile, prefix, separator, suffix);
    }

    public Option<Tuple13<TextLoad, String, Option<String>, String, URI, Option<Object>, Option<API.Authentication>, SaveMode, Map<String, String>, Object, String, String, String>> unapply(TextLoadStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple13((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.outputURI(), x$0.numPartitions(), x$0.authentication(), (Object)x$0.saveMode(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.singleFile()), (Object)x$0.prefix(), (Object)x$0.separator(), (Object)x$0.suffix()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$execute$1(StructField f) {
        if (!((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"filename", "value"}))).contains((Object)f.name())) return true;
        DataType dataType = f.dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType == null) {
            if (stringType$ == null) return false;
            return true;
        } else if (dataType.equals(stringType$)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$execute$5(FileSystem fs$1, TextLoadStage stage$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            URI outputURI = (URI)tuple2._1();
            Path path = new Path(outputURI);
            if (fs$1.exists(path)) {
                SaveMode saveMode = stage$1.saveMode();
                if (SaveMode.ErrorIfExists.equals(saveMode)) {
                    throw new Exception(new StringBuilder(80).append("File '").append(path.toString()).append("' already exists and 'saveMode' equals 'ErrorIfExists' so cannot continue.").toString());
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$execute$6(FileSystem fs$1, TextLoadStage stage$1, Dataset df$1, Tuple2 x0$2) {
        Option outputStream;
        Option option;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        URI outputURI = (URI)tuple2._1();
        Row[] rowGroup = (Row[])tuple2._2();
        Path path = new Path(outputURI);
        if (fs$1.exists(path)) {
            void var6_12;
            SaveMode saveMode = stage$1.saveMode();
            if (SaveMode.Overwrite.equals(saveMode)) {
                Option option2 = Option$.MODULE$.apply((Object)fs$1.create(path, true));
            } else if (SaveMode.Append.equals(saveMode)) {
                Option option3 = Option$.MODULE$.apply((Object)fs$1.append(path));
            } else {
                None$ none$ = None$.MODULE$;
            }
            option = var6_12;
        } else {
            option = Option$.MODULE$.apply((Object)fs$1.create(path));
        }
        Option option4 = outputStream = option;
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            FSDataOutputStream os = (FSDataOutputStream)some.value();
            os.writeBytes(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowGroup)).map((Function1 & Serializable & scala.Serializable)row -> df$1.schema().length() == 1 ? row.getString(0) : row.getString(row.fieldIndex("value")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(stage$1.prefix(), stage$1.separator(), stage$1.suffix()));
            os.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option4)) throw new MatchError((Object)option4);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private TextLoadStage$() {
        MODULE$ = this;
    }
}

