/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.transform;

import ai.tripl.arc.api.API;
import ai.tripl.arc.transform.MetadataFilterTransform;
import ai.tripl.arc.transform.MetadataFilterTransformStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MetadataFilterTransformStage$
implements scala.Serializable {
    public static MetadataFilterTransformStage$ MODULE$;

    static {
        new MetadataFilterTransformStage$();
    }

    public Option<Dataset<Row>> execute(MetadataFilterTransformStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        String stmt = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)stmt);
        Dataset df = spark.table(stage.inputView());
        Dataset<Row> metadataSchemaDF = MetadataUtils$.MODULE$.createMetadataDataframe((Dataset<Row>)df, spark, logger);
        metadataSchemaDF.createOrReplaceTempView("metadata");
        try {
            dataset2 = spark.sql(stmt);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Dataset filterDF = dataset2;
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filterDF.columns())).contains((Object)"name")) {
            throw new DetailException(stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        scala.collection.immutable.Set inputFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).toSet();
        scala.collection.immutable.Set includeColumns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filterDF.collect())).map((Function1 & Serializable & scala.Serializable)field -> field.getString(field.fieldIndex("name")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        scala.collection.immutable.Set excludeColumns = (scala.collection.immutable.Set)inputFields.diff((GenSet)includeColumns);
        stage.stageDetail().put((Object)"includedColumns", JavaConverters$.MODULE$.setAsJavaSetConverter((Set)includeColumns).asJava());
        stage.stageDetail().put((Object)"excludedColumns", JavaConverters$.MODULE$.setAsJavaSetConverter((Set)excludeColumns).asJava());
        Dataset transformedDF = df.drop((Seq)excludeColumns.toList());
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset3;
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset3 = transformedDF.repartition(numPartitions);
            } else if (None$.MODULE$.equals(option)) {
                dataset3 = transformedDF;
            } else {
                throw new MatchError(option);
            }
            dataset = dataset3;
        } else {
            Dataset dataset4;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> transformedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset4 = transformedDF.repartition(numPartitions, (Seq)partitionCols);
            } else if (None$.MODULE$.equals(option)) {
                dataset4 = transformedDF.repartition((Seq)partitionCols);
            } else {
                throw new MatchError(option);
            }
            dataset = dataset4;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        spark.catalog().dropTempView("metadata");
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public MetadataFilterTransformStage apply(MetadataFilterTransform plugin, String name, Option<String> description, String inputView, URI inputURI, String sql, String outputView, scala.collection.immutable.Map<String, String> params, scala.collection.immutable.Map<String, String> sqlParams, boolean persist, Option<Object> numPartitions, List<String> partitionBy) {
        return new MetadataFilterTransformStage(plugin, name, description, inputView, inputURI, sql, outputView, params, sqlParams, persist, numPartitions, partitionBy);
    }

    public Option<Tuple12<MetadataFilterTransform, String, Option<String>, String, URI, String, String, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>>> unapply(MetadataFilterTransformStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.plugin(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.inputURI(), (Object)x$0.sql(), (Object)x$0.outputView(), x$0.params(), x$0.sqlParams(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MetadataFilterTransformStage$() {
        MODULE$ = this;
    }
}

