/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.load;

import ai.tripl.arc.api.API;
import ai.tripl.arc.load.JDBCLoad;
import ai.tripl.arc.load.JDBCLoadStage;
import ai.tripl.arc.util.ControlUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.JDBCSink;
import ai.tripl.arc.util.ListenerUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple18;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JDBCLoadStage$
implements scala.Serializable {
    public static JDBCLoadStage$ MODULE$;
    private final int SaveModeIgnore;

    static {
        new JDBCLoadStage$();
    }

    public int SaveModeIgnore() {
        return this.SaveModeIgnore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(JDBCLoadStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Option option;
        Dataset dataset;
        int n;
        Dataset df = spark.table(stage.inputView());
        Object object = !df.isStreaming() && !spark.catalog().isCached(stage.inputView()) ? df.cache() : BoxedUnit.UNIT;
        Properties connectionProperties = new Properties();
        connectionProperties.put("dbtable", stage.tableName());
        stage.params().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCLoadStage$.$anonfun$execute$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            Tuple2 tuple2 = x$31;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Object object = connectionProperties.put(key, value);
            return object;
        });
        JdbcOptionsInWrite jdbcOptions = new JdbcOptionsInWrite((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)stage.jdbcURL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)stage.tableName())})));
        try {
            n = BoxesRunTime.unboxToInt(ControlUtils$.MODULE$.using(DriverManager.getConnection(stage.jdbcURL(), connectionProperties), (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)JDBCLoadStage$.$anonfun$execute$3(jdbcOptions, stage, connection))));
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final scala.collection.mutable.Map<String, Object> detail;

                public scala.collection.mutable.Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        int targetPreCount = n;
        Seq arrays = (Seq)((TraversableLike)df.schema().filter((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)JDBCLoadStage$.$anonfun$execute$6(x$32)))).map((Function1 & Serializable & scala.Serializable)x$33 -> x$33.name(), Seq$.MODULE$.canBuildFrom());
        Seq nulls = (Seq)((TraversableLike)df.schema().filter((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)JDBCLoadStage$.$anonfun$execute$8(x$34)))).map((Function1 & Serializable & scala.Serializable)x$35 -> x$35.name(), Seq$.MODULE$.canBuildFrom());
        if (!arrays.isEmpty() || !nulls.isEmpty()) {
            HashMap<String, Object> dropMap = new HashMap<String, Object>();
            dropMap.put("ArrayType", JavaConverters$.MODULE$.seqAsJavaListConverter(arrays).asJava());
            dropMap.put("NullType", JavaConverters$.MODULE$.seqAsJavaListConverter(nulls).asJava());
            if (!arcContext.dropUnsupported()) throw new Exception(new StringBuilder(101).append("inputView '").append(stage.inputView()).append("' contains types ").append(new ObjectMapper().writeValueAsString(dropMap)).append(" which are unsupported by JDBCLoad and 'dropUnsupported' is set to false.").toString());
            stage.stageDetail().put((Object)"drop", dropMap);
            dataset = df.drop(arrays).drop(nulls);
        } else {
            dataset = df;
        }
        Dataset nonNullDF = dataset;
        SparkListener listener = ListenerUtils$.MODULE$.addStageCompletedListener(stage.stageDetail(), spark, logger);
        if (nonNullDF.isStreaming()) {
            JDBCSink jdbcSink = new JDBCSink(stage.jdbcURL(), connectionProperties);
            List<String> list = stage.partitionBy();
            StreamingQuery streamingQuery = Nil$.MODULE$.equals(list) ? nonNullDF.writeStream().foreach((ForeachWriter)jdbcSink).start() : nonNullDF.writeStream().partitionBy(list).foreach((ForeachWriter)jdbcSink).start();
            option = None$.MODULE$;
        } else if (targetPreCount != this.SaveModeIgnore()) {
            long sourceCount = df.count();
            stage.stageDetail().put((Object)"count", (Object)sourceCount);
            Dataset writtenDF = JDBCLoadStage$.liftedTree1$1(connectionProperties, stage, nonNullDF, sourceCount, targetPreCount);
            option = Option$.MODULE$.apply((Object)writtenDF);
        } else {
            option = Option$.MODULE$.apply((Object)df);
        }
        Option outputDF = option;
        spark.sparkContext().removeSparkListener((SparkListenerInterface)listener);
        return outputDF;
    }

    public JDBCLoadStage apply(JDBCLoad plugin, Option<String> id, String name, Option<String> description, String inputView, String jdbcURL, String tableName, List<String> partitionBy, Option<Object> numPartitions, API.IsolationLevel isolationLevel, int batchsize, boolean truncate, Option<String> createTableOptions, Option<String> createTableColumnTypes, SaveMode saveMode, Driver driver, boolean tablock, Map<String, String> params) {
        return new JDBCLoadStage(plugin, id, name, description, inputView, jdbcURL, tableName, partitionBy, numPartitions, isolationLevel, batchsize, truncate, createTableOptions, createTableColumnTypes, saveMode, driver, tablock, params);
    }

    public Option<Tuple18<JDBCLoad, Option<String>, String, Option<String>, String, String, String, List<String>, Option<Object>, API.IsolationLevel, Object, Object, Option<String>, Option<String>, SaveMode, Driver, Object, Map<String, String>>> unapply(JDBCLoadStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple18((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.jdbcURL(), (Object)x$0.tableName(), x$0.partitionBy(), x$0.numPartitions(), (Object)x$0.isolationLevel(), (Object)BoxesRunTime.boxToInteger((int)x$0.batchsize()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.truncate()), x$0.createTableOptions(), x$0.createTableColumnTypes(), (Object)x$0.saveMode(), (Object)x$0.driver(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.tablock()), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$execute$5(JDBCLoadStage stage$2, Statement statement) {
        ResultSet resultSet = statement.executeQuery(new StringBuilder(30).append("SELECT COUNT(*) AS count FROM ").append(stage$2.tableName()).toString());
        resultSet.next();
        return resultSet.getInt("count");
    }

    public static final /* synthetic */ int $anonfun$execute$3(JdbcOptionsInWrite jdbcOptions$1, JDBCLoadStage stage$2, Connection connection) {
        int n;
        if (JdbcUtils$.MODULE$.tableExists(connection, jdbcOptions$1)) {
            int n2;
            SaveMode saveMode = stage$2.saveMode();
            if (SaveMode.ErrorIfExists.equals(saveMode)) {
                throw new Exception(new StringBuilder(81).append("Table '").append(stage$2.tableName()).append("' already exists and 'saveMode' equals 'ErrorIfExists' so cannot continue.").toString());
            }
            if (SaveMode.Ignore.equals(saveMode)) {
                n2 = MODULE$.SaveModeIgnore();
            } else if (SaveMode.Overwrite.equals(saveMode)) {
                Object object;
                if (stage$2.truncate()) {
                    JdbcUtils$.MODULE$.truncateTable(connection, jdbcOptions$1);
                    object = BoxedUnit.UNIT;
                } else {
                    object = ControlUtils$.MODULE$.using(connection.createStatement(), (Function1 & Serializable & scala.Serializable)statement -> BoxesRunTime.boxToInteger((int)statement.executeUpdate(new StringBuilder(12).append("DELETE FROM ").append(stage$2.tableName()).toString())));
                }
                n2 = 0;
            } else if (SaveMode.Append.equals(saveMode)) {
                n2 = BoxesRunTime.unboxToInt(ControlUtils$.MODULE$.using(connection.createStatement(), (Function1 & Serializable & scala.Serializable)statement -> BoxesRunTime.boxToInteger((int)JDBCLoadStage$.$anonfun$execute$5(stage$2, statement))));
            } else {
                throw new MatchError((Object)saveMode);
            }
            n = n2;
        } else {
            n = 0;
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$execute$6(StructField x$32) {
        String string = x$32.dataType().typeName();
        String string2 = "array";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$execute$8(StructField x$34) {
        DataType dataType = x$34.dataType();
        NullType$ nullType$ = NullType$.MODULE$;
        return !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null);
    }

    public static final /* synthetic */ int $anonfun$execute$13(JDBCLoadStage stage$2, Connection connection) {
        ResultSet resultSet = connection.createStatement().executeQuery(new StringBuilder(30).append("SELECT COUNT(*) AS count FROM ").append(stage$2.tableName()).toString());
        resultSet.next();
        return resultSet.getInt("count");
    }

    private static final /* synthetic */ Dataset liftedTree1$1(Properties connectionProperties$1, JDBCLoadStage stage$2, Dataset nonNullDF$1, long sourceCount$1, int targetPreCount$1) {
        Dataset dataset;
        try {
            connectionProperties$1.put("truncate", Boolean.toString(stage$2.truncate()));
            connectionProperties$1.put("isolationLevel", stage$2.isolationLevel().sparkString());
            connectionProperties$1.put("batchsize", Integer.toString(stage$2.batchsize()));
            stage$2.numPartitions().foreach((Function1 & Serializable & scala.Serializable)numPartitions -> connectionProperties$1.put("numPartitions", Integer.toString(BoxesRunTime.unboxToInt((Object)numPartitions))));
            stage$2.createTableOptions().foreach((Function1 & Serializable & scala.Serializable)createTableOptions -> connectionProperties$1.put("createTableOptions", createTableOptions));
            stage$2.createTableColumnTypes().foreach((Function1 & Serializable & scala.Serializable)createTableColumnTypes -> connectionProperties$1.put("createTableColumnTypes", createTableColumnTypes));
            List<String> list = stage$2.partitionBy();
            if (Nil$.MODULE$.equals(list)) {
                nonNullDF$1.write().mode(stage$2.saveMode()).jdbc(stage$2.jdbcURL(), stage$2.tableName(), connectionProperties$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                nonNullDF$1.write().partitionBy(list).mode(stage$2.saveMode()).jdbc(stage$2.jdbcURL(), stage$2.tableName(), connectionProperties$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            int targetPostCount = BoxesRunTime.unboxToInt(ControlUtils$.MODULE$.using(DriverManager.getConnection(stage$2.jdbcURL(), connectionProperties$1), (Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToInteger((int)JDBCLoadStage$.$anonfun$execute$13(stage$2, connection))));
            stage$2.stageDetail().put((Object)"sourceCount", (Object)sourceCount$1);
            stage$2.stageDetail().put((Object)"targetPreCount", (Object)targetPreCount$1);
            stage$2.stageDetail().put((Object)"targetPostCount", (Object)targetPostCount);
            if (sourceCount$1 != (long)(targetPostCount - targetPreCount$1)) {
                throw new Exception(new StringBuilder(141).append("JDBCLoad should create same number of records in the target ('").append(stage$2.tableName()).append("') as exist in source ('").append(stage$2.inputView()).append("') but source has ").append(sourceCount$1).append(" records and target created ").append(targetPostCount - targetPreCount$1).append(" records.").toString());
            }
            dataset = nonNullDF$1;
        }
        catch (Exception e) {
            throw new DetailException(e, stage$2){
                private final scala.collection.mutable.Map<String, Object> detail;

                public scala.collection.mutable.Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        return dataset;
    }

    private JDBCLoadStage$() {
        MODULE$ = this;
        this.SaveModeIgnore = -1;
    }
}

