/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.util;

import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class MetadataUtils$ {
    public static MetadataUtils$ MODULE$;

    static {
        new MetadataUtils$();
    }

    public Dataset<Row> createMetadataDataframe(Dataset<Row> input, SparkSession spark, Logger logger) {
        Dataset schemaDataframe = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)new .colon.colon((Object)new StringBuilder(12).append("{\"fields\": ").append(this.makeMetadataFromDataframe(input)).append("}").toString(), (List)Nil$.MODULE$), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)), spark.implicits().newStringEncoder()).toDF().as(spark.implicits().newStringEncoder());
        Dataset parsedSchema = spark.read().json(schemaDataframe);
        Dataset schema = parsedSchema.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.col("fields"))})).select("col.*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        schema.cache().count();
        return schema;
    }

    public Map<String, Metadata> getFieldMetadataMap(StructType schema, Option<String> parentElement, Map<String, Metadata> fieldMap) {
        schema.foreach((Function1 & Serializable & scala.Serializable)field -> {
            Map map;
            String key = new StringBuilder(0).append(parentElement.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append((Object)(parentElement.isDefined() ? "." : "")).append(field.name()).toString();
            DataType dataType = field.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                map = MODULE$.getFieldMetadataMap(structType, (Option<String>)Option$.MODULE$.apply((Object)key), fieldMap);
            } else {
                map = (Map)fieldMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)field.metadata()));
            }
            return map;
        });
        return fieldMap;
    }

    public Option<String> getFieldMetadataMap$default$2() {
        return None$.MODULE$;
    }

    public Map<String, Metadata> getFieldMetadataMap$default$3() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public StructType upsertMetadata(StructType structType, Map<String, Metadata> fieldMetadataMap, Option<String> parentElement) {
        return StructType$.MODULE$.apply((Seq)structType.map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            String key = new StringBuilder(0).append(parentElement.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append((Object)(parentElement.isDefined() ? "." : "")).append(field.name()).toString();
            DataType dataType = field.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                structField = new StructField(field.name(), (DataType)MODULE$.upsertMetadata(structType, fieldMetadataMap, (Option<String>)Option$.MODULE$.apply((Object)key)), field.nullable(), field.metadata());
            } else {
                structField = new StructField(field.name(), field.dataType(), field.nullable(), (Metadata)fieldMetadataMap.getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> field.metadata()));
            }
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public Option<String> upsertMetadata$default$3() {
        return None$.MODULE$;
    }

    public Dataset<Row> setMetadata(Dataset<Row> input, StructType incomingSchema, SparkSession spark, Logger logger) {
        Dataset dataset;
        if (input.isStreaming()) {
            ObjectRef output = ObjectRef.create(input);
            incomingSchema.foreach((Function1 & Serializable & scala.Serializable)field -> {
                MetadataUtils$.$anonfun$setMetadata$1(output, field);
                return BoxedUnit.UNIT;
            });
            dataset = (Dataset)output.elem;
        } else {
            StructType outputSchema = this.upsertMetadata(input.schema(), this.getFieldMetadataMap(incomingSchema, this.getFieldMetadataMap$default$2(), this.getFieldMetadataMap$default$3()), this.upsertMetadata$default$3());
            dataset = spark.createDataFrame(input.rdd(), outputSchema);
        }
        return dataset;
    }

    public Option<ObjectNode> fieldAsObjectNode(StructField field2) {
        Option option;
        JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(true);
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode node = jsonNodeFactory.objectNode();
        node.set("name", (JsonNode)jsonNodeFactory.textNode(field2.name()));
        node.set("description", (JsonNode)jsonNodeFactory.textNode(field2.metadata().contains("description") ? field2.metadata().getString("description") : ""));
        node.set("nullable", (JsonNode)jsonNodeFactory.booleanNode(field2.nullable()));
        node.set("metadata", objectMapper.readTree(field2.metadata().json()));
        DataType dataType = field2.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            node.set("type", (JsonNode)jsonNodeFactory.textNode("struct"));
            ArrayNode fieldsArray = node.putArray("fields");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).flatMap((Function1 & Serializable & scala.Serializable)field -> Option$.MODULE$.option2Iterable(MODULE$.fieldAsObjectNode((StructField)field)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ObjectNode.class))))).foreach((Function1 & Serializable & scala.Serializable)field -> fieldsArray.add((JsonNode)field));
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            node.set("type", (JsonNode)jsonNodeFactory.textNode("array"));
            ObjectNode elementTypeNode = (ObjectNode)this.fieldAsObjectNode(new StructField("", arrayType.elementType(), arrayType.containsNull(), StructField$.MODULE$.apply$default$4())).get();
            node.set("elementType", (JsonNode)elementTypeNode);
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof BooleanType) {
            node.set("type", (JsonNode)jsonNodeFactory.textNode("boolean"));
            node.set("trim", (JsonNode)jsonNodeFactory.booleanNode(true));
            ArrayNode trueValuesArray = node.putArray("trueValues");
            trueValuesArray.add("true");
            ArrayNode falseValuesArray = node.putArray("falseValues");
            falseValuesArray.add("false");
            ArrayNode nullableValuesArray = node.putArray("nullableValues");
            nullableValuesArray.add("");
            nullableValuesArray.add("null");
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof DateType) {
            node.set("type", (JsonNode)jsonNodeFactory.textNode("date"));
            ArrayNode formattersArray = node.putArray("formatters");
            formattersArray.add("uuuu-MM-dd");
            node.set("trim", (JsonNode)jsonNodeFactory.booleanNode(true));
            ArrayNode nullableValuesArray = node.putArray("nullableValues");
            nullableValuesArray.add("");
            nullableValuesArray.add("null");
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            node.set("type", (JsonNode)jsonNodeFactory.textNode("decimal"));
            node.set("precision", (JsonNode)jsonNodeFactory.numberNode(decimalType.precision()));
            node.set("scale", (JsonNode)jsonNodeFactory.numberNode(decimalType.scale()));
            node.set("trim", (JsonNode)jsonNodeFactory.booleanNode(true));
            ArrayNode nullableValuesArray = node.putArray("nullableValues");
            nullableValuesArray.add("");
            nullableValuesArray.add("null");
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof DoubleType) {
            node.set("type", (JsonNode)jsonNodeFactory.textNode("double"));
            node.set("trim", (JsonNode)jsonNodeFactory.booleanNode(true));
            ArrayNode nullableValuesArray = node.putArray("nullableValues");
            nullableValuesArray.add("");
            nullableValuesArray.add("null");
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof IntegerType) {
            node.set("type", (JsonNode)jsonNodeFactory.textNode("integer"));
            node.set("trim", (JsonNode)jsonNodeFactory.booleanNode(true));
            ArrayNode nullableValuesArray = node.putArray("nullableValues");
            nullableValuesArray.add("");
            nullableValuesArray.add("null");
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof LongType) {
            node.set("type", (JsonNode)jsonNodeFactory.textNode("long"));
            node.set("trim", (JsonNode)jsonNodeFactory.booleanNode(true));
            ArrayNode nullableValuesArray = node.putArray("nullableValues");
            nullableValuesArray.add("");
            nullableValuesArray.add("null");
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof StringType) {
            node.set("type", (JsonNode)jsonNodeFactory.textNode("string"));
            node.set("trim", (JsonNode)jsonNodeFactory.booleanNode(true));
            ArrayNode nullableValuesArray = node.putArray("nullableValues");
            nullableValuesArray.add("");
            nullableValuesArray.add("null");
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof TimestampType) {
            node.set("type", (JsonNode)jsonNodeFactory.textNode("timestamp"));
            node.set("trim", (JsonNode)jsonNodeFactory.booleanNode(true));
            ArrayNode formattersArray = node.putArray("formatters");
            formattersArray.add("uuuu-MM-dd HH:mm:ss");
            node.set("timezoneId", (JsonNode)jsonNodeFactory.textNode("UTC"));
            ArrayNode nullableValuesArray = node.putArray("nullableValues");
            nullableValuesArray.add("");
            nullableValuesArray.add("null");
            option = Option$.MODULE$.apply((Object)node);
        } else if (dataType instanceof NullType) {
            option = None$.MODULE$;
        } else {
            throw new MatchError((Object)dataType);
        }
        return option;
    }

    public String makeMetadataFromDataframe(Dataset<Row> input) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
        String[] fields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])input.schema().fields())).flatMap((Function1 & Serializable & scala.Serializable)field -> Option$.MODULE$.option2Iterable(MODULE$.fieldAsObjectNode((StructField)field)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ObjectNode.class))))).map((Function1 & Serializable & scala.Serializable)x$1 -> objectWriter.writeValueAsString(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new StringBuilder(2).append("[").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).mkString(",")).append("]").toString();
    }

    public static final /* synthetic */ void $anonfun$setMetadata$1(ObjectRef output$1, StructField field) {
        block0: {
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)output$1.elem).columns())).contains((Object)field.name())) break block0;
            output$1.elem = ((Dataset)output$1.elem).withColumn(field.name(), functions$.MODULE$.col(field.name()).as(field.name(), field.metadata()));
        }
    }

    private MetadataUtils$() {
        MODULE$ = this;
    }
}

