/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.validate;

import ai.tripl.arc.api.API;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import ai.tripl.arc.validate.EqualityValidate;
import ai.tripl.arc.validate.EqualityValidateStage;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.GenSeq;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class EqualityValidateStage$
implements scala.Serializable {
    public static EqualityValidateStage$ MODULE$;
    private final String HASH_KEY;

    static {
        new EqualityValidateStage$();
    }

    public String HASH_KEY() {
        return this.HASH_KEY;
    }

    public Option<Dataset<Row>> execute(EqualityValidateStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset rawLeftDF = spark.table(stage.leftView());
        Dataset rawRightDF = spark.table(stage.rightView());
        Seq leftInternalFields = (Seq)((TraversableLike)rawLeftDF.schema().filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)EqualityValidateStage$.$anonfun$execute$1(field)))).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.name(), Seq$.MODULE$.canBuildFrom());
        Seq rightInternalFields = (Seq)((TraversableLike)rawRightDF.schema().filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)EqualityValidateStage$.$anonfun$execute$3(field)))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), Seq$.MODULE$.canBuildFrom());
        Dataset leftDF = rawLeftDF.drop(leftInternalFields);
        Dataset rightDF = rawRightDF.drop(rightInternalFields);
        String[] leftExceptRightColumns = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftDF.columns())).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])rightDF.columns()));
        String[] rightExceptLeftColumns = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightDF.columns())).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])leftDF.columns()));
        if (leftExceptRightColumns.length != 0 || rightExceptLeftColumns.length != 0) {
            stage.stageDetail().put((Object)"leftExceptRightColumns", (Object)leftExceptRightColumns);
            stage.stageDetail().put((Object)"rightExceptLeftColumns", (Object)rightExceptLeftColumns);
            throw new DetailException(stage, leftDF, leftExceptRightColumns, rightDF, rightExceptLeftColumns){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        IndexedSeq indexedSeq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)leftDF.schema().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.name(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).deep();
        IndexedSeq indexedSeq2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)rightDF.schema().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.name(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).deep();
        if (indexedSeq == null ? indexedSeq2 != null : !indexedSeq.equals(indexedSeq2)) {
            stage.stageDetail().put((Object)"leftColumns", ((TraversableOnce)leftDF.schema().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
            stage.stageDetail().put((Object)"rightColumns", ((TraversableOnce)rightDF.schema().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
            throw new DetailException(stage, leftDF, rightDF){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        IndexedSeq indexedSeq3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)leftDF.schema().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.dataType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class)))).deep();
        IndexedSeq indexedSeq4 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)rightDF.schema().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.dataType(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class)))).deep();
        if (indexedSeq3 == null ? indexedSeq4 != null : !indexedSeq3.equals(indexedSeq4)) {
            stage.stageDetail().put((Object)"leftColumnsTypes", ((TraversableOnce)leftDF.schema().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.dataType().typeName(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
            stage.stageDetail().put((Object)"rightColumnsTypes", ((TraversableOnce)rightDF.schema().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.dataType().typeName(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
            throw new DetailException(stage, leftDF, rightDF){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        Dataset leftHashDF = leftDF.withColumn(this.HASH_KEY(), functions$.MODULE$.sha2(functions$.MODULE$.to_json(functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftDF.columns())).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))))), 512));
        Dataset rightHashDF = rightDF.withColumn(this.HASH_KEY(), functions$.MODULE$.sha2(functions$.MODULE$.to_json(functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightDF.columns())).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))))), 512));
        Dataset transformedDF = leftHashDF.joinWith(rightHashDF, leftHashDF.apply(this.HASH_KEY()).$eq$eq$eq((Object)rightHashDF.apply(this.HASH_KEY())), "full");
        Dataset leftExceptRight = transformedDF.filter(functions$.MODULE$.col("_2").isNull());
        Dataset rightExceptLeft = transformedDF.filter(functions$.MODULE$.col("_1").isNull());
        long leftExceptRightCount = leftExceptRight.count();
        long rightExceptLeftCount = rightExceptLeft.count();
        if (leftExceptRightCount != 0L || rightExceptLeftCount != 0L) {
            stage.stageDetail().put((Object)"leftExceptRightCount", (Object)leftExceptRightCount);
            stage.stageDetail().put((Object)"rightExceptLeftCount", (Object)rightExceptLeftCount);
            throw new DetailException(stage, leftDF, leftExceptRightCount, rightDF, rightExceptLeftCount){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$1.stageDetail();
                }
            };
        }
        return None$.MODULE$;
    }

    public EqualityValidateStage apply(EqualityValidate plugin, Option<String> id, String name, Option<String> description, String leftView, String rightView, scala.collection.immutable.Map<String, String> params) {
        return new EqualityValidateStage(plugin, id, name, description, leftView, rightView, params);
    }

    public Option<Tuple7<EqualityValidate, Option<String>, String, Option<String>, String, String, scala.collection.immutable.Map<String, String>>> unapply(EqualityValidateStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.leftView(), (Object)x$0.rightView(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(StructField field) {
        return field.metadata().contains("internal") && field.metadata().getBoolean("internal");
    }

    public static final /* synthetic */ boolean $anonfun$execute$3(StructField field) {
        return field.metadata().contains("internal") && field.metadata().getBoolean("internal");
    }

    private EqualityValidateStage$() {
        MODULE$ = this;
        this.HASH_KEY = "__hash__";
    }
}

