/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.config;

import ai.tripl.arc.api.API;
import ai.tripl.arc.config.ConfigUtils$;
import ai.tripl.arc.config.Error;
import ai.tripl.arc.config.Plugins$;
import ai.tripl.arc.execute.PipelineExecuteStage;
import ai.tripl.arc.plugins.DynamicConfigurationPlugin;
import ai.tripl.arc.plugins.LifecyclePlugin;
import ai.tripl.arc.plugins.PipelineStagePlugin;
import ai.tripl.arc.plugins.UDFPlugin;
import ai.tripl.arc.util.SerializableConfiguration;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ArcPipeline$ {
    public static ArcPipeline$ MODULE$;

    static {
        new ArcPipeline$();
    }

    public Either<List<Error.Error>, Tuple2<API.ETLPipeline, API.ARCContext>> parsePipeline(Option<String> configUri, API.ARCContext arcContext, SparkSession spark, Logger logger) {
        Option<String> option = configUri;
        if (option instanceof Some) {
            Some some = (Some)option;
            String uri = (String)some.value();
            Option<String> option2 = arcContext.environment();
            if (option2 instanceof Some) {
                return this.parseConfig((Either<String, URI>)package$.MODULE$.Right().apply((Object)new URI(uri)), arcContext, spark, logger);
            }
            if (None$.MODULE$.equals(option2)) {
                Error.ConfigError configError = new Error.ConfigError("file", (Option<Object>)None$.MODULE$, "No environment defined as a command line argument --etl.config.environment or ETL_CONF_ENV environment variable.");
                return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            Error.ConfigError configError = new Error.ConfigError("file", (Option<Object>)None$.MODULE$, "No config defined as a command line argument --etl.config.uri or ETL_CONF_URI environment variable.");
            return package$.MODULE$.Left().apply((Object)Nil$.MODULE$.$colon$colon((Object)configError));
        }
        throw new MatchError(option);
    }

    public Either<List<Error.Error>, Tuple2<API.ETLPipeline, API.ARCContext>> parseConfig(Either<String, URI> uri, API.ARCContext arcContext, SparkSession spark, Logger logger) {
        Either<List<Error.Error>, String> either;
        Either<String, URI> either2 = uri;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            String str = (String)left.value();
            either = package$.MODULE$.Right().apply((Object)str);
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            URI uri2 = (URI)right.value();
            either = ConfigUtils$.MODULE$.getConfigString(uri2, spark, logger, arcContext);
        } else {
            throw new MatchError(either2);
        }
        Either<List<Error.Error>, String> etlConfString = either;
        return etlConfString.flatMap((Function1 & Serializable & scala.Serializable)etlConfRaw -> {
            Either dynamicConfigsOrErrors;
            Tuple2 tuple2;
            Tuple2 tuple22;
            Either either = uri;
            if (either instanceof Right) {
                Right right = (Right)either;
                URI uri = (URI)right.value();
                if (uri.toString().endsWith(".ipynb")) {
                    if (!arcContext.ipynb()) {
                        throw new Exception(new StringBuilder(107).append("Support for IPython Notebook Configuration Files (.ipynb) for configuration '").append(uri.toString()).append("' has been disabled by policy.").toString());
                    }
                    tuple22 = new Tuple2((Object)uri.toString(), (Object)ConfigUtils$.MODULE$.readIPYNB((Option<String>)new Some((Object)uri.toString()), (String)etlConfRaw));
                } else {
                    tuple22 = new Tuple2((Object)uri.toString(), etlConfRaw);
                }
            } else {
                tuple22 = tuple2 = new Tuple2((Object)"", etlConfRaw);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String uriString = (String)tuple2._1();
            String configString = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)uriString, (Object)configString);
            String uriString2 = (String)tuple23._1();
            String configString2 = (String)tuple23._2();
            String etlConfStringHash = DigestUtils.md5Hex((byte[])etlConfRaw.getBytes());
            logger.info().field("event", "validateConfig").field("uri", uriString2).field("content-md5", etlConfStringHash).log();
            Config etlConf = ConfigFactory.parseString((String)configString2, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF));
            String commandLineArgumentsJson = new ObjectMapper().writeValueAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter(arcContext.commandLineArguments()).asJava()).replace("\\", "");
            Config commandLineArgumentsConf = ConfigFactory.parseString((String)commandLineArgumentsJson, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF));
            Either either2 = dynamicConfigsOrErrors = Plugins$.MODULE$.resolveConfigPlugins(etlConf, "plugins.config", arcContext.dynamicConfigurationPlugins(), spark, logger, arcContext);
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                List errors = (List)left.value();
                return package$.MODULE$.Left().apply((Object)errors);
            }
            if (either2 instanceof Right) {
                Config config;
                Right right = (Right)either2;
                List dynamicConfigs = (List)right.value();
                List list = dynamicConfigs;
                if (Nil$.MODULE$.equals(list)) {
                    config = commandLineArgumentsConf.withFallback((ConfigMergeable)etlConf).withFallback((ConfigMergeable)arcContext.resolutionConfig());
                } else {
                    Config dynamicConfigsConf = (Config)dynamicConfigs.reduceRight((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 != null) {
                            Config c1 = (Config)tuple2._1();
                            Config c2 = (Config)tuple2._2();
                            return c1.withFallback((ConfigMergeable)c2);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    config = commandLineArgumentsConf.withFallback((ConfigMergeable)dynamicConfigsConf).withFallback((ConfigMergeable)etlConf).withFallback((ConfigMergeable)arcContext.resolutionConfig());
                }
                arcContext.resolutionConfig_$eq(config);
                Either lifecyclePluginsOrErrors = Plugins$.MODULE$.resolveConfigPlugins(etlConf, "plugins.lifecycle", arcContext.lifecyclePlugins(), spark, logger, arcContext);
                if (!etlConf.hasPath("stages")) {
                    throw new Exception(new StringBuilder(59).append("Key 'stages' missing from job configuration. Have keys: [").append(((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(etlConf.entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.getKey(), Set$.MODULE$.canBuildFrom())).toList().mkString(",")).append("].").toString());
                }
                Either pipelinePluginsOrErrors = Plugins$.MODULE$.resolveConfigPlugins(etlConf, "stages", arcContext.pipelineStagePlugins(), spark, logger, arcContext);
                Tuple2 tuple24 = new Tuple2(lifecyclePluginsOrErrors, pipelinePluginsOrErrors);
                if (tuple24 != null) {
                    Either either3 = (Either)tuple24._1();
                    Either either4 = (Either)tuple24._2();
                    if (either3 instanceof Left) {
                        Left left = (Left)either3;
                        List lifecycleErrors = (List)left.value();
                        if (either4 instanceof Left) {
                            Left left2 = (Left)either4;
                            List pipelineErrors = (List)left2.value();
                            List list2 = lifecycleErrors.reverse();
                            return package$.MODULE$.Left().apply((Object)pipelineErrors.reverse().$colon$colon$colon(list2));
                        }
                    }
                }
                if (tuple24 != null) {
                    Either either5 = (Either)tuple24._1();
                    Either either6 = (Either)tuple24._2();
                    if (either5 instanceof Right && either6 instanceof Left) {
                        Left left = (Left)either6;
                        List pipelineErrors = (List)left.value();
                        return package$.MODULE$.Left().apply((Object)pipelineErrors.reverse());
                    }
                }
                if (tuple24 != null) {
                    Either either7 = (Either)tuple24._1();
                    Either either8 = (Either)tuple24._2();
                    if (either7 instanceof Left) {
                        Left left = (Left)either7;
                        List lifecycleErrors = (List)left.value();
                        if (either8 instanceof Right) {
                            return package$.MODULE$.Left().apply((Object)lifecycleErrors.reverse());
                        }
                    }
                }
                if (tuple24 != null) {
                    Either either9 = (Either)tuple24._1();
                    Either either10 = (Either)tuple24._2();
                    if (either9 instanceof Right) {
                        Right right2 = (Right)either9;
                        List lifecycleInstances = (List)right2.value();
                        if (either10 instanceof Right) {
                            List activeLifecyclePluginInstances;
                            Right right3 = (Right)either10;
                            List pipelineInstances = (List)right3.value();
                            Tuple2 tuple25 = ((GenericTraversableTemplate)pipelineInstances.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                API.PipelineStage pipelineStage = x0$2;
                                if (pipelineStage instanceof PipelineExecuteStage) {
                                    PipelineExecuteStage pipelineExecuteStage = (PipelineExecuteStage)pipelineStage;
                                    API.ETLPipeline pipeline = pipelineExecuteStage.pipeline();
                                    List<API.LifecyclePluginInstance> pipelineLifecycleInstances = pipelineExecuteStage.activeLifecyclePlugins();
                                    return new Tuple2(pipeline.stages(), pipelineLifecycleInstances);
                                }
                                if (pipelineStage != null) {
                                    API.PipelineStage pipelineStage2 = pipelineStage;
                                    return new Tuple2((Object)new .colon.colon((Object)pipelineStage2, (List)Nil$.MODULE$), (Object)Nil$.MODULE$);
                                }
                                throw new MatchError((Object)pipelineStage);
                            }, List$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
                            if (tuple25 == null) {
                                throw new MatchError((Object)tuple25);
                            }
                            List stages = (List)tuple25._1();
                            List plugins = (List)tuple25._2();
                            List list3 = lifecycleInstances;
                            Tuple2 tuple26 = new Tuple2((Object)stages.flatten((Function1)Predef$.MODULE$.$conforms()), (Object)((List)plugins.flatten((Function1)Predef$.MODULE$.$conforms())).$colon$colon$colon(list3));
                            if (tuple26 == null) {
                                throw new MatchError((Object)tuple26);
                            }
                            List flatPipelineInstances = (List)tuple26._1();
                            List activeLifecyclePluginInstances2 = (List)tuple26._2();
                            Tuple2 tuple27 = new Tuple2((Object)flatPipelineInstances, (Object)activeLifecyclePluginInstances2);
                            List flatPipelineInstances2 = (List)tuple27._1();
                            List x$1 = activeLifecyclePluginInstances = (List)tuple27._2();
                            SerializableConfiguration x$2 = new SerializableConfiguration(spark.sparkContext().hadoopConfiguration());
                            Option<String> x$3 = arcContext.copy$default$1();
                            Option<String> x$42 = arcContext.copy$default$2();
                            Option<String> x$5 = arcContext.copy$default$3();
                            Option<String> x$6 = arcContext.copy$default$4();
                            boolean x$7 = arcContext.copy$default$5();
                            boolean x$8 = arcContext.copy$default$6();
                            StorageLevel x$9 = arcContext.copy$default$7();
                            boolean x$10 = arcContext.copy$default$8();
                            boolean x$11 = arcContext.copy$default$9();
                            boolean x$12 = arcContext.copy$default$10();
                            boolean x$13 = arcContext.copy$default$11();
                            boolean x$14 = arcContext.copy$default$12();
                            Map<String, String> x$15 = arcContext.copy$default$13();
                            List<DynamicConfigurationPlugin> x$16 = arcContext.copy$default$14();
                            List<LifecyclePlugin> x$17 = arcContext.copy$default$15();
                            List<PipelineStagePlugin> x$18 = arcContext.copy$default$17();
                            List<UDFPlugin> x$19 = arcContext.copy$default$18();
                            scala.collection.mutable.Map<String, Object> x$20 = arcContext.copy$default$19();
                            Config x$21 = arcContext.copy$default$21();
                            List<String> x$22 = arcContext.copy$default$22();
                            API.ARCContext ctx = arcContext.copy(x$3, x$42, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, (List<API.LifecyclePluginInstance>)x$1, x$18, x$19, x$20, x$2, x$21, x$22);
                            return package$.MODULE$.Right().apply((Object)new Tuple2((Object)new API.ETLPipeline((List<API.PipelineStage>)flatPipelineInstances2), (Object)ctx));
                        }
                    }
                }
                throw new MatchError((Object)tuple24);
            }
            throw new MatchError(either2);
        });
    }

    private ArcPipeline$() {
        MODULE$ = this;
    }
}

