/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.execute;

import ai.tripl.arc.api.API;
import ai.tripl.arc.execute.ControlFlowExecute;
import ai.tripl.arc.execute.ControlFlowExecuteStage;
import ai.tripl.arc.execute.ControlFlowPayload;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple9;
import scala.collection.mutable.Map;

public final class ControlFlowExecuteStage$
implements Serializable {
    public static ControlFlowExecuteStage$ MODULE$;

    static {
        new ControlFlowExecuteStage$();
    }

    public Option<Dataset<Row>> execute(ControlFlowExecuteStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset dataset;
        String signature = "ControlFlowExecute requires query to return 1 row with [outcome: boolean, message: string] signature.";
        if (arcContext.isStreaming()) {
            throw new DetailException(stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        String stmt = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)stmt);
        try {
            dataset = spark.sql(stmt);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset df = dataset;
        long count = df.persist(arcContext.storageLevel()).count();
        if (df.count() != 1L || df.schema().length() != 2) {
            throw new DetailException(signature, count, df, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        try {
            Option option;
            Row row = (Row)df.first();
            boolean resultIsNull = row.isNullAt(0);
            boolean messageIsNull = row.isNullAt(1);
            if (resultIsNull) {
                throw new DetailException(signature, messageIsNull, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            boolean result = row.getBoolean(0);
            String message = row.getString(1);
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                HashMap messageMap = (HashMap)objectMapper.readValue(message, HashMap.class);
                stage.stageDetail().put((Object)"message", (Object)messageMap);
                option = arcContext.userData().put((Object)stage.key(), (Object)new ControlFlowPayload(result, (Option<String>)None$.MODULE$, (Option<HashMap<String, Object>>)Option$.MODULE$.apply((Object)messageMap)));
            }
            catch (Exception e) {
                stage.stageDetail().put((Object)"message", (Object)message);
                option = arcContext.userData().put((Object)stage.key(), (Object)new ControlFlowPayload(result, (Option<String>)Option$.MODULE$.apply((Object)message), (Option<HashMap<String, Object>>)None$.MODULE$));
            }
            stage.stageDetail().put((Object)"result", (Object)result);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassCastException) {
                throw new DetailException(signature, count, df, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            if (throwable2 instanceof Exception && throwable2 instanceof DetailException) {
                Exception exception = (Exception)throwable2;
                throw exception;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            throw throwable;
        }
        df.unpersist();
        return Option$.MODULE$.apply((Object)df);
    }

    public ControlFlowExecuteStage apply(ControlFlowExecute plugin, Option<String> id, String name, String key, Option<String> description, URI inputURI, String sql, scala.collection.immutable.Map<String, String> sqlParams, scala.collection.immutable.Map<String, String> params) {
        return new ControlFlowExecuteStage(plugin, id, name, key, description, inputURI, sql, sqlParams, params);
    }

    public Option<Tuple9<ControlFlowExecute, Option<String>, String, String, Option<String>, URI, String, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> unapply(ControlFlowExecuteStage x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple9((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), (Object)x$0.key(), x$0.description(), (Object)x$0.inputURI(), (Object)x$0.sql(), x$0.sqlParams(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ControlFlowExecuteStage$() {
        MODULE$ = this;
    }
}

