/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.API$FailMode$FailFast$;
import ai.tripl.arc.datasource.BinaryContent$;
import ai.tripl.arc.extract.BytesExtract;
import ai.tripl.arc.extract.BytesExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BytesExtractStage$
implements scala.Serializable {
    public static BytesExtractStage$ MODULE$;

    static {
        new BytesExtractStage$();
    }

    public Option<Dataset<Row>> execute(BytesExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        block15: {
            String signature = "BytesExtract requires 'inputView' to be dataset with [value: string] signature.";
            CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
            try {
                Either<String, String> either = stage.input();
                if (either instanceof Left) {
                    Left left = (Left)either;
                    String view = (String)left.value();
                    Dataset inputView = spark.table(view);
                    StructType schema = inputView.schema();
                    int fieldIndex = BytesExtractStage$.liftedTree1$1(schema, signature, inputView, stage);
                    DataType dataType = schema.fields()[fieldIndex].dataType();
                    if (!(dataType instanceof StringType)) {
                        throw new DetailException(signature, schema, fieldIndex, stage){
                            private final Map<String, Object> detail;

                            public Map<String, Object> detail() {
                                return this.detail;
                            }
                            {
                                this.detail = stage$2.stageDetail();
                            }
                        };
                    }
                    String path = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputView.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("value")})).collect())).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                    dataset2 = spark.read().format("bytes").load(path);
                    break block15;
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    String glob = (String)right.value();
                    Dataset bytesDF = spark.read().format("bytes").load(glob);
                    bytesDF.take(1);
                    dataset2 = bytesDF;
                    break block15;
                }
                throw new MatchError(either);
            }
            catch (InvalidInputException e) {
                API.FailMode failMode = stage.failMode();
                API$FailMode$FailFast$ aPI$FailMode$FailFast$ = API$FailMode$FailFast$.MODULE$;
                if (!(failMode != null ? !failMode.equals(aPI$FailMode$FailFast$) : aPI$FailMode$FailFast$ != null)) {
                    throw new DetailException(stage){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                dataset2 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), BinaryContent$.MODULE$.schema());
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        Dataset df = dataset2;
        Option<Object> option = stage.numPartitions();
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            dataset = df.repartition(numPartitions);
        } else if (None$.MODULE$.equals(option)) {
            dataset = df;
        } else {
            throw new MatchError(option);
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
        stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
        stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
        if (stage.persist() && !repartitionedDF.isStreaming()) {
            spark.catalog().cacheTable(stage.outputView(), arcContext.storageLevel());
            boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public BytesExtractStage apply(BytesExtract plugin, Option<String> id, String name, Option<String> description, String outputView, Either<String, String> input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, boolean contiguousIndex, API.FailMode failMode) {
        return new BytesExtractStage(plugin, id, name, description, outputView, input, authentication, params, persist, numPartitions, contiguousIndex, failMode);
    }

    public Option<Tuple12<BytesExtract, Option<String>, String, Option<String>, String, Either<String, String>, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, Object, API.FailMode>> unapply(BytesExtractStage x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple12((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.outputView(), x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), (Object)x$0.failMode()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final /* synthetic */ int liftedTree1$1(StructType schema$1, String signature$1, Dataset inputView$1, BytesExtractStage stage$2) {
        int n;
        try {
            n = schema$1.fieldIndex("value");
        }
        catch (Exception e) {
            throw new DetailException(signature$1, inputView$1, stage$2){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        return n;
    }

    private BytesExtractStage$() {
        MODULE$ = this;
    }
}

