/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.api.Delimited;
import ai.tripl.arc.api.Delimited$;
import ai.tripl.arc.extract.DelimitedExtract;
import ai.tripl.arc.extract.DelimitedExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple17;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DelimitedExtractStage$
implements scala.Serializable {
    public static DelimitedExtractStage$ MODULE$;

    static {
        new DelimitedExtractStage$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Dataset<Row>> execute(DelimitedExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset repartitionedDF;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Option<StructType> optionSchema;
        block43: {
            Right right;
            block42: {
                Option<StructType> option;
                scala.collection.immutable.Map map;
                Option<String> option2 = stage.basePath();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    String basePath = (String)some.value();
                    map = Delimited$.MODULE$.toSparkOptions(stage.settings()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)basePath));
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    map = Delimited$.MODULE$.toSparkOptions(stage.settings());
                }
                scala.collection.immutable.Map options = map;
                try {
                    option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
                }
                catch (Exception e) {
                    throw new DetailException(e, stage){
                        private final scala.collection.mutable.Map<String, Object> detail;

                        public scala.collection.mutable.Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                optionSchema = option;
                try {
                    if (arcContext.isStreaming()) {
                        Either<String, String> either = stage.input();
                        if (either instanceof Right) {
                            Right right2 = (Right)either;
                            String glob = (String)right2.value();
                            CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
                            Option<StructType> option3 = optionSchema;
                            if (!(option3 instanceof Some)) {
                                if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                                throw new Exception("CSVExtract requires 'schemaURI' or 'schemaView' to be set if Arc is running in streaming mode.");
                            }
                            Some some = (Some)option3;
                            StructType schema = (StructType)some.value();
                            Option<API.Watermark> option4 = stage.watermark();
                            if (option4 instanceof Some) {
                                Some some2 = (Some)option4;
                                API.Watermark watermark = (API.Watermark)some2.value();
                                right = package$.MODULE$.Right().apply((Object)spark.readStream().options((Map)options).schema(schema).format("csv").load(glob).withWatermark(watermark.eventTime(), watermark.delayThreshold()));
                                break block42;
                            } else {
                                if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                                right = package$.MODULE$.Right().apply((Object)spark.readStream().options((Map)options).schema(schema).format("csv").load(glob));
                            }
                            break block42;
                        }
                        if (!(either instanceof Left)) throw new MatchError(either);
                        Left left = (Left)either;
                        String view = (String)left.value();
                        Dataset inputView = spark.table(view);
                        if (inputView.isStreaming()) {
                            throw new Exception("CSVExtract does not support the use of 'inputView' if Arc is running in streaming mode.");
                        }
                        Option<String> option5 = stage.inputField();
                        if (option5 instanceof Some) {
                            Some some = (Some)option5;
                            String inputField = (String)some.value();
                            right = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).csv(inputView.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputField).as("value")})).as(spark.implicits().newStringEncoder())));
                            break block42;
                        } else {
                            if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                            right = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).csv(inputView.as(spark.implicits().newStringEncoder())));
                        }
                        break block42;
                    }
                    Either<String, String> either = stage.input();
                    if (either instanceof Right) {
                        Right right3 = (Right)either;
                        String glob = (String)right3.value();
                        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
                        try {
                            right = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).csv(glob));
                            break block42;
                        }
                        catch (Throwable throwable) {
                            boolean bl = false;
                            AnalysisException analysisException = null;
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof AnalysisException) {
                                bl = true;
                                analysisException = (AnalysisException)throwable2;
                                if (analysisException.getMessage().contains("Unable to infer schema for CSV")) {
                                    right = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)Option$.MODULE$.apply((Object)glob)));
                                    break block42;
                                }
                            }
                            if (bl && analysisException.getMessage().contains("Path does not exist")) {
                                right = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)Option$.MODULE$.apply((Object)glob)));
                                break block42;
                            }
                            if (!(throwable2 instanceof Exception)) throw throwable;
                            Exception exception = (Exception)throwable2;
                            throw exception;
                        }
                    }
                    if (!(either instanceof Left)) throw new MatchError(either);
                    Left left = (Left)either;
                    String view = (String)left.value();
                    Option<String> option6 = stage.inputField();
                    if (option6 instanceof Some) {
                        Some some = (Some)option6;
                        String inputField = (String)some.value();
                        right = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).csv(spark.table(view).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputField).as("value")})).as(spark.implicits().newStringEncoder())));
                    } else {
                        if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                        right = package$.MODULE$.Right().apply((Object)spark.read().options((Map)options).csv(spark.table(view).as(spark.implicits().newStringEncoder())));
                    }
                }
                catch (Exception e) {
                    throw new DetailException(e, stage){
                        private final scala.collection.mutable.Map<String, Object> detail;

                        public scala.collection.mutable.Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
            }
            Right df = right;
            try {
                Right right4 = df;
                if (right4 instanceof Right) {
                    Right right5 = right4;
                    Dataset df2 = (Dataset)right5.value();
                    if (df2.schema().length() == 0) {
                        Option<StructType> option = optionSchema;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            StructType structType = (StructType)some.value();
                            dataset3 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                            break block43;
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                            Either<String, String> either = stage.input();
                            if (either instanceof Right) {
                                Right right6 = (Right)either;
                                String glob = (String)right6.value();
                                throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)glob)).getMessage());
                            }
                            if (!(either instanceof Left)) throw new MatchError(either);
                            throw new Exception(new API.EmptySchemaExtractError((Option<String>)None$.MODULE$).getMessage());
                        }
                    }
                    dataset3 = df2;
                    break block43;
                }
                if (!(right4 instanceof Left)) throw new MatchError((Object)right4);
                Left left = (Left)right4;
                Product error = (Product)left.value();
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option = optionSchema;
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new Exception(((API.ExtractError)error).getMessage());
                }
                Some some = (Some)option;
                StructType s = (StructType)some.value();
                dataset3 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final scala.collection.mutable.Map<String, Object> detail;

                    public scala.collection.mutable.Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), spark, arcContext);
        Option<StructType> option = optionSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema, spark, logger);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Option<Object> option7 = stage.numPartitions();
            if (option7 instanceof Some) {
                Some some = (Some)option7;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option7)) throw new MatchError(option7);
                dataset = enrichedDF;
            }
        } else {
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> enrichedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option8 = stage.numPartitions();
            if (option8 instanceof Some) {
                Some some = (Some)option8;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option8)) throw new MatchError(option8);
                dataset = repartitionedDF = enrichedDF.repartition((Seq)partitionCols);
            }
        }
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (repartitionedDF.isStreaming()) {
            boxedUnit = BoxedUnit.UNIT;
            return Option$.MODULE$.apply((Object)repartitionedDF);
        }
        stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
        stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
        stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
        if (stage.persist()) {
            spark.catalog().cacheTable(stage.outputView(), arcContext.storageLevel());
            boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            return Option$.MODULE$.apply((Object)repartitionedDF);
        }
        boxedUnit = BoxedUnit.UNIT;
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public DelimitedExtractStage apply(DelimitedExtract plugin, Option<String> id, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, Delimited settings, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> inputField, Option<String> basePath, Option<API.Watermark> watermark) {
        return new DelimitedExtractStage(plugin, id, name, description, schema, outputView, input, settings, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, inputField, basePath, watermark);
    }

    public Option<Tuple17<DelimitedExtract, Option<String>, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, Delimited, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<String>, Option<API.Watermark>>> unapply(DelimitedExtractStage x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple17((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), (Object)x$0.settings(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.inputField(), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DelimitedExtractStage$() {
        MODULE$ = this;
    }
}

