/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.JDBCExtract;
import ai.tripl.arc.extract.JDBCExtractStage;
import ai.tripl.arc.util.ControlUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple17;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class JDBCExtractStage$
implements scala.Serializable {
    public static JDBCExtractStage$ MODULE$;

    static {
        new JDBCExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(JDBCExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Option<StructType> option;
        Properties connectionProperties = new Properties();
        stage.params().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCExtractStage$.$anonfun$execute$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            Tuple2 tuple2 = x$24;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return connectionProperties.put(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        stage.numPartitions().foreach((Function1 & Serializable & scala.Serializable)numPartitions -> connectionProperties.put("numPartitions", Integer.toString(BoxesRunTime.unboxToInt((Object)numPartitions))));
        stage.fetchsize().foreach((Function1 & Serializable & scala.Serializable)fetchsize -> connectionProperties.put("fetchsize", Integer.toString(BoxesRunTime.unboxToInt((Object)fetchsize))));
        stage.partitionColumn().foreach((Function1 & Serializable & scala.Serializable)partitionColumn -> {
            Object b;
            connectionProperties.put("partitionColumn", partitionColumn);
            try {
                b = ControlUtils$.MODULE$.using(DriverManager.getConnection(stage.jdbcURL(), connectionProperties), (Function1 & Serializable & scala.Serializable)connection -> ControlUtils$.MODULE$.using(connection.createStatement(), (Function1 & Serializable & scala.Serializable)statement -> {
                    boolean res = statement.execute(new StringBuilder(25).append("SELECT MIN(").append((String)partitionColumn).append("), MAX(").append((String)partitionColumn).append(") FROM ").append(stage.tableName()).toString());
                    if (res) {
                        statement.getResultSet().next();
                        long lowerBound = statement.getResultSet().getLong(1);
                        long upperBound = statement.getResultSet().getLong(2);
                        connectionProperties.put("lowerBound", Long.toString(lowerBound));
                        stage.stageDetail().put((Object)"lowerBound", (Object)lowerBound);
                        connectionProperties.put("upperBound", Long.toString(upperBound));
                        return stage.stageDetail().put((Object)"upperBound", (Object)upperBound);
                    }
                    return BoxedUnit.UNIT;
                }));
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            return b;
        });
        try {
            option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Option<StructType> optionSchema = option;
        try {
            List<String> list = stage.predicates();
            dataset3 = Nil$.MODULE$.equals(list) ? spark.read().jdbc(stage.jdbcURL(), stage.tableName(), connectionProperties) : spark.read().jdbc(stage.jdbcURL(), stage.tableName(), (String[])list.toArray(ClassTag$.MODULE$.apply(String.class)), connectionProperties);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset df = dataset3;
        Option<StructType> option2 = optionSchema;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata((Dataset<Row>)df, schema, spark, logger);
        } else {
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            dataset2 = df;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Option<Object> option3 = stage.numPartitions();
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                int numPartitions2 = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = enrichedDF.repartition(numPartitions2);
            } else {
                if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                dataset = enrichedDF;
            }
        } else {
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> enrichedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option4 = stage.numPartitions();
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                int numPartitions3 = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = enrichedDF.repartition(numPartitions3, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                dataset = enrichedDF.repartition((Seq)partitionCols);
            }
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
        stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
        if (stage.persist()) {
            spark.catalog().cacheTable(stage.outputView(), arcContext.storageLevel());
            boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public JDBCExtractStage apply(JDBCExtract plugin, Option<String> id, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, String jdbcURL, String tableName, Option<Object> numPartitions, Option<Object> fetchsize, Option<String> customSchema, Driver driver, Option<String> partitionColumn, scala.collection.immutable.Map<String, String> params, boolean persist, List<String> partitionBy, List<String> predicates) {
        return new JDBCExtractStage(plugin, id, name, description, schema, outputView, jdbcURL, tableName, numPartitions, fetchsize, customSchema, driver, partitionColumn, params, persist, partitionBy, predicates);
    }

    public Option<Tuple17<JDBCExtract, Option<String>, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, String, String, Option<Object>, Option<Object>, Option<String>, Driver, Option<String>, scala.collection.immutable.Map<String, String>, Object, List<String>, List<String>>> unapply(JDBCExtractStage x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple17((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), (Object)x$0.jdbcURL(), (Object)x$0.tableName(), x$0.numPartitions(), x$0.fetchsize(), x$0.customSchema(), (Object)x$0.driver(), x$0.partitionColumn(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.partitionBy(), x$0.predicates()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private JDBCExtractStage$() {
        MODULE$ = this;
    }
}

