/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.ParquetExtract;
import ai.tripl.arc.extract.ParquetExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple15;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ParquetExtractStage$
implements scala.Serializable {
    public static ParquetExtractStage$ MODULE$;

    static {
        new ParquetExtractStage$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<Dataset<Row>> execute(ParquetExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset repartitionedDF;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Option<StructType> optionSchema;
        block33: {
            Right right;
            block32: {
                Option<StructType> option;
                try {
                    option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
                }
                catch (Exception e) {
                    throw new DetailException(e, stage){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                optionSchema = option;
                CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
                try {
                    if (arcContext.isStreaming()) {
                        Option<StructType> option2 = optionSchema;
                        if (!(option2 instanceof Some)) {
                            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                            throw new Exception("ParquetExtract requires 'schemaURI' or 'schemaView' to be set if Arc is running in streaming mode.");
                        }
                        Some some = (Some)option2;
                        StructType schema = (StructType)some.value();
                        Option<API.Watermark> option3 = stage.watermark();
                        if (option3 instanceof Some) {
                            Some some2 = (Some)option3;
                            API.Watermark watermark = (API.Watermark)some2.value();
                            right = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).format("parquet").load(stage.input()).withWatermark(watermark.eventTime(), watermark.delayThreshold()));
                            break block32;
                        } else {
                            if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                            right = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).format("parquet").load(stage.input()));
                        }
                        break block32;
                    }
                    Option<String> option4 = stage.basePath();
                    if (option4 instanceof Some) {
                        Some some = (Some)option4;
                        String basePath = (String)some.value();
                        right = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "true").option("basePath", basePath).format("parquet").load(stage.input()));
                    } else {
                        if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                        right = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "true").format("parquet").load(stage.input()));
                    }
                }
                catch (Throwable throwable) {
                    boolean bl = false;
                    AnalysisException analysisException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof AnalysisException) {
                        bl = true;
                        analysisException = (AnalysisException)throwable2;
                        if (analysisException.getMessage().contains("Unable to infer schema for Parquet")) {
                            right = package$.MODULE$.Left().apply((Object)new API.FileNotFoundExtractError((Option<String>)Option$.MODULE$.apply((Object)stage.input())));
                        }
                    }
                    if (bl && analysisException.getMessage().contains("Path does not exist")) {
                        right = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)Option$.MODULE$.apply((Object)stage.input())));
                    }
                    if (!(throwable2 instanceof Exception)) throw throwable;
                    Exception exception = (Exception)throwable2;
                    throw new DetailException(exception, stage){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
            }
            Right df = right;
            try {
                Right right2 = df;
                if (right2 instanceof Right) {
                    Right right3 = right2;
                    Dataset df2 = (Dataset)right3.value();
                    if (df2.schema().length() == 0) {
                        Option<StructType> option = optionSchema;
                        if (!(option instanceof Some)) {
                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                            throw new Exception(new API.EmptySchemaExtractError((Option<String>)new Some((Object)stage.input())).getMessage());
                        }
                        Some some = (Some)option;
                        StructType structType = (StructType)some.value();
                        dataset3 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                        break block33;
                    } else {
                        dataset3 = df2;
                    }
                    break block33;
                }
                if (!(right2 instanceof Left)) throw new MatchError((Object)right2);
                Left left = (Left)right2;
                Product error = (Product)left.value();
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option = optionSchema;
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new Exception(((API.ExtractError)error).getMessage());
                }
                Some some = (Some)option;
                StructType s = (StructType)some.value();
                dataset3 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), spark, arcContext);
        Option<StructType> option = optionSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema, spark, logger);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Option<Object> option5 = stage.numPartitions();
            if (option5 instanceof Some) {
                Some some = (Some)option5;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = enrichedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                dataset = enrichedDF;
            }
        } else {
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> enrichedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option6 = stage.numPartitions();
            if (option6 instanceof Some) {
                Some some = (Some)option6;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = enrichedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                dataset = repartitionedDF = enrichedDF.repartition((Seq)partitionCols);
            }
        }
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (repartitionedDF.isStreaming()) {
            boxedUnit = BoxedUnit.UNIT;
            return Option$.MODULE$.apply((Object)repartitionedDF);
        }
        stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
        stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
        stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
        if (stage.persist()) {
            spark.catalog().cacheTable(stage.outputView(), arcContext.storageLevel());
            boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            return Option$.MODULE$.apply((Object)repartitionedDF);
        }
        boxedUnit = BoxedUnit.UNIT;
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public ParquetExtractStage apply(ParquetExtract plugin, Option<String> id, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, String input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean contiguousIndex, Option<String> basePath, Option<API.Watermark> watermark) {
        return new ParquetExtractStage(plugin, id, name, description, schema, outputView, input, authentication, params, persist, numPartitions, partitionBy, contiguousIndex, basePath, watermark);
    }

    public Option<Tuple15<ParquetExtract, Option<String>, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, String, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<API.Watermark>>> unapply(ParquetExtractStage x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple15((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), (Object)x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ParquetExtractStage$() {
        MODULE$ = this;
    }
}

