/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.plugins.udf;

import ai.tripl.arc.api.API;
import ai.tripl.arc.plugins.udf.ARCPlugin;
import breeze.stats.distributions.Gaussian;
import breeze.stats.distributions.Gaussian$;
import breeze.stats.distributions.RandBasis;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import net.jpountz.lz4.LZ4FrameInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;

public final class ARCPlugin$ {
    public static ARCPlugin$ MODULE$;

    static {
        new ARCPlugin$();
    }

    public List<JsonNode> jsonPath(String value, String path) {
        if (value != null) {
            if (!path.startsWith("$")) {
                throw new Exception(new StringBuilder(28).append("path '").append(path).append("' must start with '$'.").toString());
            }
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(value);
            JsonNode node = rootNode.at(path.substring(1).replace(".", "/"));
            String string = node.getNodeType().toString();
            String string2 = "ARRAY";
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new Exception(new StringBuilder(33).append("value at '").append(path).append("' must be 'array' type.").toString());
            }
            return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)node).asScala()).toList();
        }
        return null;
    }

    public double[] getJSONDoubleArray(String value, String path) {
        Option option = Option$.MODULE$.apply((Object)value);
        if (option instanceof Some) {
            Some some = (Some)option;
            String value2 = (String)some.value();
            List<JsonNode> node = this.jsonPath(value2, path);
            return (double[])((TraversableOnce)node.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.asDouble()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError((Object)option);
    }

    public int[] getJSONIntArray(String value, String path) {
        if (value != null) {
            List<JsonNode> node = this.jsonPath(value, path);
            return (int[])((TraversableOnce)node.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.asInt()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        }
        return null;
    }

    public long[] getJSONLongArray(String value, String path) {
        if (value != null) {
            List<JsonNode> node = this.jsonPath(value, path);
            return (long[])((TraversableOnce)node.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.asLong()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        }
        return null;
    }

    public double getRandom() {
        return Random$.MODULE$.nextDouble();
    }

    public String[] structKeys(Row value) {
        if (value != null) {
            return value.schema().fieldNames();
        }
        return null;
    }

    public byte[] getURI(String value, SparkSession spark, API.ARCContext arcContext) {
        if (value != null) {
            Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getURIFilenameArray(value, spark, arcContext))).head();
            if (tuple2 != null) {
                byte[] byteArray = (byte[])tuple2._1();
                return byteArray;
            }
            throw new MatchError((Object)tuple2);
        }
        return null;
    }

    public byte[][] getURIArray(String value, SparkSession spark, API.ARCContext arcContext) {
        if (value != null) {
            return (byte[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getURIFilenameArray(value, spark, arcContext))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    byte[] byteArray = (byte[])tuple2._1();
                    return byteArray;
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
        }
        return null;
    }

    public Tuple2<byte[], String>[] getURIFilenameArray(String uri, SparkSession spark, API.ARCContext arcContext) {
        ARCPlugin.URIInputStream[] uRIInputStreamArray;
        block11: {
            String string;
            String string2 = uri;
            if (string2 != null && ((string = string2).startsWith("http") || string.startsWith("https"))) {
                try (CloseableHttpClient client = HttpClients.createDefault();){
                    HttpGet httpGet = new HttpGet(string);
                    try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);){
                        int statusCode = response.getStatusLine().getStatusCode();
                        String reasonPhrase = response.getStatusLine().getReasonPhrase();
                        if (statusCode != 200) {
                            throw new Exception(new StringBuilder(68).append("Expected StatusCode = 200 when GET '").append(string).append("' but server responded with ").append(statusCode).append(" (").append(reasonPhrase).append(").").toString());
                        }
                        uRIInputStreamArray = (ARCPlugin.URIInputStream[])((Object[])new ARCPlugin.URIInputStream[]{new ARCPlugin.URIInputStream(string, new ByteArrayInputStream(IOUtils.toByteArray((InputStream)response.getEntity().getContent())))});
                        break block11;
                    }
                }
            }
            Configuration hadoopConf = arcContext.serializableConfiguration().value();
            Path path = new Path(uri);
            FileSystem fs = path.getFileSystem(hadoopConf);
            FileStatus[] globStatus = fs.globStatus(path);
            int n = globStatus.length;
            switch (n) {
                case 0: {
                    throw new Exception(new StringBuilder(25).append("no files found for uri '").append(uri).append("'").toString());
                }
            }
            uRIInputStreamArray = (ARCPlugin.URIInputStream[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])globStatus)).map((Function1 & Serializable & scala.Serializable)fileStatus -> new ARCPlugin.URIInputStream(fileStatus.getPath().toString(), (InputStream)fs.open(fileStatus.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ARCPlugin.URIInputStream.class)));
        }
        ARCPlugin.URIInputStream[] uriInputStreams = uRIInputStreamArray;
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uriInputStreams)).map((Function1 & Serializable & scala.Serializable)uriInputStream -> new Tuple2((Object)IOUtils.toByteArray((InputStream)MODULE$.compressedInputStream((ARCPlugin.URIInputStream)uriInputStream, spark, arcContext)), (Object)uriInputStream.path()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public InputStream compressedInputStream(ARCPlugin.URIInputStream uriInputStream, SparkSession spark, API.ARCContext arcContext) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = uriInputStream.path();
        if (string5 != null && ((string4 = string5).endsWith(".gzip") || string4.endsWith(".gz"))) {
            return new GZIPInputStream(uriInputStream.inputStream());
        }
        if (string5 != null && ((string3 = string5).endsWith(".bzip2") || string3.endsWith(".bz2"))) {
            return new BZip2CompressorInputStream(uriInputStream.inputStream());
        }
        if (string5 != null && (string2 = string5).endsWith(".deflate")) {
            return new DeflaterInputStream(uriInputStream.inputStream());
        }
        if (string5 != null && (string = string5).endsWith(".lz4")) {
            return new LZ4FrameInputStream(uriInputStream.inputStream());
        }
        return uriInputStream.inputStream();
    }

    public double probit(double value) {
        double x$1 = 0.0;
        double x$2 = 1.0;
        RandBasis x$3 = Gaussian$.MODULE$.apply$default$3(x$1, x$2);
        return new Gaussian(x$1, x$2, x$3).inverseCdf(value);
    }

    public double probnorm(double value) {
        double x$1 = 0.0;
        double x$2 = 1.0;
        RandBasis x$3 = Gaussian$.MODULE$.apply$default$3(x$1, x$2);
        return new Gaussian(x$1, x$2, x$3).cdf(value);
    }

    private ARCPlugin$() {
        MODULE$ = this;
    }
}

