/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.transform;

import ai.tripl.arc.api.API;
import ai.tripl.arc.config.Error;
import ai.tripl.arc.transform.Typing$;
import ai.tripl.arc.transform.TypingTransform;
import ai.tripl.arc.transform.TypingTransformStage;
import ai.tripl.arc.util.ArcSchema$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.util.LongAccumulator;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TypingTransformStage$
implements scala.Serializable {
    public static TypingTransformStage$ MODULE$;

    static {
        new TypingTransformStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(TypingTransformStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        List list;
        Either<String, List<API.ExtractColumn>> either = stage.schema();
        if (either instanceof Right) {
            Right right = (Right)either;
            List cols = (List)right.value();
            List list2 = cols;
            if (Nil$.MODULE$.equals(list2)) {
                throw new DetailException(stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            list = list2;
        } else {
            if (!(either instanceof Left)) throw new MatchError(either);
            Left left = (Left)either;
            String view = (String)left.value();
            Either<List<Error.StageError>, List<API.ExtractColumn>> parseResult = ArcSchema$.MODULE$.parseArcSchemaDataFrame((Dataset<Row>)spark.table(view), logger);
            Either<List<Error.StageError>, List<API.ExtractColumn>> either2 = parseResult;
            if (either2 instanceof Right) {
                List cols;
                Right right = (Right)either2;
                list = cols = (List)right.value();
            } else {
                if (!(either2 instanceof Left)) throw new MatchError(either2);
                Left left2 = (Left)either2;
                List errors = (List)left2.value();
                throw new DetailException(view, errors, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        List cols = list;
        stage.stageDetail().put((Object)"columns", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)cols.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.name(), List$.MODULE$.canBuildFrom())).asJava());
        Dataset df = spark.table(stage.inputView());
        int inputColumnCount = ((SeqLike)df.schema().filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)TypingTransformStage$.$anonfun$execute$2(row)))).length();
        if (inputColumnCount != cols.length()) {
            stage.stageDetail().put((Object)"schemaColumnCount", (Object)cols.length());
            stage.stageDetail().put((Object)"inputColumnCount", (Object)inputColumnCount);
            throw new DetailException(cols, inputColumnCount, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        LongAccumulator valueAccumulator = spark.sparkContext().longAccumulator();
        LongAccumulator errorAccumulator = spark.sparkContext().longAccumulator();
        try {
            dataset2 = Typing$.MODULE$.typeDataFrame((Dataset<Row>)df, (List<API.ExtractColumn>)cols, stage.failMode(), valueAccumulator, errorAccumulator, spark, logger);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset transformedDF = dataset2;
        List<String> list3 = stage.partitionBy();
        if (Nil$.MODULE$.equals(list3)) {
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = transformedDF.repartition(numPartitions);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                dataset = transformedDF;
            }
        } else {
            List partitionCols = (List)list3.map((Function1 & Serializable & scala.Serializable)col -> transformedDF.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset = transformedDF.repartition(numPartitions, (Seq)partitionCols);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                dataset = transformedDF.repartition((Seq)partitionCols);
            }
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                spark.catalog().cacheTable(stage.outputView(), arcContext.storageLevel());
                stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                stage.stageDetail().put((Object)"values", (Object)Predef$.MODULE$.Long2long(valueAccumulator.value()));
                boxedUnit = stage.stageDetail().put((Object)"errors", (Object)Predef$.MODULE$.Long2long(errorAccumulator.value()));
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public TypingTransformStage apply(TypingTransform plugin, Option<String> id, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String inputView, String outputView, scala.collection.immutable.Map<String, String> params, boolean persist, API.FailMode failMode, Option<Object> numPartitions, List<String> partitionBy) {
        return new TypingTransformStage(plugin, id, name, description, schema, inputView, outputView, params, persist, failMode, numPartitions, partitionBy);
    }

    public Option<Tuple12<TypingTransform, Option<String>, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, String, scala.collection.immutable.Map<String, String>, Object, API.FailMode, Option<Object>, List<String>>> unapply(TypingTransformStage x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple12((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.inputView(), (Object)x$0.outputView(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), (Object)x$0.failMode(), x$0.numPartitions(), x$0.partitionBy()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(StructField row) {
        return !row.metadata().contains("internal") || row.metadata().contains("internal") && !row.metadata().getBoolean("internal");
    }

    private TypingTransformStage$() {
        MODULE$ = this;
    }
}

