/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.load;

import ai.tripl.arc.api.API;
import ai.tripl.arc.load.AvroLoad;
import ai.tripl.arc.load.AvroLoadStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ListenerUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple11;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;

public final class AvroLoadStage$
implements scala.Serializable {
    public static AvroLoadStage$ MODULE$;

    static {
        new AvroLoadStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(AvroLoadStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset dataset;
        Dataset dataset2;
        Dataset df = spark.table(stage.inputView());
        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
        Seq nulls = (Seq)((TraversableLike)df.schema().filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)AvroLoadStage$.$anonfun$execute$1(x$18)))).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.name(), Seq$.MODULE$.canBuildFrom());
        if (!nulls.isEmpty()) {
            HashMap<String, Object> dropMap = new HashMap<String, Object>();
            dropMap.put("NullType", JavaConverters$.MODULE$.seqAsJavaListConverter(nulls).asJava());
            if (!arcContext.dropUnsupported()) throw new Exception(new StringBuilder(101).append("inputView '").append(stage.inputView()).append("' contains types ").append(new ObjectMapper().writeValueAsString(dropMap)).append(" which are unsupported by AvroLoad and 'dropUnsupported' is set to false.").toString());
            stage.stageDetail().put((Object)"drop", dropMap);
            dataset2 = df.drop(nulls);
        } else {
            dataset2 = df;
        }
        Dataset nonNullDF = dataset2;
        SparkListener listener = ListenerUtils$.MODULE$.addStageCompletedListener(stage.stageDetail(), spark, logger);
        try {
            Dataset dataset3;
            List<String> list = stage.partitionBy();
            if (Nil$.MODULE$.equals(list)) {
                Dataset dfToWrite = (Dataset)stage.numPartitions().map((Function1 & Serializable & scala.Serializable)x$20 -> nonNullDF.repartition(BoxesRunTime.unboxToInt((Object)x$20))).getOrElse((Function0 & Serializable & scala.Serializable)() -> nonNullDF);
                dfToWrite.write().mode(stage.saveMode()).format("avro").save(stage.outputURI().toString());
                dataset3 = dfToWrite;
            } else {
                Dataset dataset4;
                List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> df.apply(col), List$.MODULE$.canBuildFrom());
                Option<Object> option = stage.numPartitions();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n = BoxesRunTime.unboxToInt((Object)some.value());
                    Dataset dfToWrite = nonNullDF.repartition(n, (Seq)partitionCols);
                    dfToWrite.write().partitionBy(list).mode(stage.saveMode()).format("avro").save(stage.outputURI().toString());
                    dataset4 = dfToWrite;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    Dataset dfToWrite = nonNullDF.repartition((Seq)partitionCols);
                    dfToWrite.write().partitionBy(list).mode(stage.saveMode()).format("avro").save(stage.outputURI().toString());
                    dataset4 = dfToWrite;
                }
                dataset3 = dataset4;
            }
            dataset = dataset3;
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset outputDF = dataset;
        spark.sparkContext().removeSparkListener((SparkListenerInterface)listener);
        return Option$.MODULE$.apply((Object)outputDF);
    }

    public AvroLoadStage apply(AvroLoad plugin, Option<String> id, String name, Option<String> description, String inputView, URI outputURI, List<String> partitionBy, Option<Object> numPartitions, Option<API.Authentication> authentication, SaveMode saveMode, scala.collection.immutable.Map<String, String> params) {
        return new AvroLoadStage(plugin, id, name, description, inputView, outputURI, partitionBy, numPartitions, authentication, saveMode, params);
    }

    public Option<Tuple11<AvroLoad, Option<String>, String, Option<String>, String, URI, List<String>, Option<Object>, Option<API.Authentication>, SaveMode, scala.collection.immutable.Map<String, String>>> unapply(AvroLoadStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.outputURI(), x$0.partitionBy(), x$0.numPartitions(), x$0.authentication(), (Object)x$0.saveMode(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(StructField x$18) {
        DataType dataType = x$18.dataType();
        NullType$ nullType$ = NullType$.MODULE$;
        return !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null);
    }

    private AvroLoadStage$() {
        MODULE$ = this;
    }
}

