/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.load;

import ai.tripl.arc.api.API;
import ai.tripl.arc.load.TextLoad;
import ai.tripl.arc.load.TextLoadStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.SerializableConfiguration;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.util.CollectionAccumulator;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple15;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TextLoadStage$
implements scala.Serializable {
    public static TextLoadStage$ MODULE$;
    private final Tuple2<String, StringType$>[] validValueFilename;
    private final Tuple2<String, AtomicType>[] validValueFilenameIndex;

    static {
        new TextLoadStage$();
    }

    public Option<Dataset<Row>> execute(TextLoadStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset df;
        block14: {
            String signature = "TextLoad requires input [value: string], [value: string, filename: string] or [value: string, filename: string, index: integer] signature when in singleFile mode.";
            Option<URI> stageOutputURI = stage.outputURI();
            String stagePrefix = stage.prefix();
            String stageSeparator = stage.separator();
            String stageSuffix = stage.suffix();
            SaveMode stageSaveMode = stage.saveMode();
            SerializableConfiguration contextSerializableConfiguration = arcContext.serializableConfiguration();
            df = spark.table(stage.inputView());
            CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
            try {
                BoxedUnit boxedUnit;
                block19: {
                    block18: {
                        block15: {
                            Dataset repartitionedDF;
                            block17: {
                                block16: {
                                    if (!stage.singleFile()) break block15;
                                    if (df.schema().length() != 1) break block16;
                                    DataType dataType = df.schema().fields()[0].dataType();
                                    StringType$ stringType$ = StringType$.MODULE$;
                                    if (!(dataType == null ? stringType$ != null : !dataType.equals(stringType$))) break block17;
                                }
                                if (!(df.schema().length() == 2 && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)TextLoadStage$.$anonfun$execute$2(field))) || df.schema().length() == 3 && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)TextLoadStage$.$anonfun$execute$4(field))))) {
                                    throw new Exception(new StringBuilder(8).append(signature).append(" Got [").append(((TraversableOnce)df.schema().map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(2).append(f.name()).append(": ").append(f.dataType().simpleString()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("].").toString());
                                }
                            }
                            boolean hasFilename = df.schema().length() == 2 || df.schema().length() == 3;
                            boolean hasIndex = df.schema().length() == 3;
                            Dataset dataset = repartitionedDF = hasFilename ? df.repartition(stage.singleFileNumPartitions(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("filename")})) : df.repartition(1);
                            if (!hasFilename && stageOutputURI.isEmpty()) {
                                throw new Exception("TextLoad requires 'outputURI' to be set if in 'singleFile' mode and no 'filename' column exists.");
                            }
                            CollectionAccumulator outputFileAccumulator = spark.sparkContext().collectionAccumulator();
                            repartitionedDF.foreachPartition((Function1 & Serializable & scala.Serializable)partition -> {
                                TextLoadStage$.$anonfun$execute$6(contextSerializableConfiguration, hasFilename, hasIndex, stageOutputURI, stageSaveMode, stagePrefix, stageSeparator, stageSuffix, outputFileAccumulator, partition);
                                return BoxedUnit.UNIT;
                            });
                            boxedUnit = stage.stageDetail().put((Object)"outputFiles", JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(outputFileAccumulator.value()).asScala()).toSet().toSeq()).asJava());
                            break block14;
                        }
                        if (df.schema().length() != 1) break block18;
                        DataType dataType = df.schema().fields()[0].dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if (!(dataType == null ? stringType$ != null : !dataType.equals(stringType$))) break block19;
                    }
                    throw new DetailException(df, stage){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                Option<Object> option = stage.numPartitions();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n = BoxesRunTime.unboxToInt((Object)some.value());
                    df.repartition(n).write().mode(stage.saveMode()).text(((URI)stage.outputURI().get()).toString());
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    df.write().mode(stage.saveMode()).text(((URI)stage.outputURI().get()).toString());
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        return Option$.MODULE$.apply((Object)df);
    }

    public Tuple2<String, StringType$>[] validValueFilename() {
        return this.validValueFilename;
    }

    public Tuple2<String, AtomicType>[] validValueFilenameIndex() {
        return this.validValueFilenameIndex;
    }

    public TextLoadStage apply(TextLoad plugin, Option<String> id, String name, Option<String> description, String inputView, Option<URI> outputURI, Option<Object> numPartitions, Option<API.Authentication> authentication, SaveMode saveMode, scala.collection.immutable.Map<String, String> params, boolean singleFile, String prefix, String separator, String suffix, int singleFileNumPartitions) {
        return new TextLoadStage(plugin, id, name, description, inputView, outputURI, numPartitions, authentication, saveMode, params, singleFile, prefix, separator, suffix, singleFileNumPartitions);
    }

    public Option<Tuple15<TextLoad, Option<String>, String, Option<String>, String, Option<URI>, Option<Object>, Option<API.Authentication>, SaveMode, scala.collection.immutable.Map<String, String>, Object, String, String, String, Object>> unapply(TextLoadStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), x$0.outputURI(), x$0.numPartitions(), x$0.authentication(), (Object)x$0.saveMode(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.singleFile()), (Object)x$0.prefix(), (Object)x$0.separator(), (Object)x$0.suffix(), (Object)BoxesRunTime.boxToInteger((int)x$0.singleFileNumPartitions())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(Tuple2 field) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.validValueFilename())).contains((Object)field);
    }

    public static final /* synthetic */ boolean $anonfun$execute$4(Tuple2 field) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.validValueFilenameIndex())).contains((Object)field);
    }

    public static final /* synthetic */ void $anonfun$execute$6(SerializableConfiguration contextSerializableConfiguration$1, boolean hasFilename$1, boolean hasIndex$1, Option stageOutputURI$1, SaveMode stageSaveMode$1, String stagePrefix$1, String stageSeparator$1, String stageSuffix$1, CollectionAccumulator outputFileAccumulator$1, Iterator partition) {
        block8: {
            Option outputStream;
            Option option;
            if (!partition.hasNext()) break block8;
            Configuration hadoopConf = contextSerializableConfiguration$1.value();
            BufferedIterator bufferedPartition = partition.buffered();
            Row firstRow = (Row)bufferedPartition.head();
            int valueIndex = hasFilename$1 ? firstRow.fieldIndex("value") : 0;
            int indexIndex = hasIndex$1 ? firstRow.fieldIndex("index") : 0;
            Path path = hasFilename$1 ? new Path(new URI(firstRow.getString(firstRow.fieldIndex("filename")))) : new Path((URI)stageOutputURI$1.get());
            FileSystem fs = path.getFileSystem(hadoopConf);
            if (fs.exists(path)) {
                SaveMode saveMode = stageSaveMode$1;
                if (SaveMode.ErrorIfExists.equals(saveMode)) {
                    throw new Exception(new StringBuilder(80).append("File '").append(path.toString()).append("' already exists and 'saveMode' equals 'ErrorIfExists' so cannot continue.").toString());
                }
                Object object = SaveMode.Overwrite.equals(saveMode) ? Option$.MODULE$.apply((Object)fs.create(path, true)) : (SaveMode.Append.equals(saveMode) ? Option$.MODULE$.apply((Object)fs.append(path)) : None$.MODULE$);
                option = object;
            } else {
                option = Option$.MODULE$.apply((Object)fs.create(path));
            }
            Option option2 = outputStream = option;
            if (option2 instanceof Some) {
                BufferedIterator iterator;
                Some some = (Some)option2;
                FSDataOutputStream os = (FSDataOutputStream)some.value();
                os.writeBytes(stagePrefix$1);
                Object object = iterator = hasIndex$1 ? ((IterableLike)bufferedPartition.toSeq().sortBy((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)row.getInt(indexIndex)), (Ordering)Ordering.Int$.MODULE$)).toIterator() : bufferedPartition;
                while (iterator.hasNext()) {
                    os.writeBytes(((Row)iterator.next()).getString(valueIndex));
                    if (!iterator.hasNext()) continue;
                    os.writeBytes(stageSeparator$1);
                }
                os.writeBytes(stageSuffix$1);
                os.close();
                outputFileAccumulator$1.add((Object)path.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option2)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option2);
            }
            fs.close();
        }
    }

    private TextLoadStage$() {
        MODULE$ = this;
        this.validValueFilename = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)"value", (Object)StringType$.MODULE$), new Tuple2((Object)"filename", (Object)StringType$.MODULE$)});
        this.validValueFilenameIndex = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)"value", (Object)StringType$.MODULE$), new Tuple2((Object)"filename", (Object)StringType$.MODULE$), new Tuple2((Object)"index", (Object)IntegerType$.MODULE$)});
    }
}

