/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.execute;

import ai.tripl.arc.api.API;
import ai.tripl.arc.execute.LogExecute;
import ai.tripl.arc.execute.LogExecuteStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple8;
import scala.collection.mutable.Map;

public final class LogExecuteStage$
implements Serializable {
    public static LogExecuteStage$ MODULE$;

    static {
        new LogExecuteStage$();
    }

    public Option<Dataset<Row>> execute(LogExecuteStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset dataset;
        String signature = "LogExecute requires query to return 1 row with [message: string] signature.";
        String stmt = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)stmt);
        try {
            dataset = spark.sql(stmt);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset df = dataset;
        long count = df.persist(arcContext.storageLevel()).count();
        if (df.count() != 1L || df.schema().length() != 1) {
            throw new DetailException(signature, count, df, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        try {
            Option option;
            Row row = (Row)df.first();
            boolean messageIsNull = row.isNullAt(0);
            if (messageIsNull) {
                throw new DetailException(signature, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            String message = row.getString(0);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                HashMap messageMap = new HashMap();
                messageMap = (HashMap)objectMapper.readValue(message, HashMap.class);
                option = stage.stageDetail().put((Object)"message", (Object)messageMap);
            }
            catch (Exception e) {
                try {
                    ArrayList messageArray = new ArrayList();
                    messageArray = (ArrayList)objectMapper.readValue(message, ArrayList.class);
                    option = stage.stageDetail().put((Object)"message", (Object)messageArray);
                }
                catch (Exception e2) {
                    option = stage.stageDetail().put((Object)"message", (Object)message);
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassCastException) {
                throw new DetailException(signature, count, df, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            if (throwable2 instanceof Exception && throwable2 instanceof DetailException) {
                Exception exception = (Exception)throwable2;
                throw exception;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            throw throwable;
        }
        df.unpersist();
        return Option$.MODULE$.apply((Object)df);
    }

    public LogExecuteStage apply(LogExecute plugin, Option<String> id, String name, Option<String> description, URI inputURI, String sql, scala.collection.immutable.Map<String, String> sqlParams, scala.collection.immutable.Map<String, String> params) {
        return new LogExecuteStage(plugin, id, name, description, inputURI, sql, sqlParams, params);
    }

    public Option<Tuple8<LogExecute, Option<String>, String, Option<String>, URI, String, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> unapply(LogExecuteStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputURI(), (Object)x$0.sql(), x$0.sqlParams(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LogExecuteStage$() {
        MODULE$ = this;
    }
}

