/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.TextExtract;
import ai.tripl.arc.extract.TextExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.ExtractUtils$;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple15;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TextExtractStage$
implements scala.Serializable {
    public static TextExtractStage$ MODULE$;

    static {
        new TextExtractStage$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Dataset<Row>> execute(TextExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        Dataset dataset3;
        Left left;
        Option<StructType> optionSchema;
        block38: {
            Option<StructType> option;
            String signature = "TextExtract requires 'inputView' to be dataset with [value: string] signature.";
            try {
                option = ExtractUtils$.MODULE$.getSchema(stage.schema(), spark, logger);
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            optionSchema = option;
            CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
            try {
                String string;
                Either<String, String> either = stage.input();
                if (either instanceof Left) {
                    Left left2 = (Left)either;
                    String view = (String)left2.value();
                    Dataset inputView = spark.table(view);
                    StructType schema = inputView.schema();
                    int fieldIndex = TextExtractStage$.liftedTree1$1(schema, signature, inputView, stage);
                    DataType dataType = schema.fields()[fieldIndex].dataType();
                    if (!(dataType instanceof StringType)) {
                        throw new DetailException(signature, schema, fieldIndex, stage){
                            private final Map<String, Object> detail;

                            public Map<String, Object> detail() {
                                return this.detail;
                            }
                            {
                                this.detail = stage$2.stageDetail();
                            }
                        };
                    }
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputView.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("value")})).collect())).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
                } else {
                    String glob;
                    if (!(either instanceof Right)) throw new MatchError(either);
                    Right right = (Right)either;
                    string = glob = (String)right.value();
                }
                String path = string;
                if (arcContext.isStreaming()) {
                    Right right;
                    Option<StructType> option2 = optionSchema;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        StructType schema = (StructType)some.value();
                        Option<API.Watermark> option3 = stage.watermark();
                        if (option3 instanceof Some) {
                            Some some2 = (Some)option3;
                            API.Watermark watermark = (API.Watermark)some2.value();
                            right = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).text(path).withWatermark(watermark.eventTime(), watermark.delayThreshold()));
                        } else {
                            if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                            right = package$.MODULE$.Right().apply((Object)spark.readStream().option("mergeSchema", "true").schema(schema).text(path));
                        }
                    } else {
                        if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                        throw new Exception("TextExtract requires 'schemaURI' to be set if Arc is running in streaming mode.");
                    }
                    Right right2 = right;
                    left = right2;
                    break block38;
                }
                try {
                    Right right;
                    if (stage.multiLine()) {
                        Right right3;
                        Option<String> option4 = stage.basePath();
                        if (option4 instanceof Some) {
                            Some some = (Some)option4;
                            String basePath = (String)some.value();
                            right3 = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "true").option("basePath", basePath).textFile(path).toDF());
                        } else {
                            if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                            right3 = package$.MODULE$.Right().apply((Object)spark.read().option("wholetext", "true").textFile(path).toDF());
                        }
                        left = right3;
                        break block38;
                    }
                    Option<String> option5 = stage.basePath();
                    if (option5 instanceof Some) {
                        Some some = (Some)option5;
                        String basePath = (String)some.value();
                        right = package$.MODULE$.Right().apply((Object)spark.read().option("mergeSchema", "false").option("basePath", basePath).textFile(path).toDF());
                    } else {
                        if (!None$.MODULE$.equals(option5)) throw new MatchError(option5);
                        right = package$.MODULE$.Right().apply((Object)spark.read().option("wholetext", "false").textFile(path).toDF());
                    }
                    left = right;
                }
                catch (Throwable throwable) {
                    AnalysisException analysisException;
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof AnalysisException) || !(analysisException = (AnalysisException)throwable2).getMessage().contains("Path does not exist")) {
                        if (!(throwable2 instanceof Exception)) throw throwable;
                        Exception exception = (Exception)throwable2;
                        throw exception;
                    }
                    Left left3 = package$.MODULE$.Left().apply((Object)new API.PathNotExistsExtractError((Option<String>)Option$.MODULE$.apply((Object)path)));
                    left = left3;
                }
            }
            catch (Exception e) {
                throw new DetailException(e, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        Left df = left;
        try {
            Dataset dataset4;
            Left left4 = df;
            if (left4 instanceof Right) {
                Dataset dataset5;
                Right right = (Right)left4;
                Dataset df2 = (Dataset)right.value();
                if (df2.schema().length() == 0) {
                    Option<StructType> option = optionSchema;
                    if (!(option instanceof Some)) {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        throw new Exception(new API.EmptySchemaExtractError((Option<String>)None$.MODULE$).getMessage());
                    }
                    Some some = (Some)option;
                    StructType structType = (StructType)some.value();
                    Dataset dataset6 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), structType);
                    dataset5 = dataset6;
                } else {
                    dataset5 = df2;
                }
                dataset4 = dataset5;
            } else {
                if (!(left4 instanceof Left)) throw new MatchError((Object)left4);
                Left left5 = left4;
                API.PathNotExistsExtractError error = (API.PathNotExistsExtractError)left5.value();
                stage.stageDetail().put((Object)"records", (Object)0);
                Option<StructType> option = optionSchema;
                if (!(option instanceof Some)) {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new Exception(error.getMessage());
                }
                Some some = (Some)option;
                StructType s = (StructType)some.value();
                Dataset dataset7 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), s);
                dataset4 = dataset7;
            }
            dataset3 = dataset4;
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset emptyDataframeHandlerDF = dataset3;
        Dataset sourceEnrichedDF = ExtractUtils$.MODULE$.addInternalColumns((Dataset<Row>)emptyDataframeHandlerDF, stage.contiguousIndex(), spark, arcContext);
        Option<StructType> option = optionSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            StructType schema = (StructType)some.value();
            dataset2 = MetadataUtils$.MODULE$.setMetadata(sourceEnrichedDF, schema, spark, logger);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            dataset2 = sourceEnrichedDF;
        }
        Dataset enrichedDF = dataset2;
        Option<Object> option6 = stage.numPartitions();
        if (option6 instanceof Some) {
            Some some = (Some)option6;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            dataset = enrichedDF.repartition(numPartitions);
        } else {
            if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
            dataset = enrichedDF;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                repartitionedDF.persist(arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
                return Option$.MODULE$.apply((Object)repartitionedDF);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Option$.MODULE$.apply((Object)repartitionedDF);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public TextExtractStage apply(TextExtract plugin, Option<String> id, String name, Option<String> description, Either<String, List<API.ExtractColumn>> schema, String outputView, Either<String, String> input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, boolean contiguousIndex, boolean multiLine, Option<String> basePath, Option<API.Watermark> watermark) {
        return new TextExtractStage(plugin, id, name, description, schema, outputView, input, authentication, params, persist, numPartitions, contiguousIndex, multiLine, basePath, watermark);
    }

    public Option<Tuple15<TextExtract, Option<String>, String, Option<String>, Either<String, List<API.ExtractColumn>>, String, Either<String, String>, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, Object, Object, Option<String>, Option<API.Watermark>>> unapply(TextExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), x$0.schema(), (Object)x$0.outputView(), x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.contiguousIndex()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.multiLine()), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final /* synthetic */ int liftedTree1$1(StructType schema$1, String signature$1, Dataset inputView$1, TextExtractStage stage$2) {
        int n;
        try {
            n = schema$1.fieldIndex("value");
        }
        catch (Exception e) {
            throw new DetailException(signature$1, inputView$1, stage$2){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        return n;
    }

    private TextExtractStage$() {
        MODULE$ = this;
    }
}

