/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.validate;

import ai.tripl.arc.api.API;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.MetadataUtils$;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import ai.tripl.arc.validate.MetadataValidate;
import ai.tripl.arc.validate.MetadataValidateStage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple9;
import scala.collection.mutable.Map;

public final class MetadataValidateStage$
implements Serializable {
    public static MetadataValidateStage$ MODULE$;

    static {
        new MetadataValidateStage$();
    }

    public Option<Dataset<Row>> execute(MetadataValidateStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset dataset;
        String signature = "MetadataValidate requires query to return 1 row with [outcome: boolean, message: string] signature.";
        String stmt = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)stmt);
        Dataset inputDF = spark.table(stage.inputView());
        Dataset<Row> metadataSchemaDF = MetadataUtils$.MODULE$.createMetadataDataframe((Dataset<Row>)inputDF, spark, logger);
        metadataSchemaDF.createOrReplaceTempView("metadata");
        try {
            dataset = spark.sql(stmt);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset df = dataset;
        long count = df.persist(arcContext.storageLevel()).count();
        if (df.count() != 1L || df.schema().length() != 2) {
            throw new DetailException(signature, count, df, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        try {
            Option option;
            Row row = (Row)df.first();
            boolean resultIsNull = row.isNullAt(0);
            boolean messageIsNull = row.isNullAt(1);
            if (resultIsNull) {
                throw new DetailException(signature, messageIsNull, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            String message = row.getString(1);
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                option = stage.stageDetail().put((Object)"message", objectMapper.readValue(message, HashMap.class));
            }
            catch (Exception e) {
                option = stage.stageDetail().put((Object)"message", (Object)message);
            }
            boolean result = row.getBoolean(0);
            if (!result) {
                throw new DetailException(message, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassCastException) {
                throw new DetailException(signature, count, df, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            if (throwable2 instanceof Exception && throwable2 instanceof DetailException) {
                Exception exception = (Exception)throwable2;
                throw exception;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            throw throwable;
        }
        df.unpersist();
        return Option$.MODULE$.apply((Object)df);
    }

    public MetadataValidateStage apply(MetadataValidate plugin, Option<String> id, String name, Option<String> description, Option<URI> inputURI, String inputView, String sql, scala.collection.immutable.Map<String, String> sqlParams, scala.collection.immutable.Map<String, String> params) {
        return new MetadataValidateStage(plugin, id, name, description, inputURI, inputView, sql, sqlParams, params);
    }

    public Option<Tuple9<MetadataValidate, Option<String>, String, Option<String>, Option<URI>, String, String, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> unapply(MetadataValidateStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), x$0.inputURI(), (Object)x$0.inputView(), (Object)x$0.sql(), x$0.sqlParams(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MetadataValidateStage$() {
        MODULE$ = this;
    }
}

