/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.ImageExtract;
import ai.tripl.arc.extract.ImageExtractStage;
import ai.tripl.arc.util.CloudUtils$;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.log.logger.Logger;
import java.io.Serializable;
import org.apache.spark.ml.image.ImageSchema$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple14;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ImageExtractStage$
implements scala.Serializable {
    public static ImageExtractStage$ MODULE$;

    static {
        new ImageExtractStage$();
    }

    public Option<Dataset<Row>> execute(ImageExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset dataset2;
        CloudUtils$.MODULE$.setHadoopConfiguration(stage.authentication(), spark, logger, arcContext);
        try {
            if (arcContext.isStreaming()) {
                Dataset dataset3;
                Option<API.Watermark> option = stage.watermark();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    API.Watermark watermark = (API.Watermark)some.value();
                    dataset3 = spark.readStream().format("image").option("dropInvalid", stage.dropInvalid()).schema(ImageSchema$.MODULE$.imageSchema()).load(stage.input()).withWatermark(watermark.eventTime(), watermark.delayThreshold());
                } else if (None$.MODULE$.equals(option)) {
                    dataset3 = spark.readStream().format("image").option("dropInvalid", stage.dropInvalid()).schema(ImageSchema$.MODULE$.imageSchema()).load(stage.input());
                } else {
                    throw new MatchError(option);
                }
                dataset2 = dataset3;
            } else {
                Dataset dataset4;
                Option<String> option = stage.basePath();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String basePath = (String)some.value();
                    dataset4 = spark.read().format("image").option("dropInvalid", stage.dropInvalid()).option("basePath", basePath).load(stage.input());
                } else if (None$.MODULE$.equals(option)) {
                    dataset4 = spark.read().format("image").option("dropInvalid", stage.dropInvalid()).load(stage.input());
                } else {
                    throw new MatchError(option);
                }
                dataset2 = dataset4;
            }
        }
        catch (Throwable throwable) {
            AnalysisException analysisException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof AnalysisException) || !(analysisException = (AnalysisException)throwable2).getMessage().contains("Path does not exist")) {
                if (throwable2 instanceof Exception) {
                    Exception exception = (Exception)throwable2;
                    throw new DetailException(exception, stage){
                        private final Map<String, Object> detail;

                        public Map<String, Object> detail() {
                            return this.detail;
                        }
                        {
                            this.detail = stage$2.stageDetail();
                        }
                    };
                }
                throw throwable;
            }
            Dataset dataset5 = spark.createDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class)), ImageSchema$.MODULE$.imageSchema());
            dataset2 = dataset5;
        }
        Dataset df = dataset2;
        List<String> list = stage.partitionBy();
        if (Nil$.MODULE$.equals(list)) {
            Dataset dataset6;
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset6 = df.repartition(numPartitions);
            } else if (None$.MODULE$.equals(option)) {
                dataset6 = df;
            } else {
                throw new MatchError(option);
            }
            dataset = dataset6;
        } else {
            Dataset dataset7;
            List partitionCols = (List)list.map((Function1 & Serializable & scala.Serializable)col -> df.apply(col), List$.MODULE$.canBuildFrom());
            Option<Object> option = stage.numPartitions();
            if (option instanceof Some) {
                Some some = (Some)option;
                int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
                dataset7 = df.repartition(numPartitions, (Seq)partitionCols);
            } else if (None$.MODULE$.equals(option)) {
                dataset7 = df.repartition((Seq)partitionCols);
            } else {
                throw new MatchError(option);
            }
            dataset = dataset7;
        }
        Dataset repartitionedDF = dataset;
        if (arcContext.immutableViews()) {
            repartitionedDF.createTempView(stage.outputView());
        } else {
            repartitionedDF.createOrReplaceTempView(stage.outputView());
        }
        if (!repartitionedDF.isStreaming()) {
            stage.stageDetail().put((Object)"inputFiles", (Object)repartitionedDF.inputFiles().length);
            stage.stageDetail().put((Object)"outputColumns", (Object)repartitionedDF.schema().length());
            stage.stageDetail().put((Object)"numPartitions", (Object)repartitionedDF.rdd().partitions().length);
            if (stage.persist()) {
                spark.catalog().cacheTable(stage.outputView(), arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)repartitionedDF.count());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)repartitionedDF);
    }

    public ImageExtractStage apply(ImageExtract plugin, Option<String> id, String name, Option<String> description, String outputView, String input, Option<API.Authentication> authentication, scala.collection.immutable.Map<String, String> params, boolean persist, Option<Object> numPartitions, List<String> partitionBy, boolean dropInvalid, Option<String> basePath, Option<API.Watermark> watermark) {
        return new ImageExtractStage(plugin, id, name, description, outputView, input, authentication, params, persist, numPartitions, partitionBy, dropInvalid, basePath, watermark);
    }

    public Option<Tuple14<ImageExtract, Option<String>, String, Option<String>, String, String, Option<API.Authentication>, scala.collection.immutable.Map<String, String>, Object, Option<Object>, List<String>, Object, Option<String>, Option<API.Watermark>>> unapply(ImageExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple14((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.outputView(), (Object)x$0.input(), x$0.authentication(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.numPartitions(), x$0.partitionBy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.dropInvalid()), x$0.basePath(), x$0.watermark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ImageExtractStage$() {
        MODULE$ = this;
    }
}

