/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.validate;

import ai.tripl.arc.api.API;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import ai.tripl.arc.validate.SQLValidate;
import ai.tripl.arc.validate.SQLValidateStage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple8;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;

public final class SQLValidateStage$
implements Serializable {
    public static SQLValidateStage$ MODULE$;

    static {
        new SQLValidateStage$();
    }

    public Option<Dataset<Row>> execute(SQLValidateStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset dataset;
        String signature = "SQLValidate requires query to return 1 row with [outcome: boolean, message: string] signature.";
        String stmt = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)stmt);
        try {
            dataset = spark.sql(stmt);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset df = dataset;
        Row[] rows = (Row[])df.collect();
        if (rows.length != 1 || ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).head()).schema().length() != 2) {
            throw new DetailException(signature, rows, df, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        try {
            Option option;
            Row row = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).head();
            boolean resultIsNull = row.isNullAt(0);
            boolean messageIsNull = row.isNullAt(1);
            if (resultIsNull) {
                throw new DetailException(signature, messageIsNull, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            String message = row.getString(1);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                HashMap messageMap = new HashMap();
                messageMap = (HashMap)objectMapper.readValue(message, HashMap.class);
                option = stage.stageDetail().put((Object)"message", (Object)messageMap);
            }
            catch (Exception e) {
                try {
                    ArrayList messageArray = new ArrayList();
                    messageArray = (ArrayList)objectMapper.readValue(message, ArrayList.class);
                    option = stage.stageDetail().put((Object)"message", (Object)messageArray);
                }
                catch (Exception e2) {
                    option = stage.stageDetail().put((Object)"message", (Object)message);
                }
            }
            boolean result = row.getBoolean(0);
            if (!result) {
                throw new DetailException(message, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassCastException) {
                throw new DetailException(signature, rows, df, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            if (throwable2 instanceof Exception && throwable2 instanceof DetailException) {
                Exception exception = (Exception)throwable2;
                throw exception;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            throw throwable;
        }
        return Option$.MODULE$.apply((Object)df);
    }

    public SQLValidateStage apply(SQLValidate plugin, Option<String> id, String name, Option<String> description, Option<URI> inputURI, String sql, scala.collection.immutable.Map<String, String> sqlParams, scala.collection.immutable.Map<String, String> params) {
        return new SQLValidateStage(plugin, id, name, description, inputURI, sql, sqlParams, params);
    }

    public Option<Tuple8<SQLValidate, Option<String>, String, Option<String>, Option<URI>, String, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> unapply(SQLValidateStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), x$0.inputURI(), (Object)x$0.sql(), x$0.sqlParams(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SQLValidateStage$() {
        MODULE$ = this;
    }
}

