/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.execute;

import ai.tripl.arc.api.API;
import ai.tripl.arc.execute.ConfigExecute;
import ai.tripl.arc.execute.ConfigExecuteStage;
import ai.tripl.arc.util.DetailException;
import ai.tripl.arc.util.SQLUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple10;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConfigExecuteStage$
implements scala.Serializable {
    public static ConfigExecuteStage$ MODULE$;

    static {
        new ConfigExecuteStage$();
    }

    public Option<Dataset<Row>> execute(ConfigExecuteStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        Dataset dataset;
        String signature = "ConfigExecuteStage requires query to return 1 row with [message: string] signature.";
        String stmt = SQLUtils$.MODULE$.injectParameters(stage.sql(), stage.sqlParams(), false, logger);
        stage.stageDetail().put((Object)"sql", (Object)stmt);
        try {
            dataset = spark.sql(stmt);
        }
        catch (Exception e) {
            throw new DetailException(e, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        Dataset df = dataset;
        Row[] rows = (Row[])df.collect();
        if (rows.length != 1 || ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).head()).schema().length() != 1) {
            throw new DetailException(signature, rows, df, stage){
                private final Map<String, Object> detail;

                public Map<String, Object> detail() {
                    return this.detail;
                }
                {
                    this.detail = stage$2.stageDetail();
                }
            };
        }
        try {
            Row row = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).head();
            boolean messageIsNull = row.isNullAt(0);
            if (messageIsNull) {
                throw new DetailException(signature, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            String message = row.getString(0);
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap messageMap = (HashMap)objectMapper.readValue(message, HashMap.class);
            stage.stageDetail().put((Object)"message", (Object)messageMap);
            Config config = ConfigFactory.parseString((String)message, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF));
            arcContext.resolutionConfig_$eq(config.withFallback((ConfigMergeable)arcContext.resolutionConfig()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassCastException) {
                throw new DetailException(signature, rows, df, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            if (throwable2 instanceof Exception && throwable2 instanceof DetailException) {
                Exception exception = (Exception)throwable2;
                throw exception;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                throw new DetailException(exception, stage){
                    private final Map<String, Object> detail;

                    public Map<String, Object> detail() {
                        return this.detail;
                    }
                    {
                        this.detail = stage$2.stageDetail();
                    }
                };
            }
            throw throwable;
        }
        stage.outputView().foreach((Function1 & Serializable & scala.Serializable)outputView -> {
            BoxedUnit boxedUnit;
            if (arcContext.immutableViews()) {
                df.createTempView(outputView);
            } else {
                df.createOrReplaceTempView(outputView);
            }
            if (stage.persist()) {
                spark.catalog().cacheTable(outputView, arcContext.storageLevel());
                boxedUnit = stage.stageDetail().put((Object)"records", (Object)df.count());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return Option$.MODULE$.apply((Object)df);
    }

    public ConfigExecuteStage apply(ConfigExecute plugin, Option<String> id, String name, Option<String> description, URI inputURI, Option<String> outputView, String sql, scala.collection.immutable.Map<String, String> sqlParams, boolean persist, scala.collection.immutable.Map<String, String> params) {
        return new ConfigExecuteStage(plugin, id, name, description, inputURI, outputView, sql, sqlParams, persist, params);
    }

    public Option<Tuple10<ConfigExecute, Option<String>, String, Option<String>, URI, Option<String>, String, scala.collection.immutable.Map<String, String>, Object, scala.collection.immutable.Map<String, String>>> unapply(ConfigExecuteStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputURI(), x$0.outputView(), (Object)x$0.sql(), x$0.sqlParams(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ConfigExecuteStage$() {
        MODULE$ = this;
    }
}

