/*
 * Decompiled with CFR 0.152.
 */
package ai.tripl.arc.extract;

import ai.tripl.arc.api.API;
import ai.tripl.arc.extract.StatisticsExtract;
import ai.tripl.arc.extract.StatisticsExtractStage;
import ai.tripl.arc.util.StatisticsUtils$;
import ai.tripl.arc.util.log.logger.Logger;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple11;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StatisticsExtractStage$
implements Serializable {
    public static StatisticsExtractStage$ MODULE$;

    static {
        new StatisticsExtractStage$();
    }

    public Option<Dataset<Row>> execute(StatisticsExtractStage stage, SparkSession spark, Logger logger, API.ARCContext arcContext) {
        BoxedUnit boxedUnit;
        Dataset df = spark.table(stage.inputView());
        Dataset<Row> statisticsDF = StatisticsUtils$.MODULE$.createStatisticsDataframe((Dataset<Row>)df, stage.approximate(), stage.histogram(), stage.hllRelativeSD(), spark, logger);
        if (arcContext.immutableViews()) {
            statisticsDF.createTempView(stage.outputView());
        } else {
            statisticsDF.createOrReplaceTempView(stage.outputView());
        }
        if (!statisticsDF.isStreaming()) {
            if (stage.persist()) {
                spark.catalog().cacheTable(stage.outputView(), arcContext.storageLevel());
                ObjectMapper objectMapper = new ObjectMapper();
                HashMap statisticsMap = (HashMap)objectMapper.readValue(StatisticsUtils$.MODULE$.createStatisticsJSON(statisticsDF, spark, logger), HashMap.class);
                boxedUnit = stage.stageDetail().put((Object)"statistics", (Object)statisticsMap);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply(statisticsDF);
    }

    public StatisticsExtractStage apply(StatisticsExtract plugin, Option<String> id, String name, Option<String> description, String inputView, String outputView, Map<String, String> params, boolean persist, boolean approximate, boolean histogram, double hllRelativeSD) {
        return new StatisticsExtractStage(plugin, id, name, description, inputView, outputView, params, persist, approximate, histogram, hllRelativeSD);
    }

    public Option<Tuple11<StatisticsExtract, Option<String>, String, Option<String>, String, String, Map<String, String>, Object, Object, Object, Object>> unapply(StatisticsExtractStage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.plugin(), x$0.id(), (Object)x$0.name(), x$0.description(), (Object)x$0.inputView(), (Object)x$0.outputView(), x$0.params(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.persist()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.approximate()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.histogram()), (Object)BoxesRunTime.boxToDouble((double)x$0.hllRelativeSD())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StatisticsExtractStage$() {
        MODULE$ = this;
    }
}

