package ai.vyro.imagine.sdk.features.variations

import ai.vyro.imagine.sdk.models.Response
import ai.vyro.imagine.sdk.models.ResponseImpl
import ai.vyro.imagine.sdk.models.response.Image
import ai.vyro.imagine.sdk.models.response.ImageImpl
import ai.vyro.imagine.sdk.models.response.Status
import ai.vyro.imagine.sdk.remote.post
import ai.vyro.imagine.sdk.request.filesOf
import ai.vyro.imagine.sdk.request.parametersOf
import io.ktor.client.HttpClient

private const val ENDPOINT: String = "generations/variations"

class VariationsHandler(
    private val client: HttpClient,
) {
    suspend operator fun invoke(
        imageBytes: ByteArray,
        prompt: String,
        style: Int,
        negPrompt: String? = null,
        cfg: Float? = null,
        seed: Int? = null,
        steps: Int? = null,
        strength: Int? = null,
    ): Response<Image> {
        val (code, data) = client.post(
            endpoint = ENDPOINT,
            body = parametersOf(
                "prompt" to prompt,
                "style_id" to style,
                "negative_prompt" to negPrompt,
                "cfg" to cfg,
                "seed" to seed,
                "steps" to steps,
                "strength" to strength
            ),
            files = filesOf(
                "image" to imageBytes
            )
        )

        if (code != 200) {
            return ResponseImpl(null, Status.fromInt(code), data.decodeToString())
        }

        return ResponseImpl(ImageImpl(data), Status.fromInt(code), null)
    }
}