package ai.vyro.imagine.sdk.plugins

import io.ktor.client.HttpClientConfig
import io.ktor.client.plugins.logging.LogLevel
import io.ktor.client.plugins.logging.Logger
import io.ktor.client.plugins.logging.Logging
import io.ktor.client.plugins.logging.SIMPLE

@Suppress("unused")
object Logging : ImaginePlugin() {
    private var loglevel = Level.HEADERS

    fun level(l: Level) {
        loglevel = l
    }

    override fun HttpClientConfig<*>.configure() {
        install(Logging) {
            logger = Logger.SIMPLE
            level = when (loglevel) {
                Level.ALL -> LogLevel.ALL
                Level.HEADERS -> LogLevel.HEADERS
                Level.BODY -> LogLevel.BODY
                Level.INFO -> LogLevel.INFO
                Level.NONE -> LogLevel.NONE
            }
        }
    }
}

enum class Level {
    ALL,
    HEADERS,
    BODY,
    INFO,
    NONE;
}