package ai.vyro.imagine.sdk.remote

import ai.vyro.imagine.sdk.models.response.Data
import io.ktor.client.HttpClient
import io.ktor.client.request.forms.MultiPartFormDataContent
import io.ktor.client.request.forms.formData
import io.ktor.client.request.post
import io.ktor.client.request.setBody
import io.ktor.client.statement.HttpResponse
import io.ktor.client.statement.readBytes
import io.ktor.http.Headers
import io.ktor.http.HttpHeaders

internal suspend fun HttpClient.post(
    endpoint: String,
    body: Map<String, String>,
    files: Map<String, ByteArray>? = null
): Data {
    val response: HttpResponse = post("https://api.vyro.ai/v1/imagine/api/$endpoint") {
        setBody(MultiPartFormDataContent(
            formData {
                body.forEach { entry ->
                    append(entry.key, entry.value)
                }

                files?.forEach { entry ->
                    append(entry.key, entry.value, Headers.build {
                        append(HttpHeaders.ContentType, "image/jpeg")
                        append(HttpHeaders.ContentDisposition, "filename=${entry.key}.jpeg")
                    })
                }
            }
        ))
    }

    return Data(response.status.value, response.readBytes())
}