package ai.waii;

import ai.waii.clients.accesskey.AccessKey;
import ai.waii.clients.authorization.Authorization;
import ai.waii.clients.chart.Chart;
import ai.waii.clients.chat.Chat;
import ai.waii.clients.database.Database;
import ai.waii.clients.healthcheck.HealthCheck;
import ai.waii.clients.history.History;
import ai.waii.clients.model.LLM;
import ai.waii.clients.query.Query;
import ai.waii.clients.semanticcontext.SemanticContext;
import ai.waii.clients.user.User;

public final class Waii {

    private WaiiHttpClient httpClient;
    private History history;
    private SemanticContext semanticContext;
    private Query query;
    private Database database;
    private AccessKey accessKey;
    private HealthCheck healthCheck;
    private Authorization authorization;
    private LLM llm;
    private User user;
    private Chart chart;
    private Chat chat;

    public Waii(String url, String apiKey) {
        initialize(url, apiKey);
    }

    public void initialize(String url, String apiKey) {
        httpClient = new WaiiHttpClient(url, apiKey);
        history = new History(httpClient);
        semanticContext = new SemanticContext(httpClient);
        query = new Query(httpClient);
        database = new Database(httpClient);
        accessKey = new AccessKey(httpClient);
        healthCheck = new HealthCheck(httpClient);
        authorization = new Authorization(httpClient);
        llm = new LLM(httpClient);
        user = new User(httpClient);
        chart = new Chart(httpClient);
        chat = new Chat(httpClient);
    }

    public WaiiHttpClient getHttpClient() {
        return httpClient;
    }

    public History getHistory() {
        return history;
    }

    public SemanticContext getSemanticContext() {
        return semanticContext;
    }

    public Query getQuery() {
        return query;
    }

    public Database getDatabase() {
        return database;
    }

    public AccessKey getAccessKey() {
        return accessKey;
    }

    public HealthCheck getHealthCheck() {
        return healthCheck;
    }

    public Authorization getAuthorization() {
        return authorization;
    }

    public LLM getLLM() {
        return llm;
    }

    public User getUser() {
        return user;
    }

    public Chart getChart() {
        return chart;
    }

    public Chat getChat() {
        return chat;
    }
}

