package ai.waii.clients.chart;

import java.util.List;
import java.util.Map;

import com.google.gson.annotations.SerializedName;

import ai.waii.clients.database.Column;
import waii.ai.clients.LLMBasedRequest;

public class ChartGenerationRequest extends LLMBasedRequest {

    private String sql;
    private String ask;
    @SerializedName("dataframe_rows")
    private List<Map<String, Object>> dataframeRows;
    @SerializedName("dataframe_cols")
    private List<Column> dataframeCols;
    @SerializedName("chart_type")
    private ChartType chartType;
    @SerializedName("parent_uuid")
    private String parentUuid;
    @SerializedName("tweak_history")
    private List<ChartTweak> tweakHistory;

    // Getters and Setters
    public String getSql() {
        return sql;
    }

    public ChartGenerationRequest setSql(String sql) {
        this.sql = sql;
        return this;
    }

    public String getAsk() {
        return ask;
    }

    public ChartGenerationRequest setAsk(String ask) {
        this.ask = ask;
        return this;
    }

    public List<Map<String, Object>> getDataframeRows() {
        return dataframeRows;
    }

    public ChartGenerationRequest setDataframeRows(List<Map<String, Object>> dataframeRows) {
        this.dataframeRows = dataframeRows;
        return this;
    }

    public List<Column> getDataframeCols() {
        return dataframeCols;
    }

    public ChartGenerationRequest setDataframeCols(List<Column> dataframeCols) {
        this.dataframeCols = dataframeCols;
        return this;
    }

    public ChartType getChartType() {
        return chartType;
    }

    public ChartGenerationRequest setChartType(ChartType chartType) {
        this.chartType = chartType;
        return this;
    }

    public String getParentUuid() {
        return parentUuid;
    }

    public ChartGenerationRequest setParentUuid(String parentUuid) {
        this.parentUuid = parentUuid;
        return this;
    }

    public List<ChartTweak> getTweakHistory() {
        return tweakHistory;
    }

    public ChartGenerationRequest setTweakHistory(List<ChartTweak> tweakHistory) {
        this.tweakHistory = tweakHistory;
        return this;
    }
}
