package ai.waii.clients.chat;

import java.io.IOException;

import ai.waii.clients.AsyncObjectResponse;
import ai.waii.clients.GetObjectRequest;
import ai.waii.clients.chart.Chart;
import ai.waii.clients.chart.ChartSpec;
import com.google.gson.Gson;

import ai.waii.WaiiHttpClient;
import com.google.gson.GsonBuilder;

public class Chat {

    private final WaiiHttpClient httpClient;
    private static final String CHAT_ENDPOINT = "chat-message";
    private static final String SUBMIT_CHAT_ENDPOINT = "submit-chat-message";
    private static final String GET_CHAT_ENDPOINT = "get-chat-response";

    public Chat(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ChatResponse chat(ChatRequest params) throws IOException {
        Gson gson = new GsonBuilder()
                .registerTypeAdapter(ChartSpec.class, new Chart.ChartSpecDeserializer())
                .create();
        String jsonParams = gson.toJson(params);
        String jsonResponse  = this.httpClient.commonFetchRaw(CHAT_ENDPOINT, jsonParams);
        return gson.fromJson(jsonResponse, ChatResponse.class);
    }

    public AsyncObjectResponse submitChat(ChatRequest params) throws IOException {
        Gson gson = new GsonBuilder()
                .registerTypeAdapter(ChartSpec.class, new Chart.ChartSpecDeserializer())
                .create();
        String jsonParams = gson.toJson(params);
        return this.httpClient.commonFetch(SUBMIT_CHAT_ENDPOINT, jsonParams, AsyncObjectResponse.class);
    }

    public ChatResponse getChatResponse(GetObjectRequest params) throws IOException {
        Gson gson = new GsonBuilder()
                .registerTypeAdapter(ChartSpec.class, new Chart.ChartSpecDeserializer())
                .create();
        String jsonParams = gson.toJson(params);
        String jsonResponse = this.httpClient.commonFetchRaw(GET_CHAT_ENDPOINT, jsonParams);
        return gson.fromJson(jsonResponse, ChatResponse.class);
    }
}
