package ai.waii.clients.history;

import java.io.IOException;
import java.lang.reflect.Type;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

import ai.waii.WaiiHttpClient;

public class History {

    private final WaiiHttpClient httpClient;
    private static final String GET_ENDPOINT = "get-generated-query-history";

    public History(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public GetGeneratedQueryHistoryResponse list(GetGeneratedQueryHistoryRequest params) throws IOException {
        Gson gson = new Gson().newBuilder()
            .registerTypeAdapter(HistoryEntry.class, new HistoryEntryDeserializer())
            .create();
        String jsonParams = gson.toJson(params);
        return gson.fromJson(this.httpClient.commonFetchRaw(GET_ENDPOINT, jsonParams), GetGeneratedQueryHistoryResponse.class);
    }

    public static class HistoryEntryDeserializer implements JsonDeserializer<HistoryEntry> {

    @Override
    public HistoryEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement typeElement = jsonObject.get("history_type");

        if (typeElement != null) {
            String historyType = typeElement.getAsString();

            switch (historyType) {
                case "query":
                    return context.deserialize(json, GeneratedQueryHistoryEntry.class);
                case "chart":
                    return context.deserialize(json, GeneratedChartHistoryEntry.class);
                case "chat":
                    return context.deserialize(json, GeneratedChatHistoryEntry.class);
                default:
                    throw new JsonParseException("Unknown element type: " + historyType);
            }
        }

        throw new JsonParseException("history_type field is missing");
    }
}
}
