package ai.waii.clients.semanticcontext;

import com.google.gson.annotations.SerializedName;

import waii.ai.clients.LLMBasedRequest;

public class GetSemanticContextRequest extends LLMBasedRequest {

    private GetSemanticContextRequestFilter filter;
    @SerializedName("search_text")
    private String searchText;
    private int offset;
    private int limit;

    public GetSemanticContextRequestFilter getFilter() {
        return filter;
    }

    public GetSemanticContextRequest setFilter(GetSemanticContextRequestFilter filter) {
        this.filter = filter;
        return this;
    }

    public String getSearchText() {
        return searchText;
    }

    public GetSemanticContextRequest setSearchText(String searchText) {
        this.searchText = searchText;
        return this;
    }

    public int getOffset() {
        return offset;
    }

    public GetSemanticContextRequest setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLimit() {
        return limit;
    }

    public GetSemanticContextRequest setLimit(int limit) {
        this.limit = limit;
        return this;
    }
}
